/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.html.json.spi;

import java.io.IOException;
import java.io.InputStream;
import net.java.html.json.Context;
import org.apidesign.html.json.impl.ContextAccessor;
import org.apidesign.html.json.spi.FunctionBinding;
import org.apidesign.html.json.spi.JSONCall;
import org.apidesign.html.json.spi.PropertyBinding;
import org.apidesign.html.json.spi.Technology;
import org.apidesign.html.json.spi.Transfer;

public final class ContextBuilder {
    private Technology<?> t;
    private Transfer r;

    private ContextBuilder() {
        EmptyTech et;
        this.t = et = new EmptyTech();
        this.r = et;
    }

    public static ContextBuilder create() {
        return new ContextBuilder();
    }

    public ContextBuilder withTechnology(Technology<?> technology) {
        this.t = technology;
        return this;
    }

    public ContextBuilder withTransfer(Transfer transfer) {
        this.r = transfer;
        return this;
    }

    public Context build() {
        return ContextAccessor.create(this.t, this.r);
    }

    private static final class EmptyTech
    implements Technology<Object>,
    Transfer {
        private EmptyTech() {
        }

        @Override
        public Object wrapModel(Object model) {
            return model;
        }

        @Override
        public void valueHasMutated(Object data, String propertyName) {
        }

        @Override
        public void bind(PropertyBinding b, Object model, Object data) {
        }

        @Override
        public void expose(FunctionBinding fb, Object model, Object d) {
        }

        @Override
        public void applyBindings(Object data) {
        }

        @Override
        public Object wrapArray(Object[] arr) {
            return arr;
        }

        @Override
        public void extract(Object obj, String[] props, Object[] values) {
            for (int i = 0; i < values.length; ++i) {
                values[i] = null;
            }
        }

        @Override
        public void loadJSON(JSONCall call) {
            call.notifyError(new UnsupportedOperationException());
        }

        @Override
        public <M> M toModel(Class<M> modelClass, Object data) {
            return modelClass.cast(data);
        }

        @Override
        public Object toJSON(InputStream is) throws IOException {
            throw new IOException("Not supported");
        }
    }
}

