/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.calc;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apfloat.calc.AbstractCalculatorImpl;
import org.apfloat.calc.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FunctionCalculatorImpl
extends AbstractCalculatorImpl {
    private Map<String, Function> functions = new HashMap<String, Function>();

    protected FunctionCalculatorImpl() {
        this.setFunction("negate", new FixedFunction("negate", 1){

            @Override
            protected Number call(Functions functions, List<Number> arguments) {
                return functions.negate(arguments.get(0));
            }
        });
        this.setFunction("add", new FixedFunction("add", 2){

            @Override
            protected Number call(Functions functions, List<Number> arguments) {
                return functions.add(arguments.get(0), arguments.get(1));
            }
        });
        this.setFunction("subtract", new FixedFunction("subtract", 2){

            @Override
            protected Number call(Functions functions, List<Number> arguments) {
                return functions.subtract(arguments.get(0), arguments.get(1));
            }
        });
        this.setFunction("multiply", new FixedFunction("multiply", 2){

            @Override
            protected Number call(Functions functions, List<Number> arguments) {
                return functions.multiply(arguments.get(0), arguments.get(1));
            }
        });
        this.setFunction("divide", new FixedFunction("divide", 2){

            @Override
            protected Number call(Functions functions, List<Number> arguments) {
                return functions.divide(arguments.get(0), arguments.get(1));
            }
        });
        this.setFunction("mod", new FixedFunction("mod", 2){

            @Override
            protected Number call(Functions functions, List<Number> arguments) {
                return functions.mod(arguments.get(0), arguments.get(1));
            }
        });
        this.setFunction("pow", new FixedFunction("pow", 2){

            @Override
            protected Number call(Functions functions, List<Number> arguments) {
                return functions.pow(arguments.get(0), arguments.get(1));
            }
        });
        this.setFunction("abs", new FixedFunction("abs", 1){

            @Override
            protected Number call(Functions functions, List<Number> arguments) {
                return functions.abs(arguments.get(0));
            }
        });
        this.setFunction("acos", new FixedFunction("acos", 1){

            @Override
            protected Number call(Functions functions, List<Number> arguments) {
                return functions.acos(arguments.get(0));
            }
        });
        this.setFunction("acosh", new FixedFunction("acosh", 1){

            @Override
            protected Number call(Functions functions, List<Number> arguments) {
                return functions.acosh(arguments.get(0));
            }
        });
        this.setFunction("asin", new FixedFunction("asin", 1){

            @Override
            protected Number call(Functions functions, List<Number> arguments) {
                return functions.asin(arguments.get(0));
            }
        });
        this.setFunction("asinh", new FixedFunction("asinh", 1){

            @Override
            protected Number call(Functions functions, List<Number> arguments) {
                return functions.asinh(arguments.get(0));
            }
        });
        this.setFunction("atan", new FixedFunction("atan", 1){

            @Override
            protected Number call(Functions functions, List<Number> arguments) {
                return functions.atan(arguments.get(0));
            }
        });
        this.setFunction("atanh", new FixedFunction("atanh", 1){

            @Override
            protected Number call(Functions functions, List<Number> arguments) {
                return functions.atanh(arguments.get(0));
            }
        });
        this.setFunction("cbrt", new FixedFunction("cbrt", 1){

            @Override
            protected Number call(Functions functions, List<Number> arguments) {
                return functions.cbrt(arguments.get(0));
            }
        });
        this.setFunction("ceil", new FixedFunction("ceil", 1){

            @Override
            protected Number call(Functions functions, List<Number> arguments) {
                return functions.ceil(arguments.get(0));
            }
        });
        this.setFunction("cos", new FixedFunction("cos", 1){

            @Override
            protected Number call(Functions functions, List<Number> arguments) {
                return functions.cos(arguments.get(0));
            }
        });
        this.setFunction("cosh", new FixedFunction("cosh", 1){

            @Override
            protected Number call(Functions functions, List<Number> arguments) {
                return functions.cosh(arguments.get(0));
            }
        });
        this.setFunction("exp", new FixedFunction("exp", 1){

            @Override
            protected Number call(Functions functions, List<Number> arguments) {
                return functions.exp(arguments.get(0));
            }
        });
        this.setFunction("factorial", new FixedFunction("factorial", 1){

            @Override
            protected Number call(Functions functions, List<Number> arguments) {
                return functions.factorial(arguments.get(0));
            }
        });
        this.setFunction("floor", new FixedFunction("floor", 1){

            @Override
            protected Number call(Functions functions, List<Number> arguments) {
                return functions.floor(arguments.get(0));
            }
        });
        this.setFunction("log", new FixedFunction("log", 1, 2){

            @Override
            protected Number call(Functions functions, List<Number> arguments) {
                return arguments.size() == 1 ? (Number)functions.log(arguments.get(0)) : (Number)functions.log(arguments.get(0), arguments.get(1));
            }
        });
        this.setFunction("pi", new FixedFunction("pi", 1){

            @Override
            protected Number call(Functions functions, List<Number> arguments) {
                return functions.pi(arguments.get(0));
            }
        });
        this.setFunction("sin", new FixedFunction("sin", 1){

            @Override
            protected Number call(Functions functions, List<Number> arguments) {
                return functions.sin(arguments.get(0));
            }
        });
        this.setFunction("sinh", new FixedFunction("sinh", 1){

            @Override
            protected Number call(Functions functions, List<Number> arguments) {
                return functions.sinh(arguments.get(0));
            }
        });
        this.setFunction("sqrt", new FixedFunction("sqrt", 1){

            @Override
            protected Number call(Functions functions, List<Number> arguments) {
                return functions.sqrt(arguments.get(0));
            }
        });
        this.setFunction("tan", new FixedFunction("tan", 1){

            @Override
            protected Number call(Functions functions, List<Number> arguments) {
                return functions.tan(arguments.get(0));
            }
        });
        this.setFunction("tanh", new FixedFunction("tanh", 1){

            @Override
            protected Number call(Functions functions, List<Number> arguments) {
                return functions.tanh(arguments.get(0));
            }
        });
        this.setFunction("truncate", new FixedFunction("truncate", 1){

            @Override
            protected Number call(Functions functions, List<Number> arguments) {
                return functions.truncate(arguments.get(0));
            }
        });
        this.setFunction("arg", new FixedFunction("arg", 1){

            @Override
            protected Number call(Functions functions, List<Number> arguments) {
                return functions.arg(arguments.get(0));
            }
        });
        this.setFunction("conj", new FixedFunction("conj", 1){

            @Override
            protected Number call(Functions functions, List<Number> arguments) {
                return functions.conj(arguments.get(0));
            }
        });
        this.setFunction("imag", new FixedFunction("imag", 1){

            @Override
            protected Number call(Functions functions, List<Number> arguments) {
                return functions.imag(arguments.get(0));
            }
        });
        this.setFunction("real", new FixedFunction("real", 1){

            @Override
            protected Number call(Functions functions, List<Number> arguments) {
                return functions.real(arguments.get(0));
            }
        });
        this.setFunction("agm", new FixedFunction("agm", 2){

            @Override
            protected Number call(Functions functions, List<Number> arguments) {
                return functions.agm(arguments.get(0), arguments.get(1));
            }
        });
        this.setFunction("atan2", new FixedFunction("atan2", 2){

            @Override
            protected Number call(Functions functions, List<Number> arguments) {
                return functions.atan2(arguments.get(0), arguments.get(1));
            }
        });
        this.setFunction("copySign", new FixedFunction("copySign", 2){

            @Override
            protected Number call(Functions functions, List<Number> arguments) {
                return functions.copySign(arguments.get(0), arguments.get(1));
            }
        });
        this.setFunction("fmod", new FixedFunction("fmod", 2){

            @Override
            protected Number call(Functions functions, List<Number> arguments) {
                return functions.fmod(arguments.get(0), arguments.get(1));
            }
        });
        this.setFunction("gcd", new FixedFunction("gcd", 2){

            @Override
            protected Number call(Functions functions, List<Number> arguments) {
                return functions.gcd(arguments.get(0), arguments.get(1));
            }
        });
        this.setFunction("hypot", new FixedFunction("hypot", 2){

            @Override
            protected Number call(Functions functions, List<Number> arguments) {
                return functions.hypot(arguments.get(0), arguments.get(1));
            }
        });
        this.setFunction("inverseRoot", new FixedFunction("inverseRoot", 2, 3){

            @Override
            protected Number call(Functions functions, List<Number> arguments) {
                return arguments.size() == 2 ? (Number)functions.inverseRoot(arguments.get(0), arguments.get(1)) : (Number)functions.inverseRoot(arguments.get(0), arguments.get(1), arguments.get(2));
            }
        });
        this.setFunction("lcm", new FixedFunction("lcm", 2){

            @Override
            protected Number call(Functions functions, List<Number> arguments) {
                return functions.lcm(arguments.get(0), arguments.get(1));
            }
        });
        this.setFunction("root", new FixedFunction("root", 2, 3){

            @Override
            protected Number call(Functions functions, List<Number> arguments) {
                return arguments.size() == 2 ? (Number)functions.root(arguments.get(0), arguments.get(1)) : (Number)functions.root(arguments.get(0), arguments.get(1), arguments.get(2));
            }
        });
        this.setFunction("scale", new FixedFunction("scale", 2){

            @Override
            protected Number call(Functions functions, List<Number> arguments) {
                return functions.scale(arguments.get(0), arguments.get(1));
            }
        });
        this.setFunction("n", new FixedFunction("precision", 2){

            @Override
            protected Number call(Functions functions, List<Number> arguments) {
                return functions.precision(arguments.get(0), arguments.get(1));
            }
        });
    }

    @Override
    public Number function(String name, List<Number> arguments) throws ParseException {
        Function function = this.functions.get(name);
        if (function == null) {
            throw new ParseException("Invalid function: " + name);
        }
        return function.call(arguments);
    }

    private Functions getFunctions(List<Number> arguments) {
        Object functions = null;
        for (Number argument : arguments) {
            Functions functions2 = this.getFunctions(argument);
            functions = functions != null && functions.getClass().isAssignableFrom(functions2.getClass()) ? functions : functions2;
        }
        return functions;
    }

    protected void setFunction(String name, Function function) {
        this.functions.put(name, function);
    }

    protected abstract Functions getFunctions(Number var1);

    protected abstract Number promote(Number var1);

    protected static interface Functions {
        public Number negate(Number var1);

        public Number add(Number var1, Number var2);

        public Number subtract(Number var1, Number var2);

        public Number multiply(Number var1, Number var2);

        public Number divide(Number var1, Number var2);

        public Number mod(Number var1, Number var2);

        public Number pow(Number var1, Number var2);

        public Number arg(Number var1);

        public Number conj(Number var1);

        public Number imag(Number var1);

        public Number real(Number var1);

        public Number abs(Number var1);

        public Number acos(Number var1);

        public Number acosh(Number var1);

        public Number asin(Number var1);

        public Number asinh(Number var1);

        public Number atan(Number var1);

        public Number atanh(Number var1);

        public Number cbrt(Number var1);

        public Number ceil(Number var1);

        public Number cos(Number var1);

        public Number cosh(Number var1);

        public Number exp(Number var1);

        public Number factorial(Number var1);

        public Number floor(Number var1);

        public Number log(Number var1);

        public Number log(Number var1, Number var2);

        public Number pi(Number var1);

        public Number sin(Number var1);

        public Number sinh(Number var1);

        public Number sqrt(Number var1);

        public Number tan(Number var1);

        public Number tanh(Number var1);

        public Number truncate(Number var1);

        public Number agm(Number var1, Number var2);

        public Number atan2(Number var1, Number var2);

        public Number copySign(Number var1, Number var2);

        public Number fmod(Number var1, Number var2);

        public Number gcd(Number var1, Number var2);

        public Number hypot(Number var1, Number var2);

        public Number inverseRoot(Number var1, Number var2);

        public Number inverseRoot(Number var1, Number var2, Number var3);

        public Number lcm(Number var1, Number var2);

        public Number root(Number var1, Number var2);

        public Number root(Number var1, Number var2, Number var3);

        public Number scale(Number var1, Number var2);

        public Number precision(Number var1, Number var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class FixedFunction
    implements Function {
        private String name;
        private int minArguments;
        private int maxArguments;

        protected FixedFunction(String name, int arguments) {
            this(name, arguments, arguments);
        }

        protected FixedFunction(String name, int minArguments, int maxArguments) {
            this.name = name;
            this.minArguments = minArguments;
            this.maxArguments = maxArguments;
        }

        protected void validate(List<Number> arguments) throws ParseException {
            if (this.minArguments == this.maxArguments && arguments.size() != this.minArguments) {
                throw new ParseException("Function " + this.name + " takes " + this.minArguments + " argument" + (this.minArguments == 1 ? "" : "s") + ", not " + arguments.size());
            }
            if (arguments.size() < this.minArguments || arguments.size() > this.maxArguments) {
                throw new ParseException("Function " + this.name + " takes " + this.minArguments + " to " + this.maxArguments + " arguments, not " + arguments.size());
            }
        }

        @Override
        public final Number call(List<Number> arguments) throws ParseException {
            this.validate(arguments);
            return FunctionCalculatorImpl.this.promote(this.call(FunctionCalculatorImpl.this.getFunctions(arguments), arguments));
        }

        protected abstract Number call(Functions var1, List<Number> var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface Function
    extends Serializable {
        public Number call(List<Number> var1) throws ParseException;
    }
}

