/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.calc;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apfloat.calc.AbstractCalculatorImpl;
import org.apfloat.calc.ParseException;

public abstract class FunctionCalculatorImpl
extends AbstractCalculatorImpl {
    private static final long serialVersionUID = 1L;
    private Map<String, Function> functions = new HashMap<String, Function>();

    protected FunctionCalculatorImpl() {
        this.setFunction("negate", this.fixedFunction("negate", 1, (functions, arguments) -> functions.negate((Number)arguments.get(0))));
        this.setFunction("add", this.fixedFunction("add", 2, (functions, arguments) -> functions.add((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("subtract", this.fixedFunction("subtract", 2, (functions, arguments) -> functions.subtract((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("multiply", this.fixedFunction("multiply", 2, (functions, arguments) -> functions.multiply((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("divide", this.fixedFunction("divide", 2, (functions, arguments) -> functions.divide((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("mod", this.fixedFunction("mod", 2, (functions, arguments) -> functions.mod((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("pow", this.fixedFunction("pow", 2, (functions, arguments) -> functions.pow((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("abs", this.fixedFunction("abs", 1, (functions, arguments) -> functions.abs((Number)arguments.get(0))));
        this.setFunction("acos", this.fixedFunction("acos", 1, (functions, arguments) -> functions.acos((Number)arguments.get(0))));
        this.setFunction("acosh", this.fixedFunction("acosh", 1, (functions, arguments) -> functions.acosh((Number)arguments.get(0))));
        this.setFunction("asin", this.fixedFunction("asin", 1, (functions, arguments) -> functions.asin((Number)arguments.get(0))));
        this.setFunction("asinh", this.fixedFunction("asinh", 1, (functions, arguments) -> functions.asinh((Number)arguments.get(0))));
        this.setFunction("atan", this.fixedFunction("atan", 1, (functions, arguments) -> functions.atan((Number)arguments.get(0))));
        this.setFunction("atanh", this.fixedFunction("atanh", 1, (functions, arguments) -> functions.atanh((Number)arguments.get(0))));
        this.setFunction("bernoulli", this.fixedFunction("bernoulli", 1, (functions, arguments) -> functions.bernoulli((Number)arguments.get(0))));
        this.setFunction("binomial", this.fixedFunction("binomial", 2, (functions, arguments) -> functions.binomial((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("catalan", this.fixedFunction("catalan", 1, (functions, arguments) -> functions.catalan((Number)arguments.get(0))));
        this.setFunction("cbrt", this.fixedFunction("cbrt", 1, (functions, arguments) -> functions.cbrt((Number)arguments.get(0))));
        this.setFunction("ceil", this.fixedFunction("ceil", 1, (functions, arguments) -> functions.ceil((Number)arguments.get(0))));
        this.setFunction("cos", this.fixedFunction("cos", 1, (functions, arguments) -> functions.cos((Number)arguments.get(0))));
        this.setFunction("cosh", this.fixedFunction("cosh", 1, (functions, arguments) -> functions.cosh((Number)arguments.get(0))));
        this.setFunction("digamma", this.fixedFunction("digamma", 1, (functions, arguments) -> functions.digamma((Number)arguments.get(0))));
        this.setFunction("e", this.fixedFunction("e", 1, (functions, arguments) -> functions.e((Number)arguments.get(0))));
        this.setFunction("euler", this.fixedFunction("euler", 1, (functions, arguments) -> functions.euler((Number)arguments.get(0))));
        this.setFunction("exp", this.fixedFunction("exp", 1, (functions, arguments) -> functions.exp((Number)arguments.get(0))));
        this.setFunction("factorial", this.fixedFunction("factorial", 1, (functions, arguments) -> functions.factorial((Number)arguments.get(0))));
        this.setFunction("floor", this.fixedFunction("floor", 1, (functions, arguments) -> functions.floor((Number)arguments.get(0))));
        this.setFunction("frac", this.fixedFunction("frac", 1, (functions, arguments) -> functions.frac((Number)arguments.get(0))));
        this.setFunction("gamma", this.fixedFunction("gamma", 1, 3, (functions, arguments) -> arguments.size() == 1 ? (Number)functions.gamma((Number)arguments.get(0)) : (Number)(arguments.size() == 2 ? (Number)functions.gamma((Number)arguments.get(0), (Number)arguments.get(1)) : (Number)functions.gamma((Number)arguments.get(0), (Number)arguments.get(1), (Number)arguments.get(2)))));
        this.setFunction("glaisher", this.fixedFunction("glaisher", 1, (functions, arguments) -> functions.glaisher((Number)arguments.get(0))));
        this.setFunction("hypergeometric0F1", this.fixedFunction("hypergeometric0F1", 2, (functions, arguments) -> functions.hypergeometric0F1((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("hypergeometric1F1", this.fixedFunction("hypergeometric1F1", 3, (functions, arguments) -> functions.hypergeometric1F1((Number)arguments.get(0), (Number)arguments.get(1), (Number)arguments.get(2))));
        this.setFunction("hypergeometric2F1", this.fixedFunction("hypergeometric2F1", 4, (functions, arguments) -> functions.hypergeometric2F1((Number)arguments.get(0), (Number)arguments.get(1), (Number)arguments.get(2), (Number)arguments.get(3))));
        this.setFunction("khinchin", this.fixedFunction("khinchin", 1, (functions, arguments) -> functions.khinchin((Number)arguments.get(0))));
        this.setFunction("log", this.fixedFunction("log", 1, 2, (functions, arguments) -> arguments.size() == 1 ? (Number)functions.log((Number)arguments.get(0)) : (Number)functions.log((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("logGamma", this.fixedFunction("logGamma", 1, (functions, arguments) -> functions.logGamma((Number)arguments.get(0))));
        this.setFunction("max", this.fixedFunction("max", 2, (functions, arguments) -> functions.max((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("min", this.fixedFunction("min", 2, (functions, arguments) -> functions.min((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("nextAfter", this.fixedFunction("nextAfter", 2, (functions, arguments) -> functions.nextAfter((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("nextDown", this.fixedFunction("nextDown", 1, (functions, arguments) -> functions.nextDown((Number)arguments.get(0))));
        this.setFunction("nextUp", this.fixedFunction("nextUp", 1, (functions, arguments) -> functions.nextUp((Number)arguments.get(0))));
        this.setFunction("pi", this.fixedFunction("pi", 1, (functions, arguments) -> functions.pi((Number)arguments.get(0))));
        this.setFunction("random", this.fixedFunction("random", 1, (functions, arguments) -> functions.random((Number)arguments.get(0))));
        this.setFunction("randomGaussian", this.fixedFunction("randomGaussian", 1, (functions, arguments) -> functions.randomGaussian((Number)arguments.get(0))));
        this.setFunction("round", this.fixedFunction("round", 2, (functions, arguments) -> functions.round((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("roundToPrecision", this.fixedFunction("roundToPrecision", 2, (functions, arguments) -> functions.roundToPrecision((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("roundToInteger", this.fixedFunction("roundToInteger", 1, (functions, arguments) -> functions.roundToInteger((Number)arguments.get(0))));
        this.setFunction("roundToPlaces", this.fixedFunction("roundToPlaces", 2, (functions, arguments) -> functions.roundToPlaces((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("roundToMultiple", this.fixedFunction("roundToMultiple", 2, (functions, arguments) -> functions.roundToMultiple((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("sin", this.fixedFunction("sin", 1, (functions, arguments) -> functions.sin((Number)arguments.get(0))));
        this.setFunction("sinh", this.fixedFunction("sinh", 1, (functions, arguments) -> functions.sinh((Number)arguments.get(0))));
        this.setFunction("sqrt", this.fixedFunction("sqrt", 1, (functions, arguments) -> functions.sqrt((Number)arguments.get(0))));
        this.setFunction("tan", this.fixedFunction("tan", 1, (functions, arguments) -> functions.tan((Number)arguments.get(0))));
        this.setFunction("tanh", this.fixedFunction("tanh", 1, (functions, arguments) -> functions.tanh((Number)arguments.get(0))));
        this.setFunction("truncate", this.fixedFunction("truncate", 1, (functions, arguments) -> functions.truncate((Number)arguments.get(0))));
        this.setFunction("toDegrees", this.fixedFunction("toDegrees", 1, (functions, arguments) -> functions.toDegrees((Number)arguments.get(0))));
        this.setFunction("toRadians", this.fixedFunction("toRadians", 1, (functions, arguments) -> functions.toRadians((Number)arguments.get(0))));
        this.setFunction("ulp", this.fixedFunction("ulp", 1, (functions, arguments) -> functions.ulp((Number)arguments.get(0))));
        this.setFunction("zeta", this.fixedFunction("zeta", 1, 2, (functions, arguments) -> arguments.size() == 1 ? (Number)functions.zeta((Number)arguments.get(0)) : (Number)functions.zeta((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("arg", this.fixedFunction("arg", 1, (functions, arguments) -> functions.arg((Number)arguments.get(0))));
        this.setFunction("conj", this.fixedFunction("conj", 1, (functions, arguments) -> functions.conj((Number)arguments.get(0))));
        this.setFunction("imag", this.fixedFunction("imag", 1, (functions, arguments) -> functions.imag((Number)arguments.get(0))));
        this.setFunction("real", this.fixedFunction("real", 1, (functions, arguments) -> functions.real((Number)arguments.get(0))));
        this.setFunction("agm", this.fixedFunction("agm", 2, (functions, arguments) -> functions.agm((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("w", this.fixedFunction("w", 1, 2, (functions, arguments) -> arguments.size() == 1 ? (Number)functions.w((Number)arguments.get(0)) : (Number)functions.w((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("atan2", this.fixedFunction("atan2", 2, (functions, arguments) -> functions.atan2((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("copySign", this.fixedFunction("copySign", 2, (functions, arguments) -> functions.copySign((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("fmod", this.fixedFunction("fmod", 2, (functions, arguments) -> functions.fmod((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("gcd", this.fixedFunction("gcd", 2, (functions, arguments) -> functions.gcd((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("hypot", this.fixedFunction("hypot", 2, (functions, arguments) -> functions.hypot((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("inverseRoot", this.fixedFunction("inverseRoot", 2, 3, (functions, arguments) -> arguments.size() == 2 ? (Number)functions.inverseRoot((Number)arguments.get(0), (Number)arguments.get(1)) : (Number)functions.inverseRoot((Number)arguments.get(0), (Number)arguments.get(1), (Number)arguments.get(2))));
        this.setFunction("lcm", this.fixedFunction("lcm", 2, (functions, arguments) -> functions.lcm((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("root", this.fixedFunction("root", 2, 3, (functions, arguments) -> arguments.size() == 2 ? (Number)functions.root((Number)arguments.get(0), (Number)arguments.get(1)) : (Number)functions.root((Number)arguments.get(0), (Number)arguments.get(1), (Number)arguments.get(2))));
        this.setFunction("scale", this.fixedFunction("scale", 2, (functions, arguments) -> functions.scale((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("n", this.fixedFunction("precision", 2, (functions, arguments) -> functions.precision((Number)arguments.get(0), (Number)arguments.get(1))));
    }

    @Override
    public Number function(String name, List<Number> arguments) throws ParseException {
        Function function = this.functions.get(name);
        if (function == null) {
            throw new ParseException("Invalid function: " + name);
        }
        return function.call(arguments);
    }

    private Functions getFunctions(List<Number> arguments) {
        Object functions = null;
        for (Number argument : arguments) {
            Functions functions2 = this.getFunctions(argument);
            functions = functions != null && functions.getClass().isAssignableFrom(functions2.getClass()) ? functions : functions2;
        }
        return functions;
    }

    protected FixedFunction fixedFunction(String name, int arguments, FixedFunctionHandler handler) {
        return this.fixedFunction(name, arguments, arguments, handler);
    }

    protected FixedFunction fixedFunction(String name, int minArguments, int maxArguments, FixedFunctionHandler handler) {
        FixedFunction fixedFunction = new FixedFunction();
        fixedFunction.name = name;
        fixedFunction.minArguments = minArguments;
        fixedFunction.maxArguments = maxArguments;
        fixedFunction.handler = handler;
        return fixedFunction;
    }

    protected void setFunction(String name, Function function) {
        this.functions.put(name, function);
    }

    protected abstract Functions getFunctions(Number var1);

    protected abstract Number promote(Number var1);

    protected static interface Functions {
        public Number negate(Number var1);

        public Number add(Number var1, Number var2);

        public Number subtract(Number var1, Number var2);

        public Number multiply(Number var1, Number var2);

        public Number divide(Number var1, Number var2);

        public Number mod(Number var1, Number var2);

        public Number pow(Number var1, Number var2);

        public Number arg(Number var1);

        public Number conj(Number var1);

        public Number imag(Number var1);

        public Number real(Number var1);

        public Number abs(Number var1);

        public Number acos(Number var1);

        public Number acosh(Number var1);

        public Number asin(Number var1);

        public Number asinh(Number var1);

        public Number atan(Number var1);

        public Number atanh(Number var1);

        public Number bernoulli(Number var1);

        public Number binomial(Number var1, Number var2);

        public Number catalan(Number var1);

        public Number cbrt(Number var1);

        public Number ceil(Number var1);

        public Number cos(Number var1);

        public Number cosh(Number var1);

        public Number digamma(Number var1);

        public Number e(Number var1);

        public Number euler(Number var1);

        public Number exp(Number var1);

        public Number factorial(Number var1);

        public Number floor(Number var1);

        public Number frac(Number var1);

        public Number gamma(Number var1);

        public Number gamma(Number var1, Number var2);

        public Number gamma(Number var1, Number var2, Number var3);

        public Number hypergeometric0F1(Number var1, Number var2);

        public Number hypergeometric1F1(Number var1, Number var2, Number var3);

        public Number hypergeometric2F1(Number var1, Number var2, Number var3, Number var4);

        public Number glaisher(Number var1);

        public Number khinchin(Number var1);

        public Number log(Number var1);

        public Number log(Number var1, Number var2);

        public Number logGamma(Number var1);

        public Number max(Number var1, Number var2);

        public Number min(Number var1, Number var2);

        public Number nextAfter(Number var1, Number var2);

        public Number nextDown(Number var1);

        public Number nextUp(Number var1);

        public Number pi(Number var1);

        public Number random(Number var1);

        public Number randomGaussian(Number var1);

        @Deprecated
        public Number round(Number var1, Number var2);

        public Number roundToPrecision(Number var1, Number var2);

        public Number roundToInteger(Number var1);

        public Number roundToPlaces(Number var1, Number var2);

        public Number roundToMultiple(Number var1, Number var2);

        public Number sin(Number var1);

        public Number sinh(Number var1);

        public Number sqrt(Number var1);

        public Number tan(Number var1);

        public Number tanh(Number var1);

        public Number truncate(Number var1);

        public Number toDegrees(Number var1);

        public Number toRadians(Number var1);

        public Number ulp(Number var1);

        public Number zeta(Number var1);

        public Number zeta(Number var1, Number var2);

        public Number agm(Number var1, Number var2);

        public Number w(Number var1);

        public Number w(Number var1, Number var2);

        public Number atan2(Number var1, Number var2);

        public Number copySign(Number var1, Number var2);

        public Number fmod(Number var1, Number var2);

        public Number gcd(Number var1, Number var2);

        public Number hypot(Number var1, Number var2);

        public Number inverseRoot(Number var1, Number var2);

        public Number inverseRoot(Number var1, Number var2, Number var3);

        public Number lcm(Number var1, Number var2);

        public Number root(Number var1, Number var2);

        public Number root(Number var1, Number var2, Number var3);

        public Number scale(Number var1, Number var2);

        public Number precision(Number var1, Number var2);
    }

    @FunctionalInterface
    protected static interface FixedFunctionHandler
    extends Serializable {
        public Number call(Functions var1, List<Number> var2);
    }

    protected class FixedFunction
    implements Function {
        private static final long serialVersionUID = 1L;
        private String name;
        private int minArguments;
        private int maxArguments;
        private FixedFunctionHandler handler;

        protected FixedFunction() {
        }

        protected void validate(List<Number> arguments) throws ParseException {
            if (this.minArguments == this.maxArguments && arguments.size() != this.minArguments) {
                throw new ParseException("Function " + this.name + " takes " + this.minArguments + " argument" + (this.minArguments == 1 ? "" : "s") + ", not " + arguments.size());
            }
            if (arguments.size() < this.minArguments || arguments.size() > this.maxArguments) {
                throw new ParseException("Function " + this.name + " takes " + this.minArguments + " to " + this.maxArguments + " arguments, not " + arguments.size());
            }
        }

        @Override
        public final Number call(List<Number> arguments) throws ParseException {
            this.validate(arguments);
            return FunctionCalculatorImpl.this.promote(this.handler.call(FunctionCalculatorImpl.this.getFunctions(arguments), arguments));
        }
    }

    @FunctionalInterface
    protected static interface Function
    extends Serializable {
        public Number call(List<Number> var1) throws ParseException;
    }
}

