/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.calc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apfloat.calc.CalculatorImpl;
import org.apfloat.calc.ParseException;

public abstract class AbstractCalculatorImpl
implements CalculatorImpl,
Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, Number> variables = new HashMap<String, Number>();
    private boolean pretty = false;
    private Long inputPrecision;

    protected AbstractCalculatorImpl() {
    }

    @Override
    public Number negate(Number x) throws ParseException {
        return this.function("negate", AbstractCalculatorImpl.toList(x));
    }

    @Override
    public Number add(Number x, Number y) throws ParseException {
        return this.function("add", AbstractCalculatorImpl.toList(x, y));
    }

    @Override
    public Number subtract(Number x, Number y) throws ParseException {
        return this.function("subtract", AbstractCalculatorImpl.toList(x, y));
    }

    @Override
    public Number multiply(Number x, Number y) throws ParseException {
        return this.function("multiply", AbstractCalculatorImpl.toList(x, y));
    }

    @Override
    public Number divide(Number x, Number y) throws ParseException {
        return this.function("divide", AbstractCalculatorImpl.toList(x, y));
    }

    @Override
    public Number mod(Number x, Number y) throws ParseException {
        return this.function("mod", AbstractCalculatorImpl.toList(x, y));
    }

    @Override
    public Number pow(Number x, Number y) throws ParseException {
        return this.function("pow", AbstractCalculatorImpl.toList(x, y));
    }

    @Override
    public Number getVariable(String name) throws ParseException {
        Number variable = this.variables.get(name);
        if (variable == null) {
            throw new ParseException("Invalid variable: " + name);
        }
        return variable;
    }

    @Override
    public void setVariable(String name, Number value) {
        this.variables.put(name, value);
    }

    @Override
    public void setFormat(boolean pretty) {
        this.pretty = pretty;
    }

    @Override
    public void setInputPrecision(Long inputPrecision) {
        this.inputPrecision = inputPrecision;
    }

    protected boolean getFormat() {
        return this.pretty;
    }

    protected Long getInputPrecision() {
        return this.inputPrecision;
    }

    private static List<Number> toList(Number x) {
        ArrayList<Number> list = new ArrayList<Number>();
        list.add(x);
        return list;
    }

    private static List<Number> toList(Number x, Number y) {
        ArrayList<Number> list = new ArrayList<Number>();
        list.add(x);
        list.add(y);
        return list;
    }
}

