/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.aparapi;

import com.aparapi.Range;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.aparapi.LongKernel;
import org.apfloat.aparapi.RangeHelper;
import org.apfloat.internal.LongModConstants;
import org.apfloat.internal.LongNTTStepStrategy;
import org.apfloat.internal.LongWTables;
import org.apfloat.internal.Scramble;
import org.apfloat.spi.ArrayAccess;

public class LongAparapiNTTStepStrategy
extends LongNTTStepStrategy {
    public void multiplyElements(ArrayAccess arrayAccess, int startRow, int startColumn, int rows, int columns, long length, long totalTransformLength, boolean isInverse, int modulus) throws ApfloatRuntimeException {
        this.setModulus(LongModConstants.MODULUS[modulus]);
        long w = isInverse ? this.getInverseNthRoot(LongModConstants.PRIMITIVE_ROOT[modulus], length) : this.getForwardNthRoot(LongModConstants.PRIMITIVE_ROOT[modulus], length);
        long scaleFactor = isInverse ? this.modDivide(1L, totalTransformLength) : 1L;
        LongKernel kernel = LongKernel.getInstance();
        kernel.setOp(5);
        kernel.setArrayAccess(arrayAccess);
        kernel.setStartRow(startRow);
        kernel.setStartColumn(startColumn);
        kernel.setRows(rows);
        kernel.setColumns(columns);
        kernel.setW(w);
        kernel.setScaleFactor(scaleFactor);
        kernel.setModulus(LongModConstants.MODULUS[modulus]);
        Range range = RangeHelper.create(columns);
        kernel.execute(range);
    }

    public void transformRows(ArrayAccess arrayAccess, int length, int count, boolean isInverse, boolean permute, int modulus) throws ApfloatRuntimeException {
        long[] wTable = isInverse ? LongWTables.getInverseWTable((int)modulus, (int)length) : LongWTables.getWTable((int)modulus, (int)length);
        int[] permutationTable = permute ? Scramble.createScrambleTable((int)length) : null;
        LongKernel kernel = LongKernel.getInstance();
        kernel.setOp(isInverse ? 2 : 1);
        kernel.setLength(length);
        kernel.setArrayAccess(arrayAccess);
        kernel.setWTable(wTable);
        kernel.setPermutationTable(permutationTable);
        kernel.setModulus(LongModConstants.MODULUS[modulus]);
        kernel.put(wTable);
        if (permutationTable != null) {
            kernel.put(permutationTable);
        }
        Range range = RangeHelper.create(count);
        kernel.execute(range);
    }
}

