/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.aparapi;

import org.apfloat.ApfloatRuntimeException;
import org.apfloat.aparapi.LongKernel;
import org.apfloat.internal.ApfloatInternalException;
import org.apfloat.internal.LongFactor3NTTStepStrategy;
import org.apfloat.internal.LongModConstants;
import org.apfloat.spi.ArrayAccess;
import org.apfloat.spi.DataStorage;

public class LongAparapiFactor3NTTStepStrategy
extends LongFactor3NTTStepStrategy {
    public void transformColumns(DataStorage dataStorage0, DataStorage dataStorage1, DataStorage dataStorage2, long startColumn, long columns, long power2length, long length, boolean isInverse, int modulus) throws ApfloatRuntimeException {
        assert (length == 3L * power2length);
        if (!(dataStorage0.isCached() && dataStorage1.isCached() && dataStorage2.isCached() && startColumn <= Integer.MAX_VALUE && columns <= Integer.MAX_VALUE)) {
            throw new ApfloatInternalException("Data must be stored in memory");
        }
        ArrayAccess arrayAccess0 = dataStorage0.getArray(3, startColumn, (int)columns);
        ArrayAccess arrayAccess1 = dataStorage1.getArray(3, startColumn, (int)columns);
        ArrayAccess arrayAccess2 = dataStorage2.getArray(3, startColumn, (int)columns);
        if (arrayAccess0.getLongData() != arrayAccess1.getLongData() || arrayAccess1.getLongData() != arrayAccess2.getLongData() || (long)arrayAccess1.getOffset() != (long)arrayAccess0.getOffset() + columns || (long)arrayAccess2.getOffset() != (long)arrayAccess1.getOffset() + columns) {
            throw new ApfloatInternalException("Data must be stored consecutively in memory");
        }
        this.setModulus(LongModConstants.MODULUS[modulus]);
        long w = isInverse ? this.getInverseNthRoot(LongModConstants.PRIMITIVE_ROOT[modulus], length) : this.getForwardNthRoot(LongModConstants.PRIMITIVE_ROOT[modulus], length);
        long w3 = this.modPow(w, power2length);
        long ww = this.modMultiply(w, w);
        long w1 = this.negate(this.modDivide(3L, 2L));
        long w2 = this.modAdd(w3, this.modDivide(1L, 2L));
        LongKernel kernel = LongKernel.getInstance();
        kernel.setOp(isInverse ? 7 : 6);
        kernel.setArrayAccess(arrayAccess0);
        kernel.setStartColumn((int)startColumn);
        kernel.setColumns((int)columns);
        kernel.setW(w);
        kernel.setWw(ww);
        kernel.setW1(w1);
        kernel.setW2(w2);
        kernel.setModulus(LongModConstants.MODULUS[modulus]);
        kernel.execute((int)columns);
    }
}

