/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.common.xml.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apertereports.common.xml.XmlHelper;
import org.apertereports.common.xml.config.CyclicReportConfig;
import org.apertereports.common.xml.config.ReportConfig;
import org.apertereports.common.xml.config.ReportConfigParameter;
import org.apertereports.common.xml.config.ReportConfigRoot;
import pl.net.bluesoft.util.lang.StringUtil;

public class XmlReportConfigLoader
extends XmlHelper {
    private static final XmlReportConfigLoader instance = new XmlReportConfigLoader();

    @Override
    protected Class[] getSupportedClasses() {
        return new Class[]{ReportConfigRoot.class, CyclicReportConfig.class, ReportConfig.class, ReportConfigParameter.class};
    }

    public static XmlReportConfigLoader getInstance() {
        return instance;
    }

    public String reportConfigsAsString(List<ReportConfig> reportConfigs) {
        return reportConfigs != null && !reportConfigs.isEmpty() ? this.marshall(new ReportConfigRoot(reportConfigs)) : "";
    }

    public List<ReportConfig> stringAsReportConfigs(String input) {
        ReportConfigRoot root = StringUtil.hasText((String)input) ? (ReportConfigRoot)this.unmarshall(input) : null;
        return root != null ? root.getReportConfigs() : new ArrayList<ReportConfig>();
    }

    public String parametersAsXML(List<ReportConfigParameter> parameters) {
        return parameters != null && !parameters.isEmpty() ? this.marshall(new CyclicReportConfig(parameters)) : "";
    }

    public List<ReportConfigParameter> xmlAsParameters(String xml) {
        CyclicReportConfig root = StringUtil.hasText((String)xml) ? (CyclicReportConfig)XmlReportConfigLoader.getInstance().unmarshall(xml) : null;
        return root != null ? root.getParameters() : new ArrayList<ReportConfigParameter>();
    }

    public Map<String, String> xmlAsMap(String xml) {
        return this.parameterListToMap(this.xmlAsParameters(xml));
    }

    public String mapAsXml(Map<String, String> map) {
        return this.parametersAsXML(this.mapToParameterList(map));
    }

    public List<ReportConfigParameter> mapToParameterList(Map<String, String> map) {
        ArrayList<ReportConfigParameter> list = new ArrayList<ReportConfigParameter>(map.values().size());
        for (Map.Entry<String, String> e : map.entrySet()) {
            ReportConfigParameter p = new ReportConfigParameter();
            p.setName(e.getKey());
            p.setValue(e.getValue());
            list.add(p);
        }
        return list;
    }

    public Map<String, String> parameterListToMap(List<ReportConfigParameter> params) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (params != null && !params.isEmpty()) {
            for (ReportConfigParameter config : params) {
                map.put(config.getName(), config.getValue());
            }
        }
        return map;
    }
}

