/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.common.xml;

import com.thoughtworks.xstream.XStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import pl.net.bluesoft.util.lang.StringUtil;

public abstract class XmlHelper {
    private XStream xstream;
    private Set<Class> supportedClasses;

    protected abstract Class[] getSupportedClasses();

    protected XmlHelper() {
        Class[] classes = this.getSupportedClasses();
        this.xstream = new XStream();
        this.xstream.processAnnotations(classes);
        this.supportedClasses = new HashSet<Class>();
        Collections.addAll(this.supportedClasses, classes);
    }

    public String marshall(Object object) {
        if (object == null || !this.supportedClasses.contains(object.getClass())) {
            throw new IllegalArgumentException("Object of type: " + (object != null ? object.getClass() : "null") + " is not supported!");
        }
        return this.xstream.toXML(object);
    }

    public Object unmarshall(String xml) {
        if (!StringUtil.hasText((String)xml)) {
            throw new IllegalArgumentException("Cannot unmarshall an empty string!");
        }
        return this.xstream.fromXML(xml);
    }

    public Object unmarshall(InputStream stream) {
        if (stream == null) {
            throw new IllegalArgumentException("Cannot unmarshall an empty input stream!");
        }
        return this.xstream.fromXML(stream);
    }
}

