/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.common.wrappers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apertereports.common.wrappers.DictionaryItem;

public class DictionaryItemFilter {
    private List<String>[] columns;

    public DictionaryItemFilter(int columnCount, Map<Integer, Object> filterValues) {
        this.columns = new List[columnCount];
        for (Map.Entry<Integer, Object> filter : filterValues.entrySet()) {
            String string;
            if (filter.getValue() instanceof Collection) {
                Collection col = (Collection)filter.getValue();
                if (col.isEmpty()) continue;
                this.columns[filter.getKey().intValue()] = new ArrayList<String>(col);
                continue;
            }
            if (!(filter.getValue() instanceof String) || !StringUtils.isNotEmpty((String)(string = (String)filter.getValue()))) continue;
            this.columns[filter.getKey().intValue()] = new ArrayList<String>();
            this.columns[filter.getKey()].add(string);
        }
    }

    public boolean appliesTo(Object obj) {
        if (obj instanceof DictionaryItem) {
            int idx = 1;
            for (List<String> list : this.columns) {
                if (list != null && !list.contains(((DictionaryItem)obj).getColumn(idx))) {
                    return false;
                }
                ++idx;
            }
            return true;
        }
        return super.equals(obj);
    }

    public List<String> getColumn(Integer idx) {
        return this.columns[idx];
    }

    public void setColumn(Integer idx, List<String> value) {
        this.columns[idx.intValue()] = value;
    }
}

