/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.common.utils;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apertereports.common.ARConstants;
import org.apertereports.common.utils.TimeUtils;

public final class TextUtils
implements ARConstants {
    private TextUtils() {
    }

    public static String encodeObjectToSQL(Object rawValue) {
        StringBuilder value = new StringBuilder();
        if (rawValue instanceof String) {
            value.append((String)rawValue);
        } else if (rawValue instanceof Object[]) {
            String sep = "'";
            for (Object val : (Object[])rawValue) {
                if (val.toString().isEmpty()) continue;
                value.append(sep).append(val).append("'");
                sep = ",'";
            }
        } else if (rawValue instanceof Collection) {
            String sep = "'";
            for (Object val : (Collection)rawValue) {
                if (val.toString().isEmpty()) continue;
                value.append(sep).append(val).append("'");
                sep = ",'";
            }
        } else if (rawValue instanceof Date) {
            value.append(TimeUtils.getDateFormatted((Date)rawValue));
        } else {
            value.append(rawValue.toString());
        }
        return value.toString();
    }

    private static String trimApostrophes(String input) {
        if (input.startsWith("'") && input.endsWith("'")) {
            return input.substring(input.length() > 1 ? 1 : 0, input.length() - 1);
        }
        return input;
    }

    public static String readTestFileToString(InputStream s) throws IOException {
        int c;
        StringBuilder ds = new StringBuilder();
        while ((c = s.read()) >= 0) {
            ds.append((char)c);
        }
        return ds.toString();
    }

    public static Object encodeSQLToObject(Class<?> type, String value) throws ParseException {
        if (type == null || String.class.isAssignableFrom(type)) {
            return value;
        }
        if (Date.class.isAssignableFrom(type)) {
            return TimeUtils.getDateFormatted(value);
        }
        if (Object[].class.isAssignableFrom(type)) {
            return TextUtils.trimListApostrophes(value);
        }
        if (Collection.class.isAssignableFrom(type)) {
            String[] values = TextUtils.trimListApostrophes(value);
            return Arrays.asList(values);
        }
        return value;
    }

    private static String[] trimListApostrophes(String input) {
        String[] values = input.split(",");
        for (int i = 0; i < values.length; ++i) {
            values[i] = TextUtils.trimApostrophes(values[i]);
        }
        return values;
    }

    public static String getCommaSeparatedString(List<Object> list) {
        StringBuilder sb = new StringBuilder();
        if (list.isEmpty()) {
            return "";
        }
        Iterator<Object> it = list.iterator();
        sb.append(it.next());
        while (it.hasNext()) {
            sb.append(",").append(it.next());
        }
        return sb.toString();
    }
}

