/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.common.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.mail.ByteArrayDataSource;
import org.apertereports.common.ARConstants;
import org.apertereports.common.exception.ARException;

public final class ReportGeneratorUtils {
    private ReportGeneratorUtils() {
    }

    public static <T> T resolveFieldValue(ClassLoader classLoader, String className, String fieldName) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        Field field = classLoader.loadClass(className).getDeclaredField(fieldName);
        return (T)field.get(null);
    }

    public static byte[] decodeContent(String content) throws UnsupportedEncodingException {
        return Base64.decodeBase64((byte[])content.getBytes("UTF-8"));
    }

    public static byte[] decodeContent(char[] content) throws UnsupportedEncodingException {
        return ReportGeneratorUtils.decodeContent(new String(content));
    }

    public static String encodeContent(byte[] content) {
        return new String(Base64.encodeBase64((byte[])content));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object deserializeObject(byte[] bytes) throws Exception {
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new ByteArrayInputStream(bytes));
            Object object = ois.readObject();
            return object;
        }
        finally {
            if (ois != null) {
                ois.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] serializeObject(Object object) throws Exception {
        ObjectOutputStream oos = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(bos);
            oos.writeObject(object);
            oos.flush();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        finally {
            if (oos != null) {
                oos.close();
            }
        }
    }

    public static DataHandler wrapBytesInDataHandler(byte[] content, String mimeType) throws IOException {
        return new DataHandler((DataSource)new ByteArrayDataSource(content, mimeType));
    }

    public static byte[] unwrapDataHandler(DataHandler handler) throws ARException {
        try {
            byte[] content = IOUtils.toByteArray((InputStream)handler.getInputStream());
            if (content.length == 0) {
                throw new IllegalStateException();
            }
            return content;
        }
        catch (Exception e) {
            throw new ARException(ARConstants.ErrorCode.EMPTY_REPORT_SOURCE, (Throwable)e);
        }
    }

    public static Object convertBytesToInputStreams(Object object) {
        if (object instanceof Map) {
            Map map = (Map)object;
            Iterator i$ = map.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry o;
                Map.Entry e = o = i$.next();
                Object key = e.getKey();
                Object value = e.getValue();
                if (!ReportGeneratorUtils.canConvertToInputStreams(value)) continue;
                map.put(key, ReportGeneratorUtils.convertBytesToInputStreams(value));
            }
        }
        if (object instanceof byte[]) {
            return new ByteArrayInputStream((byte[])object);
        }
        return object;
    }

    public static boolean canConvertToInputStreams(Object object) {
        return object instanceof byte[] || object instanceof Map;
    }
}

