/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.common.exception;

import org.apertereports.common.ARConstants;
import org.apertereports.common.exception.ARException;

public class ARRuntimeException
extends RuntimeException {
    private ARConstants.ErrorCode errorCode = ARConstants.ErrorCode.UNKNOWN;
    private String[] errorDetails = new String[0];

    public ARRuntimeException(ARConstants.ErrorCode errorCode) {
        this.init(errorCode, null, null);
    }

    public ARRuntimeException(ARConstants.ErrorCode errorCode, String ... details) {
        this.init(errorCode, null, details);
    }

    public ARRuntimeException(ARConstants.ErrorCode errorCode, Throwable cause, String ... details) {
        this.init(errorCode, cause, details);
    }

    public ARRuntimeException(ARConstants.ErrorCode errorCode, Throwable cause) {
        this.init(errorCode, cause, null);
    }

    public ARRuntimeException(ARException e) {
        this.init(e.getErrorCode(), e, e.getErrorDetails());
    }

    public ARRuntimeException(Exception e) {
        this.init(null, e, null);
    }

    private void init(ARConstants.ErrorCode code, Throwable cause, String ... details) {
        if (code != null) {
            this.errorCode = code;
        }
        if (cause != null) {
            this.initCause(cause);
        }
        if (details != null) {
            this.errorDetails = details;
        }
    }

    public ARConstants.ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public String[] getErrorDetails() {
        return this.errorDetails;
    }
}

