/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.yubico.core.RegistrationStorage;
import com.yubico.core.SessionManager;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.config.ConditionalOnWebAuthnEnabled;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.trusted.config.ConditionalOnMultifactorTrustedDevicesEnabled;
import org.apereo.cas.trusted.config.MultifactorAuthnTrustConfiguration;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.impl.CasWebflowEventResolutionConfigurationContext;
import org.apereo.cas.web.flow.util.MultifactorAuthenticationWebflowUtils;
import org.apereo.cas.webauthn.web.flow.WebAuthnAccountCheckRegistrationAction;
import org.apereo.cas.webauthn.web.flow.WebAuthnAccountSaveRegistrationAction;
import org.apereo.cas.webauthn.web.flow.WebAuthnAuthenticationWebflowAction;
import org.apereo.cas.webauthn.web.flow.WebAuthnAuthenticationWebflowEventResolver;
import org.apereo.cas.webauthn.web.flow.WebAuthnMultifactorTrustWebflowConfigurer;
import org.apereo.cas.webauthn.web.flow.WebAuthnMultifactorWebflowConfigurer;
import org.apereo.cas.webauthn.web.flow.WebAuthnStartAuthenticationAction;
import org.apereo.cas.webauthn.web.flow.WebAuthnStartRegistrationAction;
import org.apereo.cas.webauthn.web.flow.WebAuthnValidateSessionCredentialTokenAction;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.webflow.config.FlowDefinitionRegistryBuilder;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.FlowBuilder;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

@Configuration(value="webAuthnWebflowConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnWebAuthnEnabled
public class WebAuthnWebflowConfiguration {
    private static final int WEBFLOW_CONFIGURER_ORDER = 100;

    @Configuration(value="WebAuthnWebflowActionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class WebAuthnWebflowActionConfiguration {
        @ConditionalOnMissingBean(name={"webAuthnStartAuthenticationAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action webAuthnStartAuthenticationAction(@Qualifier(value="webAuthnCredentialRepository") RegistrationStorage webAuthnCredentialRepository) {
            return new WebAuthnStartAuthenticationAction(webAuthnCredentialRepository);
        }

        @ConditionalOnMissingBean(name={"webAuthnStartRegistrationAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action webAuthnStartRegistrationAction(@Qualifier(value="webAuthnCsrfTokenRepository") CsrfTokenRepository webAuthnCsrfTokenRepository, @Qualifier(value="webAuthnCredentialRepository") RegistrationStorage webAuthnCredentialRepository, CasConfigurationProperties casProperties) {
            return new WebAuthnStartRegistrationAction(webAuthnCredentialRepository, casProperties, webAuthnCsrfTokenRepository);
        }

        @ConditionalOnMissingBean(name={"webAuthnCheckAccountRegistrationAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action webAuthnCheckAccountRegistrationAction(@Qualifier(value="webAuthnCredentialRepository") RegistrationStorage webAuthnCredentialRepository) {
            return new WebAuthnAccountCheckRegistrationAction(webAuthnCredentialRepository);
        }

        @ConditionalOnMissingBean(name={"webAuthnSaveAccountRegistrationAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action webAuthnSaveAccountRegistrationAction(@Qualifier(value="webAuthnSessionManager") SessionManager webAuthnSessionManager, @Qualifier(value="webAuthnCredentialRepository") RegistrationStorage webAuthnCredentialRepository) {
            return new WebAuthnAccountSaveRegistrationAction(webAuthnCredentialRepository, webAuthnSessionManager);
        }

        @ConditionalOnMissingBean(name={"webAuthnAuthenticationWebflowAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action webAuthnAuthenticationWebflowAction(@Qualifier(value="webAuthnAuthenticationWebflowEventResolver") CasWebflowEventResolver webAuthnAuthenticationWebflowEventResolver) {
            return new WebAuthnAuthenticationWebflowAction(webAuthnAuthenticationWebflowEventResolver);
        }

        @ConditionalOnMissingBean(name={"webAuthnValidateSessionCredentialTokenAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action webAuthnValidateSessionCredentialTokenAction(@Qualifier(value="webAuthnSessionManager") SessionManager webAuthnSessionManager, @Qualifier(value="webAuthnPrincipalFactory") PrincipalFactory webAuthnPrincipalFactory, @Qualifier(value="webAuthnCredentialRepository") RegistrationStorage webAuthnCredentialRepository) {
            return new WebAuthnValidateSessionCredentialTokenAction(webAuthnCredentialRepository, webAuthnSessionManager, webAuthnPrincipalFactory);
        }
    }

    @ConditionalOnClass(value={MultifactorAuthnTrustConfiguration.class})
    @ConditionalOnWebAuthnEnabled
    @ConditionalOnMultifactorTrustedDevicesEnabled(prefix="cas.authn.mfa.web-authn")
    @Configuration(value="webAuthnMultifactorTrustConfiguration", proxyBeanMethods=false)
    @DependsOn(value={"webAuthnMultifactorWebflowConfigurer"})
    public static class WebAuthnMultifactorTrustConfiguration {
        @ConditionalOnMissingBean(name={"webAuthnMultifactorTrustWebflowConfigurer"})
        @Bean
        public CasWebflowConfigurer webAuthnMultifactorTrustWebflowConfigurer(@Qualifier(value="webAuthnFlowRegistry") FlowDefinitionRegistry webAuthnFlowRegistry, @Qualifier(value="loginFlowRegistry") FlowDefinitionRegistry loginFlowDefinitionRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            WebAuthnMultifactorTrustWebflowConfigurer cfg = new WebAuthnMultifactorTrustWebflowConfigurer(flowBuilderServices, loginFlowDefinitionRegistry, webAuthnFlowRegistry, applicationContext, casProperties, MultifactorAuthenticationWebflowUtils.getMultifactorAuthenticationWebflowCustomizers((ConfigurableApplicationContext)applicationContext));
            cfg.setOrder(101);
            return cfg;
        }

        @Bean
        public CasWebflowExecutionPlanConfigurer webAuthnMultifactorTrustCasWebflowExecutionPlanConfigurer(@Qualifier(value="webAuthnMultifactorTrustWebflowConfigurer") CasWebflowConfigurer webAuthnMultifactorTrustWebflowConfigurer) {
            return plan -> plan.registerWebflowConfigurer(webAuthnMultifactorTrustWebflowConfigurer);
        }
    }

    @Configuration(value="WebAuthnWebflowExecutionPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class WebAuthnWebflowExecutionPlanConfiguration {
        @ConditionalOnMissingBean(name={"webAuthnCasWebflowExecutionPlanConfigurer"})
        @Bean
        public CasWebflowExecutionPlanConfigurer webAuthnCasWebflowExecutionPlanConfigurer(@Qualifier(value="webAuthnMultifactorWebflowConfigurer") CasWebflowConfigurer webAuthnMultifactorWebflowConfigurer) {
            return plan -> plan.registerWebflowConfigurer(webAuthnMultifactorWebflowConfigurer);
        }
    }

    @Configuration(value="WebAuthnWebflowEventResolutionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class WebAuthnWebflowEventResolutionConfiguration {
        @ConditionalOnMissingBean(name={"webAuthnAuthenticationWebflowEventResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowEventResolver webAuthnAuthenticationWebflowEventResolver(@Qualifier(value="casWebflowConfigurationContext") CasWebflowEventResolutionConfigurationContext casWebflowConfigurationContext) {
            return new WebAuthnAuthenticationWebflowEventResolver(casWebflowConfigurationContext);
        }
    }

    @Configuration(value="WebAuthnWebflowBaseConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class WebAuthnWebflowBaseConfiguration {
        @ConditionalOnMissingBean(name={"webAuthnMultifactorWebflowConfigurer"})
        @Bean
        public CasWebflowConfigurer webAuthnMultifactorWebflowConfigurer(@Qualifier(value="loginFlowRegistry") FlowDefinitionRegistry loginFlowDefinitionRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices, @Qualifier(value="webAuthnFlowRegistry") FlowDefinitionRegistry webAuthnFlowRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            WebAuthnMultifactorWebflowConfigurer cfg = new WebAuthnMultifactorWebflowConfigurer(flowBuilderServices, loginFlowDefinitionRegistry, webAuthnFlowRegistry, applicationContext, casProperties, MultifactorAuthenticationWebflowUtils.getMultifactorAuthenticationWebflowCustomizers((ConfigurableApplicationContext)applicationContext));
            cfg.setOrder(100);
            return cfg;
        }
    }

    @Configuration(value="WebAuthnWebflowRegistryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class WebAuthnWebflowRegistryConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"webAuthnFlowRegistry"})
        public FlowDefinitionRegistry webAuthnFlowRegistry(@Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices, @Qualifier(value="flowBuilder") FlowBuilder flowBuilder, ConfigurableApplicationContext applicationContext) {
            FlowDefinitionRegistryBuilder builder = new FlowDefinitionRegistryBuilder((ApplicationContext)applicationContext, flowBuilderServices);
            builder.addFlowBuilder(flowBuilder, "mfa-webauthn");
            return builder.build();
        }
    }
}

