/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.yubico.core.DefaultSessionManager;
import com.yubico.core.RegistrationStorage;
import com.yubico.core.SessionManager;
import com.yubico.core.WebAuthnServer;
import com.yubico.webauthn.CredentialRepository;
import com.yubico.webauthn.RelyingParty;
import com.yubico.webauthn.attestation.AttestationResolver;
import com.yubico.webauthn.attestation.MetadataObject;
import com.yubico.webauthn.attestation.MetadataService;
import com.yubico.webauthn.attestation.StandardMetadataService;
import com.yubico.webauthn.attestation.TrustResolver;
import com.yubico.webauthn.attestation.resolver.CompositeAttestationResolver;
import com.yubico.webauthn.attestation.resolver.CompositeTrustResolver;
import com.yubico.webauthn.attestation.resolver.SimpleAttestationResolver;
import com.yubico.webauthn.attestation.resolver.SimpleTrustResolverWithEquality;
import com.yubico.webauthn.data.AttestationConveyancePreference;
import com.yubico.webauthn.data.RelyingPartyIdentity;
import com.yubico.webauthn.extension.appid.AppId;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationHandlerResolver;
import org.apereo.cas.authentication.AuthenticationMetaDataPopulator;
import org.apereo.cas.authentication.MultifactorAuthenticationFailureModeEvaluator;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.bypass.MultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.handler.ByCredentialTypeAuthenticationHandlerResolver;
import org.apereo.cas.authentication.metadata.AuthenticationContextAttributeMetaDataPopulator;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.config.ConditionalOnWebAuthnEnabled;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.util.EncryptionJwtSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.support.mfa.webauthn.WebAuthnMultifactorAuthenticationCoreProperties;
import org.apereo.cas.configuration.model.support.mfa.webauthn.WebAuthnMultifactorAuthenticationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.cipher.CipherExecutorUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.web.ProtocolEndpointWebSecurityConfigurer;
import org.apereo.cas.webauthn.WebAuthnAuthenticationHandler;
import org.apereo.cas.webauthn.WebAuthnCredential;
import org.apereo.cas.webauthn.WebAuthnCredentialRegistrationCipherExecutor;
import org.apereo.cas.webauthn.WebAuthnMultifactorAuthenticationProvider;
import org.apereo.cas.webauthn.WebAuthnUtils;
import org.apereo.cas.webauthn.storage.JsonResourceWebAuthnCredentialRepository;
import org.apereo.cas.webauthn.storage.WebAuthnCredentialRepository;
import org.apereo.cas.webauthn.web.WebAuthnController;
import org.apereo.cas.webauthn.web.WebAuthnRegisteredDevicesEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.Resource;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.HttpSessionCsrfTokenRepository;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnWebAuthnEnabled
@Configuration(value="webAuthnConfiguration", proxyBeanMethods=false)
public class WebAuthnConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(WebAuthnConfiguration.class);
    private static final int CACHE_MAX_SIZE = 10000;

    private static <K, V> Cache<K, V> newCache() {
        return CacheBuilder.newBuilder().maximumSize(10000L).expireAfterAccess(Duration.ofMinutes(5L)).build();
    }

    @Configuration(value="WebAuthnSecurityConfiguration", proxyBeanMethods=false)
    @Order(value=999)
    public static class WebAuthnSecurityConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"webAuthnCsrfTokenRepository"})
        public CsrfTokenRepository webAuthnCsrfTokenRepository() {
            return new HttpSessionCsrfTokenRepository();
        }

        @Bean
        public ProtocolEndpointWebSecurityConfigurer<HttpSecurity> webAuthnProtocolEndpointConfigurer(final @Qualifier(value="webAuthnCsrfTokenRepository") ObjectProvider<CsrfTokenRepository> webAuthnCsrfTokenRepository) {
            return new ProtocolEndpointWebSecurityConfigurer<HttpSecurity>(){

                public ProtocolEndpointWebSecurityConfigurer<HttpSecurity> configure(HttpSecurity http) {
                    http.csrf(customizer -> {
                        AntPathRequestMatcher pattern = new AntPathRequestMatcher("/webauthn/**");
                        webAuthnCsrfTokenRepository.ifAvailable(repository -> customizer.requireCsrfProtectionMatcher((RequestMatcher)pattern).csrfTokenRepository(repository));
                    });
                    return this;
                }
            };
        }
    }

    public static class WebAuthnDeviceRepositoryCleanerScheduler
    implements Runnable {
        private final WebAuthnCredentialRepository repository;

        @Override
        @Scheduled(initialDelayString="${cas.authn.mfa.web-authn.cleaner.schedule.start-delay:PT20S}", fixedDelayString="${cas.authn.mfa.web-authn.cleaner.schedule.repeat-interval:PT5M}")
        public void run() {
            LOGGER.debug("Starting to clean expired devices from repository");
            this.repository.clean();
        }

        @Generated
        public WebAuthnDeviceRepositoryCleanerScheduler(WebAuthnCredentialRepository repository) {
            this.repository = repository;
        }
    }

    @Configuration(value="WebAuthnCryptoConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class WebAuthnCryptoConfiguration {
        @ConditionalOnMissingBean(name={"webAuthnCredentialRegistrationCipherExecutor"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CipherExecutor webAuthnCredentialRegistrationCipherExecutor(CasConfigurationProperties casProperties) {
            EncryptionJwtSigningJwtCryptographyProperties crypto = casProperties.getAuthn().getMfa().getWebAuthn().getCrypto();
            if (crypto.isEnabled()) {
                return CipherExecutorUtils.newStringCipherExecutor((EncryptionJwtSigningJwtCryptographyProperties)crypto, WebAuthnCredentialRegistrationCipherExecutor.class);
            }
            LOGGER.trace("Web Authn credential registration records managed by CAS are not signed/encrypted.");
            return CipherExecutor.noOp();
        }
    }

    @Configuration(value="WebAuthnControllerConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class WebAuthnControllerConfiguration {
        @Bean
        @ConditionalOnAvailableEndpoint
        public WebAuthnRegisteredDevicesEndpoint webAuthnRegisteredDevicesEndpoint(CasConfigurationProperties casProperties, @Qualifier(value="webAuthnCredentialRepository") WebAuthnCredentialRepository webAuthnCredentialRepository) {
            return new WebAuthnRegisteredDevicesEndpoint(casProperties, webAuthnCredentialRepository);
        }

        @ConditionalOnMissingBean(name={"webAuthnController"})
        @Bean
        public WebAuthnController webAuthnController(@Qualifier(value="webAuthnServer") WebAuthnServer webAuthnServer) {
            return new WebAuthnController(webAuthnServer);
        }
    }

    @Configuration(value="WebAuthnMultifactorProviderConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class WebAuthnMultifactorProviderConfiguration {
        @ConditionalOnMissingBean(name={"webAuthnMultifactorAuthenticationProvider"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public MultifactorAuthenticationProvider webAuthnMultifactorAuthenticationProvider(CasConfigurationProperties casProperties, @Qualifier(value="failureModeEvaluator") MultifactorAuthenticationFailureModeEvaluator failureModeEvaluator, @Qualifier(value="webAuthnBypassEvaluator") MultifactorAuthenticationProviderBypassEvaluator webAuthnBypassEvaluator) {
            WebAuthnMultifactorAuthenticationProperties webauthn = casProperties.getAuthn().getMfa().getWebAuthn();
            WebAuthnMultifactorAuthenticationProvider p = new WebAuthnMultifactorAuthenticationProvider();
            p.setBypassEvaluator(webAuthnBypassEvaluator);
            p.setFailureMode(webauthn.getFailureMode());
            p.setFailureModeEvaluator(failureModeEvaluator);
            p.setOrder(webauthn.getRank());
            p.setId(webauthn.getId());
            return p;
        }
    }

    @Configuration(value="WebAuthnRepositoryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class WebAuthnRepositoryConfiguration {
        @ConditionalOnMissingBean(name={"webAuthnCredentialRepository"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public WebAuthnCredentialRepository webAuthnCredentialRepository(CasConfigurationProperties casProperties, @Qualifier(value="webAuthnCredentialRegistrationCipherExecutor") CipherExecutor webAuthnCredentialRegistrationCipherExecutor) {
            WebAuthnMultifactorAuthenticationProperties webauthn = casProperties.getAuthn().getMfa().getWebAuthn();
            Resource location = webauthn.getJson().getLocation();
            if (location != null) {
                return new JsonResourceWebAuthnCredentialRepository(casProperties, location, webAuthnCredentialRegistrationCipherExecutor);
            }
            return WebAuthnCredentialRepository.inMemory();
        }
    }

    @Configuration(value="WebAuthnAuthenticationPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class WebAuthnAuthenticationPlanConfiguration {
        @ConditionalOnMissingBean(name={"webAuthnAuthenticationEventExecutionPlanConfigurer"})
        @Bean
        public AuthenticationEventExecutionPlanConfigurer webAuthnAuthenticationEventExecutionPlanConfigurer(@Qualifier(value="webAuthnAuthenticationHandler") AuthenticationHandler webAuthnAuthenticationHandler, @Qualifier(value="webAuthnAuthenticationMetaDataPopulator") AuthenticationMetaDataPopulator webAuthnAuthenticationMetaDataPopulator) {
            return plan -> {
                plan.registerAuthenticationHandler(webAuthnAuthenticationHandler);
                plan.registerAuthenticationMetadataPopulator(webAuthnAuthenticationMetaDataPopulator);
                plan.registerAuthenticationHandlerResolver((AuthenticationHandlerResolver)new ByCredentialTypeAuthenticationHandlerResolver(new Class[]{WebAuthnCredential.class}));
            };
        }
    }

    @Configuration(value="WebAuthnMetadataConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class WebAuthnMetadataConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"webAuthnAuthenticationMetaDataPopulator"})
        public AuthenticationMetaDataPopulator webAuthnAuthenticationMetaDataPopulator(CasConfigurationProperties casProperties, @Qualifier(value="webAuthnAuthenticationHandler") AuthenticationHandler webAuthnAuthenticationHandler, @Qualifier(value="webAuthnMultifactorAuthenticationProvider") MultifactorAuthenticationProvider webAuthnMultifactorAuthenticationProvider) {
            String authenticationContextAttribute = casProperties.getAuthn().getMfa().getCore().getAuthenticationContextAttribute();
            return new AuthenticationContextAttributeMetaDataPopulator(authenticationContextAttribute, webAuthnAuthenticationHandler, webAuthnMultifactorAuthenticationProvider.getId());
        }
    }

    @Configuration(value="WebAuthnHandlerConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class WebAuthnHandlerConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"webAuthnAuthenticationHandler"})
        public AuthenticationHandler webAuthnAuthenticationHandler(CasConfigurationProperties casProperties, @Qualifier(value="webAuthnPrincipalFactory") PrincipalFactory webAuthnPrincipalFactory, @Qualifier(value="webAuthnCredentialRepository") WebAuthnCredentialRepository webAuthnCredentialRepository, @Qualifier(value="webAuthnSessionManager") SessionManager webAuthnSessionManager, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            WebAuthnMultifactorAuthenticationProperties webAuthn = casProperties.getAuthn().getMfa().getWebAuthn();
            return new WebAuthnAuthenticationHandler(webAuthn.getName(), servicesManager, webAuthnPrincipalFactory, (RegistrationStorage)webAuthnCredentialRepository, webAuthnSessionManager, Integer.valueOf(webAuthn.getOrder()));
        }
    }

    @Configuration(value="WebAuthnServerConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class WebAuthnServerConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"webAuthnServer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public WebAuthnServer webAuthnServer(CasConfigurationProperties casProperties, @Qualifier(value="webAuthnCredentialRepository") WebAuthnCredentialRepository webAuthnCredentialRepository, @Qualifier(value="webAuthnMetadataService") MetadataService webAuthnMetadataService, @Qualifier(value="webAuthnSessionManager") SessionManager webAuthnSessionManager) throws Exception {
            WebAuthnMultifactorAuthenticationCoreProperties webAuthn = casProperties.getAuthn().getMfa().getWebAuthn().getCore();
            String serverName = casProperties.getServer().getName();
            AppId appId = new AppId(StringUtils.defaultString((String)webAuthn.getApplicationId(), (String)serverName));
            RelyingPartyIdentity defaultRelyingPartyId = RelyingPartyIdentity.builder().id(StringUtils.defaultString((String)webAuthn.getRelyingPartyId(), (String)new URL(serverName).getHost())).name(StringUtils.defaultString((String)webAuthn.getRelyingPartyName(), (String)"CAS")).build();
            LinkedHashSet<String> origins = new LinkedHashSet<String>();
            if (StringUtils.isNotBlank((CharSequence)webAuthn.getAllowedOrigins())) {
                origins.addAll(org.springframework.util.StringUtils.commaDelimitedListToSet((String)webAuthn.getAllowedOrigins()));
            } else {
                origins.add(serverName);
            }
            AttestationConveyancePreference conveyance = AttestationConveyancePreference.valueOf((String)webAuthn.getAttestationConveyancePreference().toUpperCase());
            RelyingParty relyingParty = RelyingParty.builder().identity(defaultRelyingPartyId).credentialRepository((CredentialRepository)webAuthnCredentialRepository).origins(origins).attestationConveyancePreference(conveyance).metadataService(webAuthnMetadataService).allowUnrequestedExtensions(webAuthn.isAllowUnrequestedExtensions()).allowUntrustedAttestation(webAuthn.isAllowUntrustedAttestation()).validateSignatureCounter(webAuthn.isValidateSignatureCounter()).appId(appId).build();
            return new WebAuthnServer((RegistrationStorage)webAuthnCredentialRepository, WebAuthnConfiguration.newCache(), WebAuthnConfiguration.newCache(), relyingParty, webAuthnSessionManager);
        }
    }

    @Configuration(value="WebAuthnSchedulerConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class WebAuthnSchedulerConfiguration {
        @ConditionalOnMissingBean(name={"webAuthnDeviceRepositoryCleanerScheduler"})
        @Bean
        @ConditionalOnProperty(prefix="authn.mfa.web-authn.cleaner", name={"enabled"}, havingValue="true", matchIfMissing=true)
        public Runnable webAuthnDeviceRepositoryCleanerScheduler(@Qualifier(value="webAuthnCredentialRepository") WebAuthnCredentialRepository webAuthnCredentialRepository) {
            return new WebAuthnDeviceRepositoryCleanerScheduler(webAuthnCredentialRepository);
        }
    }

    @Configuration(value="WebAuthnCoreConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class WebAuthnCoreConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"simpleTrustResolverWithEquality"})
        public TrustResolver simpleTrustResolverWithEquality() {
            return new SimpleTrustResolverWithEquality(new ArrayList());
        }

        @Bean
        @ConditionalOnMissingBean(name={"webAuthnSessionManager"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SessionManager webAuthnSessionManager() {
            return new DefaultSessionManager();
        }

        @ConditionalOnMissingBean(name={"webAuthnPrincipalFactory"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PrincipalFactory webAuthnPrincipalFactory() {
            return PrincipalFactoryUtils.newPrincipalFactory();
        }
    }

    @Configuration(value="WebAuthnMetadataServiceConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class WebAuthnMetadataServiceConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"webAuthnMetadataService"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public MetadataService webAuthnMetadataService(CasConfigurationProperties casProperties, ObjectProvider<List<TrustResolver>> foundTrustResolvers, ObjectProvider<List<AttestationResolver>> foundAttestations) throws Exception {
            ArrayList<TrustResolver> trustResolvers = new ArrayList<TrustResolver>();
            trustResolvers.add(StandardMetadataService.createDefaultTrustResolver());
            trustResolvers.addAll(Optional.ofNullable((List)foundTrustResolvers.getIfAvailable()).orElse(new ArrayList()));
            CompositeTrustResolver trustResolver = new CompositeTrustResolver(trustResolvers);
            ArrayList<Object> attestationResolvers = new ArrayList<Object>();
            attestationResolvers.add(StandardMetadataService.createDefaultAttestationResolver((TrustResolver)trustResolver));
            Resource resource = casProperties.getAuthn().getMfa().getWebAuthn().getCore().getTrustedDeviceMetadata().getLocation();
            if (resource != null) {
                MetadataObject metadata = (MetadataObject)WebAuthnUtils.getObjectMapper().readValue(resource.getInputStream(), MetadataObject.class);
                attestationResolvers.add(new SimpleAttestationResolver((Collection)CollectionUtils.wrapList((Object[])new MetadataObject[]{metadata}), (TrustResolver)trustResolver));
            }
            attestationResolvers.addAll(Optional.ofNullable((List)foundAttestations.getIfAvailable()).orElse(new ArrayList()));
            CompositeAttestationResolver attestationResolver = new CompositeAttestationResolver(attestationResolvers);
            return new StandardMetadataService((AttestationResolver)attestationResolver);
        }
    }
}

