/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.bypass.AuthenticationMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.CredentialMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.DefaultChainingMultifactorAuthenticationBypassProvider;
import org.apereo.cas.authentication.bypass.GroovyMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.HttpRequestMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.MultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.PrincipalMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.RegisteredServiceMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.RegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.RestMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.config.ConditionalOnWebAuthnEnabled;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.mfa.MultifactorAuthenticationProviderBypassProperties;
import org.apereo.cas.configuration.model.support.mfa.u2f.U2FMultifactorAuthenticationProperties;
import org.apereo.cas.configuration.model.support.mfa.webauthn.WebAuthnMultifactorAuthenticationProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="webAuthnMultifactorProviderBypassConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnWebAuthnEnabled
public class WebAuthnMultifactorProviderBypassConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;

    @ConditionalOnMissingBean(name={"webAuthnBypassEvaluator"})
    @Bean
    @RefreshScope
    public MultifactorAuthenticationProviderBypassEvaluator webAuthnBypassEvaluator() {
        DefaultChainingMultifactorAuthenticationBypassProvider bypass = new DefaultChainingMultifactorAuthenticationBypassProvider();
        MultifactorAuthenticationProviderBypassProperties props = this.casProperties.getAuthn().getMfa().getWebAuthn().getBypass();
        if (StringUtils.isNotBlank((CharSequence)props.getPrincipalAttributeName())) {
            bypass.addMultifactorAuthenticationProviderBypassEvaluator(this.webAuthnPrincipalMultifactorAuthenticationProviderBypass());
        }
        bypass.addMultifactorAuthenticationProviderBypassEvaluator(this.webAuthnRegisteredServiceMultifactorAuthenticationProviderBypass());
        bypass.addMultifactorAuthenticationProviderBypassEvaluator(this.webAuthnRegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator());
        if (StringUtils.isNotBlank((CharSequence)props.getAuthenticationAttributeName()) || StringUtils.isNotBlank((CharSequence)props.getAuthenticationHandlerName()) || StringUtils.isNotBlank((CharSequence)props.getAuthenticationMethodName())) {
            bypass.addMultifactorAuthenticationProviderBypassEvaluator(this.webAuthnAuthenticationMultifactorAuthenticationProviderBypass());
        }
        if (StringUtils.isNotBlank((CharSequence)props.getCredentialClassType())) {
            bypass.addMultifactorAuthenticationProviderBypassEvaluator(this.webAuthnCredentialMultifactorAuthenticationProviderBypass());
        }
        if (StringUtils.isNotBlank((CharSequence)props.getHttpRequestHeaders()) || StringUtils.isNotBlank((CharSequence)props.getHttpRequestRemoteAddress())) {
            bypass.addMultifactorAuthenticationProviderBypassEvaluator(this.webAuthnHttpRequestMultifactorAuthenticationProviderBypass());
        }
        if (props.getGroovy().getLocation() != null) {
            bypass.addMultifactorAuthenticationProviderBypassEvaluator(this.webAuthnGroovyMultifactorAuthenticationProviderBypass());
        }
        if (StringUtils.isNotBlank((CharSequence)props.getRest().getUrl())) {
            bypass.addMultifactorAuthenticationProviderBypassEvaluator(this.webAuthnRestMultifactorAuthenticationProviderBypass());
        }
        return bypass;
    }

    @ConditionalOnMissingBean(name={"webAuthnRegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator"})
    @Bean
    @RefreshScope
    public MultifactorAuthenticationProviderBypassEvaluator webAuthnRegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator() {
        WebAuthnMultifactorAuthenticationProperties webAuthn = this.casProperties.getAuthn().getMfa().getWebAuthn();
        return new RegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator(webAuthn.getId());
    }

    @ConditionalOnMissingBean(name={"webAuthnRestMultifactorAuthenticationProviderBypass"})
    @Bean
    @RefreshScope
    public MultifactorAuthenticationProviderBypassEvaluator webAuthnRestMultifactorAuthenticationProviderBypass() {
        WebAuthnMultifactorAuthenticationProperties webAuthn = this.casProperties.getAuthn().getMfa().getWebAuthn();
        MultifactorAuthenticationProviderBypassProperties props = webAuthn.getBypass();
        return new RestMultifactorAuthenticationProviderBypassEvaluator(props, webAuthn.getId());
    }

    @ConditionalOnMissingBean(name={"webAuthnGroovyMultifactorAuthenticationProviderBypass"})
    @Bean
    @RefreshScope
    public MultifactorAuthenticationProviderBypassEvaluator webAuthnGroovyMultifactorAuthenticationProviderBypass() {
        WebAuthnMultifactorAuthenticationProperties webAuthn = this.casProperties.getAuthn().getMfa().getWebAuthn();
        MultifactorAuthenticationProviderBypassProperties props = webAuthn.getBypass();
        return new GroovyMultifactorAuthenticationProviderBypassEvaluator(props, webAuthn.getId());
    }

    @ConditionalOnMissingBean(name={"webAuthnHttpRequestMultifactorAuthenticationProviderBypass"})
    @Bean
    @RefreshScope
    public MultifactorAuthenticationProviderBypassEvaluator webAuthnHttpRequestMultifactorAuthenticationProviderBypass() {
        U2FMultifactorAuthenticationProperties webAuthn = this.casProperties.getAuthn().getMfa().getU2f();
        MultifactorAuthenticationProviderBypassProperties props = webAuthn.getBypass();
        return new HttpRequestMultifactorAuthenticationProviderBypassEvaluator(props, webAuthn.getId());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"webAuthnCredentialMultifactorAuthenticationProviderBypass"})
    public MultifactorAuthenticationProviderBypassEvaluator webAuthnCredentialMultifactorAuthenticationProviderBypass() {
        WebAuthnMultifactorAuthenticationProperties webAuthn = this.casProperties.getAuthn().getMfa().getWebAuthn();
        MultifactorAuthenticationProviderBypassProperties props = webAuthn.getBypass();
        return new CredentialMultifactorAuthenticationProviderBypassEvaluator(props, webAuthn.getId());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"webAuthnRegisteredServiceMultifactorAuthenticationProviderBypass"})
    public MultifactorAuthenticationProviderBypassEvaluator webAuthnRegisteredServiceMultifactorAuthenticationProviderBypass() {
        WebAuthnMultifactorAuthenticationProperties webAuthn = this.casProperties.getAuthn().getMfa().getWebAuthn();
        return new RegisteredServiceMultifactorAuthenticationProviderBypassEvaluator(webAuthn.getId());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"webAuthnPrincipalMultifactorAuthenticationProviderBypass"})
    public MultifactorAuthenticationProviderBypassEvaluator webAuthnPrincipalMultifactorAuthenticationProviderBypass() {
        WebAuthnMultifactorAuthenticationProperties webAuthn = this.casProperties.getAuthn().getMfa().getWebAuthn();
        MultifactorAuthenticationProviderBypassProperties props = webAuthn.getBypass();
        return new PrincipalMultifactorAuthenticationProviderBypassEvaluator(props, webAuthn.getId());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"webAuthnAuthenticationMultifactorAuthenticationProviderBypass"})
    public MultifactorAuthenticationProviderBypassEvaluator webAuthnAuthenticationMultifactorAuthenticationProviderBypass() {
        WebAuthnMultifactorAuthenticationProperties webAuthn = this.casProperties.getAuthn().getMfa().getWebAuthn();
        MultifactorAuthenticationProviderBypassProperties props = webAuthn.getBypass();
        return new AuthenticationMultifactorAuthenticationProviderBypassEvaluator(props, webAuthn.getId());
    }
}

