/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.rest.resources;

import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.DefaultAuthenticationResultBuilder;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.support.rest.factory.ServiceTicketResourceEntityResponseFactory;
import org.apereo.cas.ticket.InvalidTicketException;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="serviceTicketResourceRestController")
public class ServiceTicketResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceTicketResource.class);
    private final AuthenticationSystemSupport authenticationSystemSupport;
    private final ServiceFactory webApplicationServiceFactory;
    private final TicketRegistrySupport ticketRegistrySupport;
    private final ServiceTicketResourceEntityResponseFactory serviceTicketResourceEntityResponseFactory;

    public ServiceTicketResource(AuthenticationSystemSupport authenticationSystemSupport, TicketRegistrySupport ticketRegistrySupport, ServiceFactory webApplicationServiceFactory, ServiceTicketResourceEntityResponseFactory serviceTicketResourceEntityResponseFactory) {
        this.authenticationSystemSupport = authenticationSystemSupport;
        this.ticketRegistrySupport = ticketRegistrySupport;
        this.webApplicationServiceFactory = webApplicationServiceFactory;
        this.serviceTicketResourceEntityResponseFactory = serviceTicketResourceEntityResponseFactory;
    }

    @PostMapping(value={"/v1/tickets/{tgtId:.+}"}, consumes={"application/x-www-form-urlencoded"})
    public ResponseEntity<String> createServiceTicket(@RequestBody MultiValueMap<String, String> requestBody, @PathVariable(value="tgtId") String tgtId) {
        try {
            Authentication authn = this.ticketRegistrySupport.getAuthenticationFrom(tgtId);
            String serviceId = (String)requestBody.getFirst((Object)"service");
            if (authn == null) {
                throw new InvalidTicketException(tgtId);
            }
            if (StringUtils.isBlank((CharSequence)serviceId)) {
                throw new InvalidTicketException(serviceId);
            }
            DefaultAuthenticationResultBuilder builder = new DefaultAuthenticationResultBuilder(this.authenticationSystemSupport.getPrincipalElectionStrategy());
            Service service = this.webApplicationServiceFactory.createService(serviceId);
            AuthenticationResult authenticationResult = builder.collect(authn).build(service);
            return this.serviceTicketResourceEntityResponseFactory.build(tgtId, service, authenticationResult);
        }
        catch (InvalidTicketException e) {
            return new ResponseEntity((Object)(e.getMessage() + " could not be found"), HttpStatus.NOT_FOUND);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return new ResponseEntity((Object)e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

