/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.support.rest.CredentialFactory;
import org.apereo.cas.support.rest.factory.DefaultCredentialFactory;
import org.apereo.cas.support.rest.factory.DefaultServiceTicketResourceEntityResponseFactory;
import org.apereo.cas.support.rest.factory.DefaultTicketGrantingTicketResourceEntityResponseFactory;
import org.apereo.cas.support.rest.factory.ServiceTicketResourceEntityResponseFactory;
import org.apereo.cas.support.rest.factory.TicketGrantingTicketResourceEntityResponseFactory;
import org.apereo.cas.support.rest.resources.ServiceTicketResource;
import org.apereo.cas.support.rest.resources.TicketGrantingTicketResource;
import org.apereo.cas.support.rest.resources.TicketStatusResource;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Configuration(value="casRestConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasRestConfiguration
extends WebMvcConfigurerAdapter {
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private CentralAuthenticationService centralAuthenticationService;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired(required=false)
    @Qualifier(value="defaultAuthenticationSystemSupport")
    private AuthenticationSystemSupport authenticationSystemSupport;
    @Autowired(required=false)
    private CredentialFactory credentialFactory = new DefaultCredentialFactory();
    @Autowired
    @Qualifier(value="webApplicationServiceFactory")
    private ServiceFactory webApplicationServiceFactory;
    @Autowired
    @Qualifier(value="defaultTicketRegistrySupport")
    private TicketRegistrySupport ticketRegistrySupport;
    @Autowired
    private ConfigurableApplicationContext applicationContext;

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(this.restAuthenticationThrottle()).addPathPatterns(new String[]{"/v1/**"});
    }

    @Bean
    public TicketStatusResource ticketStatusResource() {
        return new TicketStatusResource(this.centralAuthenticationService);
    }

    @Bean
    public ServiceTicketResource serviceTicketResource() {
        return new ServiceTicketResource(this.authenticationSystemSupport, this.ticketRegistrySupport, this.webApplicationServiceFactory, this.serviceTicketResourceEntityResponseFactory());
    }

    @Bean
    @ConditionalOnMissingBean(name={"serviceTicketResourceEntityResponseFactory"})
    public ServiceTicketResourceEntityResponseFactory serviceTicketResourceEntityResponseFactory() {
        return new DefaultServiceTicketResourceEntityResponseFactory(this.centralAuthenticationService);
    }

    @Bean
    @ConditionalOnMissingBean(name={"ticketGrantingTicketResourceEntityResponseFactory"})
    public TicketGrantingTicketResourceEntityResponseFactory ticketGrantingTicketResourceEntityResponseFactory() {
        return new DefaultTicketGrantingTicketResourceEntityResponseFactory();
    }

    @Bean
    public TicketGrantingTicketResource ticketResourceRestController() {
        return new TicketGrantingTicketResource(this.authenticationSystemSupport, this.credentialFactory, this.centralAuthenticationService, this.webApplicationServiceFactory, this.ticketGrantingTicketResourceEntityResponseFactory());
    }

    @ConditionalOnMissingBean(name={"restAuthenticationThrottle"})
    @Bean
    public HandlerInterceptor restAuthenticationThrottle() {
        String throttler = this.casProperties.getRest().getThrottler();
        if (StringUtils.isNotBlank((CharSequence)throttler) && this.applicationContext.containsBean(throttler)) {
            return (HandlerInterceptor)this.applicationContext.getBean(throttler, HandlerInterceptor.class);
        }
        return new HandlerInterceptorAdapter(){

            public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
                return true;
            }
        };
    }
}

