/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.services;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashSet;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Lob;
import lombok.Generated;
import org.apereo.cas.services.AbstractRegisteredService;
import org.apereo.cas.services.RegexRegisteredService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@DiscriminatorValue(value="oauth")
public class OAuthRegisteredService
extends RegexRegisteredService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuthRegisteredService.class);
    private static final long serialVersionUID = 5318897374067731021L;
    @Column
    private String clientSecret;
    @Column
    private String clientId;
    @Column
    private boolean bypassApprovalPrompt;
    @Column
    private boolean generateRefreshToken;
    @Column
    private boolean jsonFormat;
    @Lob
    @Column(name="supported_grants", length=0x7FFFFFFF)
    private HashSet<String> supportedGrantTypes = new HashSet();
    @Lob
    @Column(name="supported_responses", length=0x7FFFFFFF)
    private HashSet<String> supportedResponseTypes = new HashSet();

    protected AbstractRegisteredService newInstance() {
        return new OAuthRegisteredService();
    }

    public void initialize() {
        super.initialize();
        if (this.supportedGrantTypes == null) {
            this.supportedGrantTypes = new HashSet();
        }
        if (this.supportedResponseTypes == null) {
            this.supportedResponseTypes = new HashSet();
        }
    }

    @JsonIgnore
    public String getFriendlyName() {
        return "OAuth2 Client";
    }

    @Generated
    public String toString() {
        return "OAuthRegisteredService(super=" + super.toString() + ", clientSecret=" + this.clientSecret + ", clientId=" + this.clientId + ", bypassApprovalPrompt=" + this.bypassApprovalPrompt + ", generateRefreshToken=" + this.generateRefreshToken + ", jsonFormat=" + this.jsonFormat + ", supportedGrantTypes=" + this.supportedGrantTypes + ", supportedResponseTypes=" + this.supportedResponseTypes + ")";
    }

    @Generated
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Generated
    public String getClientId() {
        return this.clientId;
    }

    @Generated
    public boolean isBypassApprovalPrompt() {
        return this.bypassApprovalPrompt;
    }

    @Generated
    public boolean isGenerateRefreshToken() {
        return this.generateRefreshToken;
    }

    @Generated
    public boolean isJsonFormat() {
        return this.jsonFormat;
    }

    @Generated
    public HashSet<String> getSupportedGrantTypes() {
        return this.supportedGrantTypes;
    }

    @Generated
    public HashSet<String> getSupportedResponseTypes() {
        return this.supportedResponseTypes;
    }

    @Generated
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @Generated
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Generated
    public void setBypassApprovalPrompt(boolean bypassApprovalPrompt) {
        this.bypassApprovalPrompt = bypassApprovalPrompt;
    }

    @Generated
    public void setGenerateRefreshToken(boolean generateRefreshToken) {
        this.generateRefreshToken = generateRefreshToken;
    }

    @Generated
    public void setJsonFormat(boolean jsonFormat) {
        this.jsonFormat = jsonFormat;
    }

    @Generated
    public void setSupportedGrantTypes(HashSet<String> supportedGrantTypes) {
        this.supportedGrantTypes = supportedGrantTypes;
    }

    @Generated
    public void setSupportedResponseTypes(HashSet<String> supportedResponseTypes) {
        this.supportedResponseTypes = supportedResponseTypes;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuthRegisteredService)) {
            return false;
        }
        OAuthRegisteredService other = (OAuthRegisteredService)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$clientSecret = this.clientSecret;
        String other$clientSecret = other.clientSecret;
        if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) {
            return false;
        }
        String this$clientId = this.clientId;
        String other$clientId = other.clientId;
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        if (this.bypassApprovalPrompt != other.bypassApprovalPrompt) {
            return false;
        }
        if (this.generateRefreshToken != other.generateRefreshToken) {
            return false;
        }
        if (this.jsonFormat != other.jsonFormat) {
            return false;
        }
        HashSet<String> this$supportedGrantTypes = this.supportedGrantTypes;
        HashSet<String> other$supportedGrantTypes = other.supportedGrantTypes;
        if (this$supportedGrantTypes == null ? other$supportedGrantTypes != null : !((Object)this$supportedGrantTypes).equals(other$supportedGrantTypes)) {
            return false;
        }
        HashSet<String> this$supportedResponseTypes = this.supportedResponseTypes;
        HashSet<String> other$supportedResponseTypes = other.supportedResponseTypes;
        return !(this$supportedResponseTypes == null ? other$supportedResponseTypes != null : !((Object)this$supportedResponseTypes).equals(other$supportedResponseTypes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OAuthRegisteredService;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $clientSecret = this.clientSecret;
        result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
        String $clientId = this.clientId;
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        result = result * 59 + (this.bypassApprovalPrompt ? 79 : 97);
        result = result * 59 + (this.generateRefreshToken ? 79 : 97);
        result = result * 59 + (this.jsonFormat ? 79 : 97);
        HashSet<String> $supportedGrantTypes = this.supportedGrantTypes;
        result = result * 59 + ($supportedGrantTypes == null ? 43 : ((Object)$supportedGrantTypes).hashCode());
        HashSet<String> $supportedResponseTypes = this.supportedResponseTypes;
        result = result * 59 + ($supportedResponseTypes == null ? 43 : ((Object)$supportedResponseTypes).hashCode());
        return result;
    }
}

