/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.aws.authz;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.aws.ChainingAWSCredentialsProvider;
import org.apereo.cas.configuration.support.ExpressionLanguageCapable;
import org.apereo.cas.services.BaseRegisteredServiceAccessStrategy;
import org.apereo.cas.services.RegisteredServiceAccessStrategyRequest;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.awscore.defaultsmode.DefaultsMode;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.verifiedpermissions.VerifiedPermissionsClient;
import software.amazon.awssdk.services.verifiedpermissions.VerifiedPermissionsClientBuilder;
import software.amazon.awssdk.services.verifiedpermissions.model.ActionIdentifier;
import software.amazon.awssdk.services.verifiedpermissions.model.AttributeValue;
import software.amazon.awssdk.services.verifiedpermissions.model.ContextDefinition;
import software.amazon.awssdk.services.verifiedpermissions.model.Decision;
import software.amazon.awssdk.services.verifiedpermissions.model.EntityIdentifier;
import software.amazon.awssdk.services.verifiedpermissions.model.IsAuthorizedRequest;
import software.amazon.awssdk.services.verifiedpermissions.model.IsAuthorizedResponse;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class AmazonVerifiedPermissionsRegisteredServiceAccessStrategy
extends BaseRegisteredServiceAccessStrategy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AmazonVerifiedPermissionsRegisteredServiceAccessStrategy.class);
    private static final long serialVersionUID = 8331462526633144898L;
    @ExpressionLanguageCapable
    private String credentialAccessKey;
    @ExpressionLanguageCapable
    private String credentialSecretKey;
    @ExpressionLanguageCapable
    private String region;
    @ExpressionLanguageCapable
    private String policyStoreId;
    @ExpressionLanguageCapable
    private String actionId;
    private Map<String, Object> context = new TreeMap<String, Object>();

    public boolean authorizeRequest(RegisteredServiceAccessStrategyRequest request) {
        SpringExpressionLanguageValueResolver resolver = SpringExpressionLanguageValueResolver.getInstance();
        try (VerifiedPermissionsClient client = this.buildAmazonVerifiedPermissionsClient();){
            IsAuthorizedRequest authorizedRequest = (IsAuthorizedRequest)IsAuthorizedRequest.builder().principal((EntityIdentifier)EntityIdentifier.builder().entityId(request.getPrincipalId()).build()).resource((EntityIdentifier)EntityIdentifier.builder().entityId(request.getService().getId()).build()).action((ActionIdentifier)ActionIdentifier.builder().actionId(resolver.resolve(this.actionId)).build()).context((ContextDefinition)ContextDefinition.builder().contextMap(this.buildAuthorizationContextMap(request)).build()).policyStoreId(resolver.resolve(this.policyStoreId)).build();
            boolean bl = (Boolean)FunctionUtils.doAndHandle(() -> {
                LOGGER.debug("Sending authorization request [{}]", (Object)authorizedRequest);
                IsAuthorizedResponse authorizedResponse = client.isAuthorized(authorizedRequest);
                LOGGER.debug("Authorization response [{}], evaluated policies [{}]", (Object)authorizedResponse.decisionAsString(), (Object)authorizedResponse.determiningPolicies());
                return authorizedResponse.decision() == Decision.ALLOW;
            }, e -> false).get();
            return bl;
        }
    }

    protected Map<String, AttributeValue> buildAuthorizationContextMap(RegisteredServiceAccessStrategyRequest request) {
        HashMap<String, AttributeValue> contextMap = new HashMap<String, AttributeValue>(this.buildAttributeValueMap(this.context));
        contextMap.putAll(this.buildAttributeValueMap(request.getAttributes()));
        contextMap.putAll(this.buildAttributeValueMap(request.getService().getAttributes()));
        return contextMap;
    }

    protected Map<String, AttributeValue> buildAttributeValueMap(Map<String, ?> attributes) {
        return attributes.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, value -> {
            Set values = CollectionUtils.toCollection(value.getValue());
            List<AttributeValue> attributeValues = values.stream().map(attrValue -> (AttributeValue)AttributeValue.builder().string(attrValue.toString()).build()).toList();
            return (AttributeValue)AttributeValue.builder().set(attributeValues).build();
        }));
    }

    protected VerifiedPermissionsClient buildAmazonVerifiedPermissionsClient() {
        SpringExpressionLanguageValueResolver resolver = SpringExpressionLanguageValueResolver.getInstance();
        AwsCredentialsProvider provider = ChainingAWSCredentialsProvider.getInstance(resolver.resolve(this.credentialAccessKey), resolver.resolve(this.credentialSecretKey));
        ClientOverrideConfiguration clientConfig = (ClientOverrideConfiguration)ClientOverrideConfiguration.builder().apiCallTimeout(Duration.ofSeconds(5L)).apiCallAttemptTimeout(Duration.ofSeconds(5L)).retryPolicy(RetryMode.STANDARD).build();
        return (VerifiedPermissionsClient)((VerifiedPermissionsClientBuilder)((VerifiedPermissionsClientBuilder)((VerifiedPermissionsClientBuilder)((VerifiedPermissionsClientBuilder)VerifiedPermissionsClient.builder().defaultsMode(DefaultsMode.STANDARD)).region(StringUtils.isBlank((CharSequence)this.region) ? Region.US_EAST_1 : Region.of((String)resolver.resolve(this.region)))).credentialsProvider(provider)).overrideConfiguration(clientConfig)).build();
    }

    @Generated
    public String toString() {
        return "AmazonVerifiedPermissionsRegisteredServiceAccessStrategy(super=" + super.toString() + ", credentialAccessKey=" + this.credentialAccessKey + ", credentialSecretKey=" + this.credentialSecretKey + ", region=" + this.region + ", policyStoreId=" + this.policyStoreId + ", actionId=" + this.actionId + ", context=" + String.valueOf(this.context) + ")";
    }

    @Generated
    public String getCredentialAccessKey() {
        return this.credentialAccessKey;
    }

    @Generated
    public String getCredentialSecretKey() {
        return this.credentialSecretKey;
    }

    @Generated
    public String getRegion() {
        return this.region;
    }

    @Generated
    public String getPolicyStoreId() {
        return this.policyStoreId;
    }

    @Generated
    public String getActionId() {
        return this.actionId;
    }

    @Generated
    public Map<String, Object> getContext() {
        return this.context;
    }

    @Generated
    public AmazonVerifiedPermissionsRegisteredServiceAccessStrategy setCredentialAccessKey(String credentialAccessKey) {
        this.credentialAccessKey = credentialAccessKey;
        return this;
    }

    @Generated
    public AmazonVerifiedPermissionsRegisteredServiceAccessStrategy setCredentialSecretKey(String credentialSecretKey) {
        this.credentialSecretKey = credentialSecretKey;
        return this;
    }

    @Generated
    public AmazonVerifiedPermissionsRegisteredServiceAccessStrategy setRegion(String region) {
        this.region = region;
        return this;
    }

    @Generated
    public AmazonVerifiedPermissionsRegisteredServiceAccessStrategy setPolicyStoreId(String policyStoreId) {
        this.policyStoreId = policyStoreId;
        return this;
    }

    @Generated
    public AmazonVerifiedPermissionsRegisteredServiceAccessStrategy setActionId(String actionId) {
        this.actionId = actionId;
        return this;
    }

    @Generated
    public AmazonVerifiedPermissionsRegisteredServiceAccessStrategy setContext(Map<String, Object> context) {
        this.context = context;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AmazonVerifiedPermissionsRegisteredServiceAccessStrategy)) {
            return false;
        }
        AmazonVerifiedPermissionsRegisteredServiceAccessStrategy other = (AmazonVerifiedPermissionsRegisteredServiceAccessStrategy)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$credentialAccessKey = this.credentialAccessKey;
        String other$credentialAccessKey = other.credentialAccessKey;
        if (this$credentialAccessKey == null ? other$credentialAccessKey != null : !this$credentialAccessKey.equals(other$credentialAccessKey)) {
            return false;
        }
        String this$credentialSecretKey = this.credentialSecretKey;
        String other$credentialSecretKey = other.credentialSecretKey;
        if (this$credentialSecretKey == null ? other$credentialSecretKey != null : !this$credentialSecretKey.equals(other$credentialSecretKey)) {
            return false;
        }
        String this$region = this.region;
        String other$region = other.region;
        if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
            return false;
        }
        String this$policyStoreId = this.policyStoreId;
        String other$policyStoreId = other.policyStoreId;
        if (this$policyStoreId == null ? other$policyStoreId != null : !this$policyStoreId.equals(other$policyStoreId)) {
            return false;
        }
        String this$actionId = this.actionId;
        String other$actionId = other.actionId;
        if (this$actionId == null ? other$actionId != null : !this$actionId.equals(other$actionId)) {
            return false;
        }
        Map<String, Object> this$context = this.context;
        Map<String, Object> other$context = other.context;
        return !(this$context == null ? other$context != null : !((Object)this$context).equals(other$context));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AmazonVerifiedPermissionsRegisteredServiceAccessStrategy;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $credentialAccessKey = this.credentialAccessKey;
        result = result * 59 + ($credentialAccessKey == null ? 43 : $credentialAccessKey.hashCode());
        String $credentialSecretKey = this.credentialSecretKey;
        result = result * 59 + ($credentialSecretKey == null ? 43 : $credentialSecretKey.hashCode());
        String $region = this.region;
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        String $policyStoreId = this.policyStoreId;
        result = result * 59 + ($policyStoreId == null ? 43 : $policyStoreId.hashCode());
        String $actionId = this.actionId;
        result = result * 59 + ($actionId == null ? 43 : $actionId.hashCode());
        Map<String, Object> $context = this.context;
        result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
        return result;
    }

    @Generated
    public AmazonVerifiedPermissionsRegisteredServiceAccessStrategy() {
    }
}

