/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.aws;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.aws.AmazonClientConfigurationBuilder;
import org.apereo.cas.aws.ChainingAWSCredentialsProvider;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.aws.AmazonSecurityTokenServiceProperties;
import org.apereo.cas.configuration.model.support.aws.BaseAmazonWebServicesProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.rest.authentication.RestAuthenticationService;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.RegexUtils;
import org.apereo.cas.web.BaseCasRestActuatorEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsSyncClientBuilder;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;
import software.amazon.awssdk.services.sts.model.AssumeRoleResponse;
import software.amazon.awssdk.services.sts.model.Credentials;
import software.amazon.awssdk.services.sts.model.GetSessionTokenRequest;
import software.amazon.awssdk.services.sts.model.GetSessionTokenResponse;

@Endpoint(id="awsSts", enableByDefault=false)
public class AmazonSecurityTokenServiceEndpoint
extends BaseCasRestActuatorEndpoint {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AmazonSecurityTokenServiceEndpoint.class);
    private final ObjectProvider<RestAuthenticationService> restAuthenticationService;

    public AmazonSecurityTokenServiceEndpoint(ObjectProvider<CasConfigurationProperties> casProperties, ConfigurableApplicationContext applicationContext, ObjectProvider<RestAuthenticationService> restAuthenticationService) {
        super((CasConfigurationProperties)casProperties.getObject(), applicationContext);
        this.restAuthenticationService = restAuthenticationService;
    }

    private static ResponseEntity<String> createOutputResponse(AmazonSecurityTokenServiceProperties amz, Credentials stsCredentials) {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        properties.put("aws_access_key_id", stsCredentials.accessKeyId());
        properties.put("aws_secret_access_key", stsCredentials.secretAccessKey());
        properties.put("aws_session_token", stsCredentials.sessionToken());
        properties.put("region", StringUtils.isBlank((CharSequence)amz.getRegion()) ? Region.AWS_GLOBAL.id() : Region.of((String)amz.getRegion()).id());
        StringBuilder output = new StringBuilder("[default]\n");
        properties.forEach((key, value) -> output.append(String.format("%s=%s%n", key, value)));
        return ResponseEntity.ok((Object)output.toString());
    }

    private static Optional<ResponseEntity<String>> authorizePrincipal(AmazonSecurityTokenServiceProperties amz, Principal principal) {
        if (StringUtils.isNotBlank((CharSequence)amz.getPrincipalAttributeName())) {
            if (!principal.getAttributes().containsKey(amz.getPrincipalAttributeName())) {
                LOGGER.error("Failed to locate authorization attribute for principal [{}]", (Object)principal);
                return Optional.of(ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)"Authorization failure"));
            }
            List attributeValues = (List)principal.getAttributes().get(amz.getPrincipalAttributeName());
            if (StringUtils.isNotBlank((CharSequence)amz.getPrincipalAttributeValue()) && attributeValues.stream().noneMatch(value -> RegexUtils.find((String)amz.getPrincipalAttributeValue(), (String)value.toString()))) {
                LOGGER.error("Failed to locate authorization attribute value for principal [{}]", (Object)principal);
                return Optional.of(ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)"Authorization failure"));
            }
        }
        return Optional.empty();
    }

    @PostMapping
    @Operation(summary="Fetch temporary credentials from Amazon Security Token Service", parameters={@Parameter(name="duration"), @Parameter(name="tokenCode"), @Parameter(name="profile"), @Parameter(name="serialNumber"), @Parameter(name="roleArn"), @Parameter(name="requestBody"), @Parameter(name="request"), @Parameter(name="response")})
    public ResponseEntity<String> fetchCredentials(@RequestParam(value="token", required=false) String tokenCode, @RequestParam(required=false) String profile, @RequestParam(required=false) String serialNumber, @RequestParam(required=false) String roleArn, @RequestBody MultiValueMap<String, String> requestBody, HttpServletRequest request, HttpServletResponse response) throws Throwable {
        AuthenticationResult authenticationResult = null;
        try {
            authenticationResult = (AuthenticationResult)((RestAuthenticationService)this.restAuthenticationService.getObject()).authenticate(requestBody, request, response).orElseThrow(AuthenticationException::new);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)"Authentication failed");
        }
        AmazonSecurityTokenServiceProperties amz = this.casProperties.getAmazonSts();
        Principal principal = authenticationResult.getAuthentication().getPrincipal();
        LOGGER.debug("Authenticated principal: [{}]", (Object)principal);
        Optional<ResponseEntity<String>> authz = AmazonSecurityTokenServiceEndpoint.authorizePrincipal(amz, principal);
        if (authz.isPresent()) {
            return authz.get();
        }
        AwsCredentialsProvider credentials = ChainingAWSCredentialsProvider.getInstance(amz.getCredentialAccessKey(), amz.getCredentialSecretKey(), amz.getProfilePath(), (String)StringUtils.defaultIfBlank((CharSequence)profile, (CharSequence)amz.getProfileName()));
        StsClientBuilder builder = StsClient.builder();
        AmazonClientConfigurationBuilder.prepareSyncClientBuilder((AwsSyncClientBuilder)builder, credentials, (BaseAmazonWebServicesProperties)amz);
        StsClient client = (StsClient)builder.build();
        String duration = (String)StringUtils.defaultIfBlank((CharSequence)((String)requestBody.getFirst((Object)"duration")), (CharSequence)"PT15S");
        if (amz.isRbacEnabled()) {
            List attributeValues = (List)principal.getAttributes().get(amz.getPrincipalAttributeName());
            LOGGER.debug("Found roles [{}]", (Object)attributeValues);
            if (attributeValues.size() > 1) {
                if (StringUtils.isBlank((CharSequence)roleArn)) {
                    return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)("Found multiple roles and none is specified. Current roles: " + String.valueOf(attributeValues)));
                }
                if (attributeValues.stream().noneMatch(value -> RegexUtils.find((String)roleArn, (String)value.toString()))) {
                    return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)("Specified role is not allowed. Current roles:" + String.valueOf(attributeValues)));
                }
            }
            String role = (String)StringUtils.defaultIfBlank((CharSequence)roleArn, (CharSequence)attributeValues.getFirst().toString());
            LOGGER.debug("Using role [{}]", (Object)role);
            AssumeRoleRequest roleRequest = (AssumeRoleRequest)AssumeRoleRequest.builder().durationSeconds(Integer.valueOf(Long.valueOf(Beans.newDuration((String)duration).toSeconds()).intValue())).roleArn(role).roleSessionName(UUID.randomUUID().toString()).serialNumber(serialNumber).tokenCode(tokenCode).build();
            AssumeRoleResponse sessionResult = client.assumeRole(roleRequest);
            Credentials stsCredentials = sessionResult.credentials();
            return AmazonSecurityTokenServiceEndpoint.createOutputResponse(amz, stsCredentials);
        }
        GetSessionTokenRequest sessionTokenRequest = (GetSessionTokenRequest)GetSessionTokenRequest.builder().durationSeconds(Integer.valueOf(Long.valueOf(Beans.newDuration((String)duration).toSeconds()).intValue())).serialNumber(serialNumber).tokenCode(tokenCode).build();
        GetSessionTokenResponse sessionResult = client.getSessionToken(sessionTokenRequest);
        Credentials stsCredentials = sessionResult.credentials();
        return AmazonSecurityTokenServiceEndpoint.createOutputResponse(amz, stsCredentials);
    }
}

