/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.aws;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.util.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProviderChain;
import software.amazon.awssdk.auth.credentials.ContainerCredentialsProvider;
import software.amazon.awssdk.auth.credentials.EnvironmentVariableCredentialsProvider;
import software.amazon.awssdk.auth.credentials.InstanceProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.auth.credentials.SystemPropertyCredentialsProvider;
import software.amazon.awssdk.auth.credentials.WebIdentityTokenFileCredentialsProvider;
import software.amazon.awssdk.profiles.ProfileFile;

public class ChainingAWSCredentialsProvider {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ChainingAWSCredentialsProvider.class);
    private final List<AwsCredentialsProvider> chain;

    public static AwsCredentialsProvider getInstance() {
        return ChainingAWSCredentialsProvider.getInstance(null, null, null, null);
    }

    public static AwsCredentialsProvider getInstance(String credentialAccessKey, String credentialSecretKey) {
        return ChainingAWSCredentialsProvider.getInstance(credentialAccessKey, credentialSecretKey, null, null);
    }

    public static AwsCredentialsProvider getInstance(String credentialAccessKey, String credentialSecretKey, String profilePath, String profileName) {
        LOGGER.debug("Attempting to locate AWS credentials...");
        ArrayList<InstanceProfileCredentialsProvider> chain = new ArrayList<InstanceProfileCredentialsProvider>();
        ChainingAWSCredentialsProvider.addProviderToChain(nothing -> {
            chain.add((InstanceProfileCredentialsProvider)WebIdentityTokenFileCredentialsProvider.create());
            return null;
        });
        chain.add(InstanceProfileCredentialsProvider.create());
        if (StringUtils.isNotBlank((CharSequence)profilePath) && StringUtils.isNotBlank((CharSequence)profileName)) {
            ChainingAWSCredentialsProvider.addProviderToChain(nothing -> {
                chain.add((InstanceProfileCredentialsProvider)ProfileCredentialsProvider.builder().profileName(profileName).profileFile(ProfileFile.builder().content(Path.of(profilePath, new String[0])).build()).build());
                return null;
            });
        }
        ChainingAWSCredentialsProvider.addProviderToChain(nothing -> {
            chain.add((InstanceProfileCredentialsProvider)SystemPropertyCredentialsProvider.create());
            return null;
        });
        ChainingAWSCredentialsProvider.addProviderToChain(nothing -> {
            chain.add((InstanceProfileCredentialsProvider)EnvironmentVariableCredentialsProvider.create());
            return null;
        });
        if (StringUtils.isNotBlank((CharSequence)credentialAccessKey) && StringUtils.isNotBlank((CharSequence)credentialSecretKey)) {
            ChainingAWSCredentialsProvider.addProviderToChain(nothing -> {
                AwsBasicCredentials credentials = AwsBasicCredentials.create((String)credentialAccessKey, (String)credentialSecretKey);
                chain.add((InstanceProfileCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)credentials));
                return null;
            });
        }
        ChainingAWSCredentialsProvider.addProviderToChain(nothing -> {
            chain.add((InstanceProfileCredentialsProvider)ContainerCredentialsProvider.builder().build());
            return null;
        });
        ChainingAWSCredentialsProvider.addProviderToChain(nothing -> {
            chain.add(InstanceProfileCredentialsProvider.builder().build());
            return null;
        });
        LOGGER.debug("AWS chained credential providers are configured as [{}]", chain);
        return AwsCredentialsProviderChain.builder().credentialsProviders(chain).build();
    }

    private static void addProviderToChain(Function<Void, Void> func) {
        try {
            func.apply(null);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
    }

    @Generated
    public ChainingAWSCredentialsProvider(List<AwsCredentialsProvider> chain) {
        this.chain = chain;
    }

    @Generated
    public List<AwsCredentialsProvider> getChain() {
        return this.chain;
    }
}

