/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.aws;

import java.net.URI;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.aws.ChainingAWSCredentialsProvider;
import org.springframework.core.env.Environment;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.regions.Region;

public class AmazonEnvironmentAwareClientBuilder {
    private final String propertyPrefix;
    private final Environment environment;

    public String getSetting(String key) {
        return this.environment.getProperty(this.propertyPrefix + "." + key);
    }

    public String getSetting(String key, String defaultValue) {
        String result = this.environment.getProperty(this.propertyPrefix + "." + key);
        return (String)StringUtils.defaultIfBlank((CharSequence)result, (CharSequence)defaultValue);
    }

    public <T> T getSetting(String key, Class<T> targetType) {
        return (T)this.environment.getProperty(this.propertyPrefix + "." + key, targetType);
    }

    public <T> T build(AwsClientBuilder builder, Class<T> clientType) {
        String key = this.getSetting("credential-access-key");
        String secret = this.getSetting("credential-secret-key");
        AwsCredentialsProvider credentials = ChainingAWSCredentialsProvider.getInstance(key, secret);
        builder.credentialsProvider(credentials);
        String region = this.getSetting("region");
        builder.region(StringUtils.isBlank((CharSequence)region) ? Region.AWS_GLOBAL : Region.of((String)region));
        String endpoint = this.getSetting("endpoint");
        if (StringUtils.isNotBlank((CharSequence)endpoint)) {
            builder.endpointOverride(new URI(endpoint));
        }
        Object result = builder.build();
        return clientType.cast(result);
    }

    @Generated
    public AmazonEnvironmentAwareClientBuilder(String propertyPrefix, Environment environment) {
        this.propertyPrefix = propertyPrefix;
        this.environment = environment;
    }
}

