/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.aws;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.ClasspathPropertiesFileCredentialsProvider;
import com.amazonaws.auth.EnvironmentVariableCredentialsProvider;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.amazonaws.auth.PropertiesFileCredentialsProvider;
import com.amazonaws.auth.SystemPropertiesCredentialsProvider;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class ChainingAWSCredentialsProvider
implements AWSCredentialsProvider {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ChainingAWSCredentialsProvider.class);
    private final List<AWSCredentialsProvider> chain;

    public static AWSCredentialsProvider getInstance() {
        return ChainingAWSCredentialsProvider.getInstance(null, null, null, null, null);
    }

    public static AWSCredentialsProvider getInstance(String credentialAccessKey, String credentialSecretKey) {
        return ChainingAWSCredentialsProvider.getInstance(credentialAccessKey, credentialSecretKey, null, null, null);
    }

    public static AWSCredentialsProvider getInstance(String credentialAccessKey, String credentialSecretKey, Resource credentialPropertiesFile) {
        return ChainingAWSCredentialsProvider.getInstance(credentialAccessKey, credentialSecretKey, credentialPropertiesFile, null, null);
    }

    public static AWSCredentialsProvider getInstance(String credentialAccessKey, String credentialSecretKey, Resource credentialPropertiesFile, String profilePath, String profileName) {
        LOGGER.debug("Attempting to locate AWS credentials...");
        ArrayList<AWSCredentialsProvider> chain = new ArrayList<AWSCredentialsProvider>();
        chain.add((AWSCredentialsProvider)new InstanceProfileCredentialsProvider(false));
        if (credentialPropertiesFile != null) {
            try {
                File f = credentialPropertiesFile.getFile();
                chain.add((AWSCredentialsProvider)new PropertiesFileCredentialsProvider(f.getCanonicalPath()));
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)profilePath) && StringUtils.isNotBlank((CharSequence)profileName)) {
            ChainingAWSCredentialsProvider.addProviderToChain(nothing -> {
                chain.add((AWSCredentialsProvider)new ProfileCredentialsProvider(profilePath, profileName));
                return null;
            });
        }
        ChainingAWSCredentialsProvider.addProviderToChain(nothing -> {
            chain.add((AWSCredentialsProvider)new SystemPropertiesCredentialsProvider());
            return null;
        });
        ChainingAWSCredentialsProvider.addProviderToChain(nothing -> {
            chain.add((AWSCredentialsProvider)new EnvironmentVariableCredentialsProvider());
            return null;
        });
        ChainingAWSCredentialsProvider.addProviderToChain(nothing -> {
            chain.add((AWSCredentialsProvider)new ClasspathPropertiesFileCredentialsProvider("awscredentials.properties"));
            return null;
        });
        if (StringUtils.isNotBlank((CharSequence)credentialAccessKey) && StringUtils.isNotBlank((CharSequence)credentialSecretKey)) {
            ChainingAWSCredentialsProvider.addProviderToChain(nothing -> {
                BasicAWSCredentials credentials = new BasicAWSCredentials(credentialAccessKey, credentialSecretKey);
                chain.add((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)credentials));
                return null;
            });
        }
        LOGGER.debug("AWS chained credential providers are configured as [{}]", chain);
        return new ChainingAWSCredentialsProvider(chain);
    }

    private static void addProviderToChain(Function<Void, Void> func) {
        try {
            func.apply(null);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public AWSCredentials getCredentials() {
        LOGGER.debug("Attempting to locate AWS credentials from the chain...");
        for (AWSCredentialsProvider p : this.chain) {
            AWSCredentials c = ChainingAWSCredentialsProvider.getCredentialsFromProvider(p);
            if (c == null) continue;
            LOGGER.debug("Fetched credentials from [{}] provider successfully.", (Object)p.getClass().getSimpleName());
            return c;
        }
        LOGGER.warn("No AWS credentials could be determined from the chain. Using anonymous credentials...");
        return new AnonymousAWSCredentials();
    }

    private static AWSCredentials getCredentialsFromProvider(AWSCredentialsProvider p) {
        try {
            LOGGER.debug("Calling credential provider [{}] to fetch credentials...", (Object)p.getClass().getSimpleName());
            return p.getCredentials();
        }
        catch (Throwable e) {
            LOGGER.trace(e.getMessage(), e);
            return null;
        }
    }

    public void refresh() {
        for (AWSCredentialsProvider p : this.chain) {
            try {
                p.refresh();
            }
            catch (Throwable e) {
                LOGGER.trace(e.getMessage(), e);
            }
        }
    }

    @Generated
    public ChainingAWSCredentialsProvider(List<AWSCredentialsProvider> chain) {
        this.chain = chain;
    }

    @Generated
    public List<AWSCredentialsProvider> getChain() {
        return this.chain;
    }
}

