/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.aws;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import java.net.InetAddress;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.model.support.aws.BaseAmazonWebServicesProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmazonClientConfigurationBuilder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AmazonClientConfigurationBuilder.class);

    public static ClientConfiguration buildClientConfiguration(BaseAmazonWebServicesProperties props) {
        ClientConfiguration cfg = new ClientConfiguration();
        cfg.setConnectionTimeout(props.getConnectionTimeout());
        cfg.setMaxConnections(props.getMaxConnections());
        cfg.setRequestTimeout(props.getRequestTimeout());
        cfg.setSocketTimeout(props.getSocketTimeout());
        cfg.setUseGzip(props.isUseGzip());
        cfg.setUseReaper(props.isUseReaper());
        cfg.setUseThrottleRetries(props.isUseThrottleRetries());
        cfg.setUseTcpKeepAlive(props.isUseTcpKeepAlive());
        cfg.setProtocol(Protocol.valueOf((String)props.getProtocol().toUpperCase()));
        cfg.setClientExecutionTimeout(props.getClientExecutionTimeout());
        if (props.getMaxErrorRetry() > 0) {
            cfg.setMaxErrorRetry(props.getMaxErrorRetry());
        }
        cfg.setProxyHost(props.getProxyHost());
        cfg.setProxyPassword(props.getProxyPassword());
        if (props.getProxyPort() > 0) {
            cfg.setProxyPort(props.getProxyPort());
        }
        cfg.setProxyUsername(props.getProxyUsername());
        cfg.setCacheResponseMetadata(props.isCacheResponseMetadata());
        if (StringUtils.isNotBlank((CharSequence)props.getLocalAddress())) {
            LOGGER.trace("Creating DynamoDb client local address [{}]", (Object)props.getLocalAddress());
            cfg.setLocalAddress(InetAddress.getByName(props.getLocalAddress()));
        }
        return cfg;
    }
}

