/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.watch;

import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.server.DumbWatcher;
import org.apache.zookeeper.server.watch.IWatchManager;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;

@Fork(value=3)
public class WatchBench {
    static final String pathPrefix = "/reasonably/long/path/";
    static final Watcher.Event.EventType event = Watcher.Event.EventType.NodeDataChanged;

    static IWatchManager createWatchManager(String className) throws Exception {
        Class<?> clazz = Class.forName("org.apache.zookeeper.server.watch." + className);
        return (IWatchManager)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    static void forceGC() {
        int gcTimes = 3;
        for (int i = 0; i < gcTimes; ++i) {
            try {
                System.gc();
                Thread.currentThread();
                Thread.sleep(1000L);
                System.runFinalization();
                Thread.currentThread();
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    static long getMemoryUse() {
        WatchBench.forceGC();
        long totalMem = Runtime.getRuntime().totalMemory();
        WatchBench.forceGC();
        long freeMem = Runtime.getRuntime().freeMemory();
        return totalMem - freeMem;
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MILLISECONDS)
    @Warmup(iterations=1, time=10, timeUnit=TimeUnit.SECONDS)
    @Measurement(iterations=3, time=10, timeUnit=TimeUnit.SECONDS)
    public void testAddConcentrateWatch(IterationState state) throws Exception {
        DumbWatcher watcher = new DumbWatcher();
        for (String path : state.paths) {
            if (!state.watchManager.addWatch(path, (Watcher)watcher)) continue;
            ++state.watchesAdded;
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MILLISECONDS)
    @Warmup(iterations=1, time=10, timeUnit=TimeUnit.SECONDS)
    @Measurement(iterations=3, time=10, timeUnit=TimeUnit.SECONDS)
    public void testTriggerConcentrateWatch(InvocationState state) throws Exception {
        for (String path : state.paths) {
            state.watchManager.triggerWatch(path, event, -1L, null);
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MILLISECONDS)
    @Warmup(iterations=1, time=10, timeUnit=TimeUnit.SECONDS)
    @Measurement(iterations=3, time=10, timeUnit=TimeUnit.SECONDS)
    public void testAddSparseWatch(AddSparseWatchState state) throws Exception {
        for (Watcher watcher : state.watchers) {
            if (!state.watchManager.addWatch(state.paths[0], watcher)) continue;
            ++state.watchesAdded;
        }
        for (String string : state.paths) {
            if (!state.watchManager.addWatch(string, state.watchers[0])) continue;
            ++state.watchesAdded;
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MILLISECONDS)
    @Warmup(iterations=1, time=10, timeUnit=TimeUnit.SECONDS)
    @Measurement(iterations=3, time=10, timeUnit=TimeUnit.SECONDS)
    public void testTriggerSparseWatch(TriggerSparseWatchState state) throws Exception {
        for (String path : state.paths) {
            state.watchManager.triggerWatch(path, event, -1L, null);
        }
    }

    @State(value=Scope.Benchmark)
    public static class TriggerSparseWatchState
    extends InvocationState {
        @Param(value={"10000"})
        public int pathCount;
        @Param(value={"10000"})
        public int watcherCount;

        @Override
        public void prepare() {
            for (Watcher watcher : this.watchers) {
                this.watchManager.addWatch(this.paths[0], watcher);
            }
            for (String string : this.paths) {
                this.watchManager.addWatch(string, this.watchers[0]);
            }
        }
    }

    @State(value=Scope.Benchmark)
    public static class AddSparseWatchState
    extends InvocationState {
        @Param(value={"10000"})
        public int pathCount;
        @Param(value={"10000"})
        public int watcherCount;
        long watchesAdded = 0L;
        long memWhenSetup = 0L;

        @Override
        public void prepare() {
            this.watchesAdded = 0L;
            this.memWhenSetup = WatchBench.getMemoryUse();
        }

        @TearDown(value=Level.Invocation)
        public void tearDown() {
            long memUsed = WatchBench.getMemoryUse() - this.memWhenSetup;
            System.out.println("Memory used: " + this.watchesAdded + " " + memUsed);
            double memPerMillionWatchesMB = (double)memUsed * 1.0 / (double)this.watchesAdded;
            System.out.println("Memory used per million sparse watches " + String.format("%.2f", memPerMillionWatchesMB) + "MB");
            for (String path : this.paths) {
                this.watchManager.triggerWatch(path, event, -1L, null);
            }
        }
    }

    @State(value=Scope.Benchmark)
    public static class InvocationState {
        @Param(value={"WatchManager", "WatchManagerOptimized"})
        public String watchManagerClass;
        @Param(value={"1", "1000"})
        public int pathCount;
        @Param(value={"1", "1000"})
        public int watcherCount;
        String[] paths;
        Watcher[] watchers;
        IWatchManager watchManager;

        @Setup(value=Level.Invocation)
        public void setup() throws Exception {
            this.initialize();
            this.prepare();
        }

        void initialize() throws Exception {
            int i;
            if (this.paths == null || this.paths.length != this.pathCount) {
                this.paths = new String[this.pathCount];
                for (i = 0; i < this.pathCount; ++i) {
                    this.paths[i] = WatchBench.pathPrefix + i;
                }
            }
            if (this.watchers == null || this.watchers.length != this.watcherCount) {
                this.watchers = new Watcher[this.watcherCount];
                for (i = 0; i < this.watcherCount; ++i) {
                    this.watchers[i] = new DumbWatcher();
                }
            }
            if (this.watchManager == null || !this.watchManager.getClass().getSimpleName().contains(this.watchManagerClass)) {
                this.watchManager = WatchBench.createWatchManager(this.watchManagerClass);
            }
        }

        void prepare() {
            for (String path : this.paths) {
                for (Watcher watcher : this.watchers) {
                    this.watchManager.addWatch(path, watcher);
                }
            }
        }
    }

    @State(value=Scope.Benchmark)
    public static class IterationState {
        @Param(value={"WatchManager", "WatchManagerOptimized"})
        public String watchManagerClass;
        @Param(value={"10000"})
        public int pathCount;
        String[] paths;
        long watchesAdded = 0L;
        IWatchManager watchManager;
        long memWhenSetup = 0L;

        @Setup(value=Level.Iteration)
        public void setup() throws Exception {
            this.paths = new String[this.pathCount];
            for (int i = 0; i < this.paths.length; ++i) {
                this.paths[i] = WatchBench.pathPrefix + i;
            }
            this.watchesAdded = 0L;
            this.watchManager = WatchBench.createWatchManager(this.watchManagerClass);
            this.memWhenSetup = WatchBench.getMemoryUse();
        }

        @TearDown(value=Level.Iteration)
        public void tearDown() {
            long memUsed = WatchBench.getMemoryUse() - this.memWhenSetup;
            System.out.println("Memory used: " + this.watchesAdded + " " + memUsed);
            double memPerMillionWatchesMB = (double)memUsed * 1.0 / (double)this.watchesAdded;
            System.out.println("Memory used per million watches " + String.format("%.2f", memPerMillionWatchesMB) + "MB");
        }
    }
}

