/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yetus.maven.plugin.fileops;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Unstable
@Mojo(name="parallel-mkdirs", defaultPhase=LifecyclePhase.GENERATE_TEST_RESOURCES, threadSafe=true)
public final class CreateDirsMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}/test-dir")
    private File buildDir;
    @Parameter(defaultValue="1")
    private String forkCount;

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public void execute() throws MojoExecutionException {
        int numDirs = this.getForkCount();
        this.mkParallelDirs(this.buildDir, numDirs);
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public int getForkCount() {
        int calcForkCount = 1;
        if (this.forkCount != null) {
            String trimProp = this.forkCount.trim();
            if (trimProp.endsWith("C")) {
                double multiplier = Double.parseDouble(trimProp.substring(0, trimProp.length() - 1));
                double calculated = multiplier * (double)Runtime.getRuntime().availableProcessors();
                if (calculated > 0.0) {
                    calcForkCount = Math.max((int)calculated, 1);
                }
            } else {
                calcForkCount = Integer.parseInt(this.forkCount);
            }
        }
        return calcForkCount;
    }

    private void mkParallelDirs(File pDir, int numDirs) throws MojoExecutionException {
        for (int i = 1; i <= numDirs; ++i) {
            File newDir = new File(pDir, String.valueOf(i));
            if (newDir.exists()) continue;
            this.getLog().info((CharSequence)("Creating " + newDir.toString()));
            if (newDir.mkdirs()) continue;
            throw new MojoExecutionException("Unable to create " + newDir.toString());
        }
    }
}

