/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.Area;
import org.apache.fop.area.BlockViewport;
import org.apache.fop.area.CTM;
import org.apache.fop.area.OffDocumentExtensionAttachment;
import org.apache.fop.area.OffDocumentItem;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.RegionViewport;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.AbstractTextArea;
import org.apache.fop.area.inline.Image;
import org.apache.fop.area.inline.InlineParent;
import org.apache.fop.area.inline.Leader;
import org.apache.fop.area.inline.SpaceArea;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.area.inline.WordArea;
import org.apache.fop.datatypes.URISpecification;
import org.apache.fop.fo.extensions.ExtensionAttachment;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.LazyFont;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.render.AbstractPathOrientedRenderer;
import org.apache.fop.render.Graphics2DAdapter;
import org.apache.fop.render.ImageAdapter;
import org.apache.fop.render.RendererContext;
import org.apache.fop.render.ps.ImageEncoderCCITTFax;
import org.apache.fop.render.ps.ImageEncoderJPEG;
import org.apache.fop.render.ps.PSDictionary;
import org.apache.fop.render.ps.PSDictionaryFormatException;
import org.apache.fop.render.ps.PSFontUtils;
import org.apache.fop.render.ps.PSGraphics2DAdapter;
import org.apache.fop.render.ps.PSImageFormResource;
import org.apache.fop.render.ps.PSPageDeviceDictionary;
import org.apache.fop.render.ps.PSSupportedFlavors;
import org.apache.fop.render.ps.ResourceHandler;
import org.apache.fop.render.ps.extensions.PSCommentAfter;
import org.apache.fop.render.ps.extensions.PSCommentBefore;
import org.apache.fop.render.ps.extensions.PSExtensionAttachment;
import org.apache.fop.render.ps.extensions.PSSetPageDevice;
import org.apache.fop.render.ps.extensions.PSSetupCode;
import org.apache.fop.util.CharUtilities;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageManager;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.apache.xmlgraphics.image.loader.impl.ImageGraphics2D;
import org.apache.xmlgraphics.image.loader.impl.ImageRawCCITTFax;
import org.apache.xmlgraphics.image.loader.impl.ImageRawEPS;
import org.apache.xmlgraphics.image.loader.impl.ImageRawJPEG;
import org.apache.xmlgraphics.image.loader.impl.ImageRawStream;
import org.apache.xmlgraphics.image.loader.impl.ImageRendered;
import org.apache.xmlgraphics.image.loader.impl.ImageXMLDOM;
import org.apache.xmlgraphics.image.loader.pipeline.ImageProviderPipeline;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;
import org.apache.xmlgraphics.ps.DSCConstants;
import org.apache.xmlgraphics.ps.ImageEncoder;
import org.apache.xmlgraphics.ps.PSGenerator;
import org.apache.xmlgraphics.ps.PSImageUtils;
import org.apache.xmlgraphics.ps.PSProcSets;
import org.apache.xmlgraphics.ps.PSResource;
import org.apache.xmlgraphics.ps.PSState;
import org.apache.xmlgraphics.ps.dsc.DSCException;
import org.apache.xmlgraphics.ps.dsc.ResourceTracker;
import org.apache.xmlgraphics.ps.dsc.events.DSCCommentBoundingBox;
import org.apache.xmlgraphics.ps.dsc.events.DSCCommentHiResBoundingBox;

public class PSRenderer
extends AbstractPathOrientedRenderer
implements ImageAdapter,
PSSupportedFlavors {
    private static Log log = LogFactory.getLog((Class)PSRenderer.class);
    public static final String MIME_TYPE = "application/postscript";
    private static final String AUTO_ROTATE_LANDSCAPE = "auto-rotate-landscape";
    private static final String OPTIMIZE_RESOURCES = "optimize-resources";
    private static final String LANGUAGE_LEVEL = "language-level";
    private int currentPageNumber = 0;
    private boolean enableComments = true;
    private boolean autoRotateLandscape = false;
    private int languageLevel = 3;
    private OutputStream outputStream;
    private File tempFile;
    protected PSGenerator gen;
    private boolean twoPassGeneration = false;
    private boolean ioTrouble = false;
    private boolean inTextMode = false;
    private List setupCodeList;
    private Map fontResources;
    private Map formResources;
    private PSPageDeviceDictionary pageDeviceDictionary;
    private boolean safeSetPageDevice = false;
    private boolean dscCompliant = true;
    private Rectangle2D documentBoundingBox;
    private Collection headerComments;
    private Collection footerComments;

    public void setUserAgent(FOUserAgent agent) {
        super.setUserAgent(agent);
        Object obj = agent.getRendererOptions().get(AUTO_ROTATE_LANDSCAPE);
        if (obj != null) {
            this.setAutoRotateLandscape(this.booleanValueOf(obj));
        }
        if ((obj = agent.getRendererOptions().get(LANGUAGE_LEVEL)) != null) {
            this.setLanguageLevel(this.intValueOf(obj));
        }
        if ((obj = agent.getRendererOptions().get(OPTIMIZE_RESOURCES)) != null) {
            this.setOptimizeResources(this.booleanValueOf(obj));
        }
    }

    private boolean booleanValueOf(Object obj) {
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof String) {
            return Boolean.valueOf((String)obj);
        }
        throw new IllegalArgumentException("Boolean or \"true\" or \"false\" expected.");
    }

    private int intValueOf(Object obj) {
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        if (obj instanceof String) {
            return Integer.parseInt((String)obj);
        }
        throw new IllegalArgumentException("Integer or String with a number expected.");
    }

    public void setAutoRotateLandscape(boolean value) {
        this.autoRotateLandscape = value;
    }

    public boolean isAutoRotateLandscape() {
        return this.autoRotateLandscape;
    }

    public void setLanguageLevel(int level) {
        if (level != 2 && level != 3) {
            throw new IllegalArgumentException("Only language levels 2 or 3 are allowed/supported");
        }
        this.languageLevel = level;
    }

    public int getLanguageLevel() {
        return this.languageLevel;
    }

    public void setOptimizeResources(boolean value) {
        this.twoPassGeneration = value;
    }

    public boolean isOptimizeResources() {
        return this.twoPassGeneration;
    }

    public Graphics2DAdapter getGraphics2DAdapter() {
        return new PSGraphics2DAdapter(this);
    }

    public ImageAdapter getImageAdapter() {
        return this;
    }

    protected void writeln(String cmd) {
        try {
            this.gen.writeln(cmd);
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    protected void handleIOTrouble(IOException ioe) {
        if (!this.ioTrouble) {
            log.error((Object)"Error while writing to target file", (Throwable)ioe);
            this.ioTrouble = true;
        }
    }

    protected void comment(String comment) {
        if (this.enableComments) {
            if (comment.startsWith("%")) {
                this.writeln(comment);
            } else {
                this.writeln("%" + comment);
            }
        }
    }

    protected void movetoCurrPosition() {
        this.moveTo(this.currentIPPosition, this.currentBPPosition);
    }

    protected void clip() {
        this.writeln("clip newpath");
    }

    protected void clipRect(float x, float y, float width, float height) {
        try {
            this.gen.defineRect((double)x, (double)y, (double)width, (double)height);
            this.clip();
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    protected void moveTo(float x, float y) {
        this.writeln(this.gen.formatDouble((double)x) + " " + this.gen.formatDouble((double)y) + " M");
    }

    protected void rmoveTo(float x, float y) {
        this.writeln(this.gen.formatDouble((double)x) + " " + this.gen.formatDouble((double)y) + " RM");
    }

    protected void lineTo(float x, float y) {
        this.writeln(this.gen.formatDouble((double)x) + " " + this.gen.formatDouble((double)y) + " lineto");
    }

    protected void closePath() {
        this.writeln("cp");
    }

    protected void fillRect(float x, float y, float width, float height) {
        if (width != 0.0f && height != 0.0f) {
            try {
                this.gen.defineRect((double)x, (double)y, (double)width, (double)height);
                this.gen.writeln("fill");
            }
            catch (IOException ioe) {
                this.handleIOTrouble(ioe);
            }
        }
    }

    protected void updateColor(Color col, boolean fill) {
        try {
            this.useColor(col);
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    protected boolean isImageInlined(String uri) {
        return !this.isOptimizeResources() || uri == null || "".equals(uri);
    }

    protected boolean isImageInlined(ImageInfo info) {
        ImageProviderPipeline[] inlineCandidates;
        if (this.isImageInlined(info.getOriginalURI())) {
            return true;
        }
        if (!this.isOptimizeResources()) {
            throw new IllegalStateException("Must not get here if form support is enabled");
        }
        ImageFlavor[] inlineFlavors = this.getInlineFlavors();
        ImageManager manager = this.getUserAgent().getFactory().getImageManager();
        ImageProviderPipeline inlineChoice = manager.choosePipeline(inlineCandidates = manager.getPipelineFactory().determineCandidatePipelines(info, inlineFlavors));
        ImageFlavor inlineFlavor = inlineChoice != null ? inlineChoice.getTargetFlavor() : null;
        ImageFlavor[] formFlavors = this.getFormFlavors();
        ImageProviderPipeline[] formCandidates = manager.getPipelineFactory().determineCandidatePipelines(info, formFlavors);
        ImageProviderPipeline formChoice = manager.choosePipeline(formCandidates);
        ImageFlavor formFlavor = formChoice != null ? formChoice.getTargetFlavor() : null;
        return formFlavor == null || !formFlavor.equals((Object)inlineFlavor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void drawImage(String uri, Rectangle2D pos, Map foreignAttributes) {
        this.endTextObject();
        int x = this.currentIPPosition + (int)Math.round(pos.getX());
        int y = this.currentBPPosition + (int)Math.round(pos.getY());
        uri = URISpecification.getURL(uri);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Handling image: " + uri));
        }
        ImageManager manager = this.getUserAgent().getFactory().getImageManager();
        ImageInfo info = null;
        try {
            ImageSessionContext sessionContext = this.getUserAgent().getImageSessionContext();
            info = manager.getImageInfo(uri, sessionContext);
            int width = (int)pos.getWidth();
            int height = (int)pos.getHeight();
            float ptx = (float)x / 1000.0f;
            float pty = (float)y / 1000.0f;
            float ptw = (float)width / 1000.0f;
            float pth = (float)height / 1000.0f;
            if (this.isImageInlined(info)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Image " + info + " is inlined"));
                }
                Map hints = ImageUtil.getDefaultHints((ImageSessionContext)sessionContext);
                org.apache.xmlgraphics.image.loader.Image img = manager.getImage(info, this.getInlineFlavors(), hints, sessionContext);
                if (img instanceof ImageGraphics2D) {
                    ImageGraphics2D imageG2D = (ImageGraphics2D)img;
                    RendererContext context = this.createRendererContext(x, y, width, height, foreignAttributes);
                    this.getGraphics2DAdapter().paintImage(imageG2D.getGraphics2DImagePainter(), context, x, y, width, height);
                    return;
                }
                if (img instanceof ImageRendered) {
                    ImageRendered imgRend = (ImageRendered)img;
                    RenderedImage ri = imgRend.getRenderedImage();
                    PSImageUtils.renderBitmapImage((RenderedImage)ri, (float)ptx, (float)pty, (float)ptw, (float)pth, (PSGenerator)this.gen);
                    return;
                }
                if (img instanceof ImageXMLDOM) {
                    ImageXMLDOM imgXML = (ImageXMLDOM)img;
                    this.renderDocument(imgXML.getDocument(), imgXML.getRootNamespace(), pos, foreignAttributes);
                    return;
                }
                if (!(img instanceof ImageRawStream)) throw new UnsupportedOperationException("Unsupported image type: " + img);
                ImageRawStream raw = (ImageRawStream)img;
                if (raw instanceof ImageRawEPS) {
                    ImageRawEPS eps = (ImageRawEPS)raw;
                    Rectangle2D bbox = eps.getBoundingBox();
                    InputStream in = raw.createInputStream();
                    try {
                        PSImageUtils.renderEPS((InputStream)in, (String)uri, (Rectangle2D)new Rectangle2D.Float(ptx, pty, ptw, pth), (Rectangle2D)bbox, (PSGenerator)this.gen);
                        return;
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)in);
                    }
                }
                if (raw instanceof ImageRawCCITTFax) {
                    ImageRawCCITTFax ccitt = (ImageRawCCITTFax)raw;
                    ImageEncoderCCITTFax encoder = new ImageEncoderCCITTFax(ccitt);
                    Rectangle2D.Float targetRect = new Rectangle2D.Float(ptx, pty, ptw, pth);
                    PSImageUtils.writeImage((ImageEncoder)encoder, (Dimension)info.getSize().getDimensionPx(), (String)uri, (Rectangle2D)targetRect, (ColorSpace)ccitt.getColorSpace(), (int)1, (boolean)false, (PSGenerator)this.gen);
                    return;
                } else {
                    if (!(raw instanceof ImageRawJPEG)) throw new UnsupportedOperationException("Unsupported raw image: " + info);
                    ImageRawJPEG jpeg = (ImageRawJPEG)raw;
                    ImageEncoderJPEG encoder = new ImageEncoderJPEG(jpeg);
                    Rectangle2D.Float targetRect = new Rectangle2D.Float(ptx, pty, ptw, pth);
                    PSImageUtils.writeImage((ImageEncoder)encoder, (Dimension)info.getSize().getDimensionPx(), (String)uri, (Rectangle2D)targetRect, (ColorSpace)jpeg.getColorSpace(), (int)8, (boolean)jpeg.isInverted(), (PSGenerator)this.gen);
                }
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Image " + info + " is embedded as a form later"));
            }
            PSResource form = this.getFormForImage(uri);
            Rectangle2D.Double targetRect = new Rectangle2D.Double(ptx, pty, ptw, pth);
            PSImageUtils.paintForm((PSResource)form, (Dimension2D)info.getSize().getDimensionPt(), (Rectangle2D)targetRect, (PSGenerator)this.gen);
            return;
        }
        catch (ImageException ie) {
            log.error((Object)("Error while processing image: " + (info != null ? info.toString() : uri)), (Throwable)ie);
            return;
        }
        catch (FileNotFoundException fe) {
            log.error((Object)fe.getMessage());
            return;
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    private ImageFlavor[] getInlineFlavors() {
        ImageFlavor[] flavors = this.gen.getPSLevel() >= 3 ? LEVEL_3_FLAVORS_INLINE : LEVEL_2_FLAVORS_INLINE;
        return flavors;
    }

    private ImageFlavor[] getFormFlavors() {
        ImageFlavor[] flavors = this.gen.getPSLevel() >= 3 ? LEVEL_3_FLAVORS_FORM : LEVEL_2_FLAVORS_FORM;
        return flavors;
    }

    protected PSResource getFormForImage(String uri) {
        PSResource form;
        if (uri == null || "".equals(uri)) {
            throw new IllegalArgumentException("uri must not be empty or null");
        }
        if (this.formResources == null) {
            this.formResources = new HashMap();
        }
        if ((form = (PSResource)this.formResources.get(uri)) == null) {
            form = new PSImageFormResource(this.formResources.size() + 1, uri);
            this.formResources.put(uri, form);
        }
        return form;
    }

    public void paintImage(RenderedImage image, RendererContext context, int x, int y, int width, int height) throws IOException {
        float fx = (float)x / 1000.0f;
        x = (int)((float)x + (float)this.currentIPPosition / 1000.0f);
        float fy = (float)y / 1000.0f;
        y = (int)((float)y + (float)this.currentBPPosition / 1000.0f);
        float fw = (float)width / 1000.0f;
        float fh = (float)height / 1000.0f;
        PSImageUtils.renderBitmapImage((RenderedImage)image, (float)fx, (float)fy, (float)fw, (float)fh, (PSGenerator)this.gen);
    }

    private void drawLine(float startx, float starty, float endx, float endy) {
        this.writeln(this.gen.formatDouble((double)startx) + " " + this.gen.formatDouble((double)starty) + " M " + this.gen.formatDouble((double)endx) + " " + this.gen.formatDouble((double)endy) + " lineto stroke newpath");
    }

    public void saveGraphicsState() {
        this.endTextObject();
        try {
            this.gen.saveGraphicsState();
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    public void restoreGraphicsState() {
        try {
            this.endTextObject();
            this.gen.restoreGraphicsState();
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    protected void concatMatrix(double a, double b, double c, double d, double e, double f) {
        try {
            this.gen.concatMatrix(a, b, c, d, e, f);
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    protected void concatMatrix(double[] matrix) {
        try {
            this.gen.concatMatrix(matrix);
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    protected void concatenateTransformationMatrix(AffineTransform at) {
        try {
            this.gen.concatMatrix(at);
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    private String getPostScriptNameForFontKey(String key) {
        Map fonts = this.fontInfo.getFonts();
        Typeface tf = (Typeface)fonts.get(key);
        if (tf instanceof LazyFont) {
            tf = ((LazyFont)tf).getRealFont();
        }
        if (tf == null) {
            throw new IllegalStateException("Font not available: " + key);
        }
        return tf.getFontName();
    }

    protected PSResource getPSResourceForFontKey(String key) {
        PSResource res = null;
        if (this.fontResources != null) {
            res = (PSResource)this.fontResources.get(key);
        } else {
            this.fontResources = new HashMap();
        }
        if (res == null) {
            res = new PSResource("font", this.getPostScriptNameForFontKey(key));
            this.fontResources.put(key, res);
        }
        return res;
    }

    protected void useFont(String key, int size) {
        try {
            PSResource res = this.getPSResourceForFontKey(key);
            this.gen.useFont("/" + res.getName(), (float)size / 1000.0f);
            this.gen.getResourceTracker().notifyResourceUsageOnPage(res);
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    private void useColor(Color col) throws IOException {
        this.gen.useColor(col);
    }

    protected void drawBackAndBorders(Area area, float startx, float starty, float width, float height) {
        if (area.hasTrait(Trait.BACKGROUND) || area.hasTrait(Trait.BORDER_BEFORE) || area.hasTrait(Trait.BORDER_AFTER) || area.hasTrait(Trait.BORDER_START) || area.hasTrait(Trait.BORDER_END)) {
            this.comment("%FOPBeginBackgroundAndBorder: " + startx + " " + starty + " " + width + " " + height);
            super.drawBackAndBorders(area, startx, starty, width, height);
            this.comment("%FOPEndBackgroundAndBorder");
        }
    }

    protected void drawBorderLine(float x1, float y1, float x2, float y2, boolean horz, boolean startOrBefore, int style, Color col) {
        try {
            float w = x2 - x1;
            float h = y2 - y1;
            if (w < 0.0f || h < 0.0f) {
                log.error((Object)"Negative extent received. Border won't be painted.");
                return;
            }
            switch (style) {
                case 31: {
                    this.useColor(col);
                    if (horz) {
                        float unit = Math.abs(2.0f * h);
                        int rep = (int)(w / unit);
                        if (rep % 2 == 0) {
                            ++rep;
                        }
                        unit = w / (float)rep;
                        this.gen.useDash("[" + unit + "] 0");
                        this.gen.useLineCap(0);
                        this.gen.useLineWidth((double)h);
                        float ym = y1 + h / 2.0f;
                        this.drawLine(x1, ym, x2, ym);
                        break;
                    }
                    float unit = Math.abs(2.0f * w);
                    int rep = (int)(h / unit);
                    if (rep % 2 == 0) {
                        ++rep;
                    }
                    unit = h / (float)rep;
                    this.gen.useDash("[" + unit + "] 0");
                    this.gen.useLineCap(0);
                    this.gen.useLineWidth((double)w);
                    float xm = x1 + w / 2.0f;
                    this.drawLine(xm, y1, xm, y2);
                    break;
                }
                case 36: {
                    this.useColor(col);
                    this.gen.useLineCap(1);
                    if (horz) {
                        float unit = Math.abs(2.0f * h);
                        int rep = (int)(w / unit);
                        if (rep % 2 == 0) {
                            ++rep;
                        }
                        unit = w / (float)rep;
                        this.gen.useDash("[0 " + unit + "] 0");
                        this.gen.useLineWidth((double)h);
                        float ym = y1 + h / 2.0f;
                        this.drawLine(x1, ym, x2, ym);
                        break;
                    }
                    float unit = Math.abs(2.0f * w);
                    int rep = (int)(h / unit);
                    if (rep % 2 == 0) {
                        ++rep;
                    }
                    unit = h / (float)rep;
                    this.gen.useDash("[0 " + unit + "] 0");
                    this.gen.useLineWidth((double)w);
                    float xm = x1 + w / 2.0f;
                    this.drawLine(xm, y1, xm, y2);
                    break;
                }
                case 37: {
                    this.useColor(col);
                    this.gen.useDash(null);
                    if (horz) {
                        float h3 = h / 3.0f;
                        this.gen.useLineWidth((double)h3);
                        float ym1 = y1 + h3 / 2.0f;
                        float ym2 = ym1 + h3 + h3;
                        this.drawLine(x1, ym1, x2, ym1);
                        this.drawLine(x1, ym2, x2, ym2);
                        break;
                    }
                    float w3 = w / 3.0f;
                    this.gen.useLineWidth((double)w3);
                    float xm1 = x1 + w3 / 2.0f;
                    float xm2 = xm1 + w3 + w3;
                    this.drawLine(xm1, y1, xm1, y2);
                    this.drawLine(xm2, y1, xm2, y2);
                    break;
                }
                case 55: 
                case 119: {
                    float colFactor = style == 55 ? 0.4f : -0.4f;
                    this.gen.useDash(null);
                    if (horz) {
                        Color uppercol = PSRenderer.lightenColor(col, -colFactor);
                        Color lowercol = PSRenderer.lightenColor(col, colFactor);
                        float h3 = h / 3.0f;
                        this.gen.useLineWidth((double)h3);
                        float ym1 = y1 + h3 / 2.0f;
                        this.gen.useColor(uppercol);
                        this.drawLine(x1, ym1, x2, ym1);
                        this.gen.useColor(col);
                        this.drawLine(x1, ym1 + h3, x2, ym1 + h3);
                        this.gen.useColor(lowercol);
                        this.drawLine(x1, ym1 + h3 + h3, x2, ym1 + h3 + h3);
                        break;
                    }
                    Color leftcol = PSRenderer.lightenColor(col, -colFactor);
                    Color rightcol = PSRenderer.lightenColor(col, colFactor);
                    float w3 = w / 3.0f;
                    this.gen.useLineWidth((double)w3);
                    float xm1 = x1 + w3 / 2.0f;
                    this.gen.useColor(leftcol);
                    this.drawLine(xm1, y1, xm1, y2);
                    this.gen.useColor(col);
                    this.drawLine(xm1 + w3, y1, xm1 + w3, y2);
                    this.gen.useColor(rightcol);
                    this.drawLine(xm1 + w3 + w3, y1, xm1 + w3 + w3, y2);
                    break;
                }
                case 67: 
                case 101: {
                    float colFactor = style == 101 ? 0.4f : -0.4f;
                    this.gen.useDash(null);
                    if (horz) {
                        Color c = PSRenderer.lightenColor(col, (float)(startOrBefore ? 1 : -1) * colFactor);
                        this.gen.useLineWidth((double)h);
                        float ym1 = y1 + h / 2.0f;
                        this.gen.useColor(c);
                        this.drawLine(x1, ym1, x2, ym1);
                        break;
                    }
                    Color c = PSRenderer.lightenColor(col, (float)(startOrBefore ? 1 : -1) * colFactor);
                    this.gen.useLineWidth((double)w);
                    float xm1 = x1 + w / 2.0f;
                    this.gen.useColor(c);
                    this.drawLine(xm1, y1, xm1, y2);
                    break;
                }
                case 57: {
                    break;
                }
                default: {
                    this.useColor(col);
                    this.gen.useDash(null);
                    this.gen.useLineCap(0);
                    if (horz) {
                        this.gen.useLineWidth((double)h);
                        float ym = y1 + h / 2.0f;
                        this.drawLine(x1, ym, x2, ym);
                        break;
                    }
                    this.gen.useLineWidth((double)w);
                    float xm = x1 + w / 2.0f;
                    this.drawLine(xm, y1, xm, y2);
                    break;
                }
            }
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
        OutputStream out;
        log.debug((Object)"Rendering areas to PostScript...");
        this.outputStream = outputStream;
        if (this.isOptimizeResources()) {
            this.tempFile = File.createTempFile("fop", null);
            out = new FileOutputStream(this.tempFile);
            out = new BufferedOutputStream(out);
        } else {
            out = this.outputStream;
        }
        this.gen = new PSGenerator(out){

            public Source resolveURI(String uri) {
                return PSRenderer.this.userAgent.resolveURI(uri);
            }
        };
        this.gen.setPSLevel(this.getLanguageLevel());
        this.currentPageNumber = 0;
        this.pageDeviceDictionary = new PSPageDeviceDictionary();
        this.pageDeviceDictionary.setFlushOnRetrieval(!this.dscCompliant);
        this.pageDeviceDictionary.put("/ImagingBBox", "null");
    }

    private void writeHeader() throws IOException {
        this.writeln("%!PS-Adobe-3.0");
        this.gen.writeDSCComment("Creator", (Object[])new String[]{this.userAgent.getProducer()});
        this.gen.writeDSCComment("CreationDate", new Object[]{new Date()});
        this.gen.writeDSCComment("LanguageLevel", (Object)new Integer(this.gen.getPSLevel()));
        this.gen.writeDSCComment("Pages", new Object[]{DSCConstants.ATEND});
        this.gen.writeDSCComment("BoundingBox", DSCConstants.ATEND);
        this.gen.writeDSCComment("HiResBoundingBox", DSCConstants.ATEND);
        this.documentBoundingBox = new Rectangle2D.Double();
        this.gen.writeDSCComment("DocumentSuppliedResources", new Object[]{DSCConstants.ATEND});
        if (this.headerComments != null) {
            Iterator iter = this.headerComments.iterator();
            while (iter.hasNext()) {
                PSExtensionAttachment comment = (PSExtensionAttachment)iter.next();
                this.gen.writeln("%" + comment.getContent());
            }
        }
        this.gen.writeDSCComment("EndComments");
        this.gen.writeDSCComment("BeginDefaults");
        this.gen.writeDSCComment("EndDefaults");
        this.gen.writeDSCComment("BeginProlog");
        PSProcSets.writeStdProcSet((PSGenerator)this.gen);
        PSProcSets.writeEPSProcSet((PSGenerator)this.gen);
        this.gen.writeDSCComment("EndProlog");
        this.gen.writeDSCComment("BeginSetup");
        this.writeSetupCodeList(this.setupCodeList, "SetupCode");
        if (!this.isOptimizeResources()) {
            this.fontResources = PSFontUtils.writeFontDict(this.gen, this.fontInfo);
        } else {
            this.gen.commentln("%FOPFontSetup");
        }
        this.gen.writeDSCComment("EndSetup");
    }

    public void stopRenderer() throws IOException {
        this.gen.writeDSCComment("Trailer");
        if (this.footerComments != null) {
            Iterator iter = this.footerComments.iterator();
            while (iter.hasNext()) {
                PSExtensionAttachment comment = (PSExtensionAttachment)iter.next();
                this.gen.commentln("%" + comment.getContent());
            }
            this.footerComments.clear();
        }
        this.gen.writeDSCComment("Pages", (Object)new Integer(this.currentPageNumber));
        new DSCCommentBoundingBox(this.documentBoundingBox).generate(this.gen);
        new DSCCommentHiResBoundingBox(this.documentBoundingBox).generate(this.gen);
        this.gen.getResourceTracker().writeResources(false, this.gen);
        this.gen.writeDSCComment("EOF");
        this.gen.flush();
        log.debug((Object)"Rendering to PostScript complete.");
        if (this.isOptimizeResources()) {
            IOUtils.closeQuietly((OutputStream)this.gen.getOutputStream());
            this.rewritePostScriptFile();
        }
        if (this.footerComments != null) {
            this.headerComments.clear();
        }
        if (this.pageDeviceDictionary != null) {
            this.pageDeviceDictionary.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rewritePostScriptFile() throws IOException {
        log.debug((Object)"Processing PostScript resources...");
        long startTime = System.currentTimeMillis();
        ResourceTracker resTracker = this.gen.getResourceTracker();
        InputStream in = new FileInputStream(this.tempFile);
        in = new BufferedInputStream(in);
        try {
            try {
                ResourceHandler.process(this.userAgent, in, this.outputStream, this.fontInfo, resTracker, this.formResources, this.currentPageNumber, this.documentBoundingBox);
                this.outputStream.flush();
            }
            catch (DSCException e) {
                throw new RuntimeException(e.getMessage());
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            IOUtils.closeQuietly((InputStream)in);
            if (!this.tempFile.delete()) {
                this.tempFile.deleteOnExit();
                log.warn((Object)("Could not delete temporary file: " + this.tempFile));
            }
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        if (!this.tempFile.delete()) {
            this.tempFile.deleteOnExit();
            log.warn((Object)("Could not delete temporary file: " + this.tempFile));
        }
        if (log.isDebugEnabled()) {
            long duration = System.currentTimeMillis() - startTime;
            log.debug((Object)("Resource Processing complete in " + duration + " ms."));
        }
    }

    public void processOffDocumentItem(OffDocumentItem oDI) {
        ExtensionAttachment attachment;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Handling OffDocumentItem: " + oDI.getName()));
        }
        if (oDI instanceof OffDocumentExtensionAttachment && (attachment = ((OffDocumentExtensionAttachment)oDI).getAttachment()) != null && "apache:fop:extensions:postscript".equals(attachment.getCategory())) {
            if (attachment instanceof PSSetupCode) {
                if (this.setupCodeList == null) {
                    this.setupCodeList = new ArrayList();
                }
                if (!this.setupCodeList.contains(attachment)) {
                    this.setupCodeList.add(attachment);
                }
            } else if (attachment instanceof PSSetPageDevice) {
                PSSetPageDevice setPageDevice = (PSSetPageDevice)attachment;
                String content = setPageDevice.getContent();
                if (content != null) {
                    try {
                        this.pageDeviceDictionary.putAll(PSDictionary.valueOf(content));
                    }
                    catch (PSDictionaryFormatException e) {
                        log.error((Object)("Failed to parse dictionary string: " + e.getMessage() + ", content = '" + content + "'"));
                    }
                }
            } else if (attachment instanceof PSCommentBefore) {
                if (this.headerComments == null) {
                    this.headerComments = new ArrayList();
                }
                this.headerComments.add(attachment);
            } else if (attachment instanceof PSCommentAfter) {
                if (this.footerComments == null) {
                    this.footerComments = new ArrayList();
                }
                this.footerComments.add(attachment);
            }
        }
        super.processOffDocumentItem(oDI);
    }

    private void writeSetupCodeList(List setupCodeList, String type) throws IOException {
        if (setupCodeList != null) {
            Iterator i = setupCodeList.iterator();
            while (i.hasNext()) {
                String line;
                PSSetupCode setupCode = (PSSetupCode)i.next();
                this.gen.commentln("%FOPBegin" + type + ": (" + (setupCode.getName() != null ? setupCode.getName() : "") + ")");
                LineNumberReader reader = new LineNumberReader(new StringReader(setupCode.getContent()));
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).length() <= 0) continue;
                    this.gen.writeln(line.trim());
                }
                this.gen.commentln("%FOPEnd" + type);
                i.remove();
            }
        }
    }

    public void renderPage(PageViewport page) throws IOException, FOPException {
        PSExtensionAttachment attachment;
        Object attObj;
        List extensionAttachments;
        log.debug((Object)("renderPage(): " + page));
        if (this.currentPageNumber == 0) {
            this.writeHeader();
        }
        ++this.currentPageNumber;
        this.gen.getResourceTracker().notifyStartNewPage();
        this.gen.getResourceTracker().notifyResourceUsageOnPage(PSProcSets.STD_PROCSET);
        this.gen.writeDSCComment("Page", new Object[]{page.getPageNumberString(), new Integer(this.currentPageNumber)});
        double pageWidth = (float)Math.round(page.getViewArea().getWidth()) / 1000.0f;
        double pageHeight = (float)Math.round(page.getViewArea().getHeight()) / 1000.0f;
        boolean rotate = false;
        ArrayList<Long> pageSizes = new ArrayList<Long>();
        if (this.autoRotateLandscape && pageHeight < pageWidth) {
            rotate = true;
            pageSizes.add(new Long(Math.round(pageHeight)));
            pageSizes.add(new Long(Math.round(pageWidth)));
        } else {
            pageSizes.add(new Long(Math.round(pageWidth)));
            pageSizes.add(new Long(Math.round(pageHeight)));
        }
        this.pageDeviceDictionary.put("/PageSize", pageSizes);
        if (page.hasExtensionAttachments()) {
            Iterator iter = page.getExtensionAttachments().iterator();
            while (iter.hasNext()) {
                PSSetPageDevice setPageDevice;
                String content;
                ExtensionAttachment attachment2 = (ExtensionAttachment)iter.next();
                if (!(attachment2 instanceof PSSetPageDevice) || (content = (setPageDevice = (PSSetPageDevice)attachment2).getContent()) == null) continue;
                try {
                    this.pageDeviceDictionary.putAll(PSDictionary.valueOf(content));
                }
                catch (PSDictionaryFormatException e) {
                    log.error((Object)("failed to parse dictionary string: " + e.getMessage() + ", [" + content + "]"));
                }
            }
        }
        try {
            if (this.setupCodeList != null) {
                this.writeEnclosedExtensionAttachments(this.setupCodeList);
                this.setupCodeList.clear();
            }
        }
        catch (IOException e) {
            log.error((Object)e.getMessage());
        }
        Integer zero = new Integer(0);
        Rectangle2D.Double pageBoundingBox = new Rectangle2D.Double();
        if (rotate) {
            ((Rectangle2D)pageBoundingBox).setRect(0.0, 0.0, pageHeight, pageWidth);
            this.gen.writeDSCComment("PageBoundingBox", new Object[]{zero, zero, new Long(Math.round(pageHeight)), new Long(Math.round(pageWidth))});
            this.gen.writeDSCComment("PageHiResBoundingBox", new Object[]{zero, zero, new Double(pageHeight), new Double(pageWidth)});
            this.gen.writeDSCComment("PageOrientation", (Object)"Landscape");
        } else {
            ((Rectangle2D)pageBoundingBox).setRect(0.0, 0.0, pageWidth, pageHeight);
            this.gen.writeDSCComment("PageBoundingBox", new Object[]{zero, zero, new Long(Math.round(pageWidth)), new Long(Math.round(pageHeight))});
            this.gen.writeDSCComment("PageHiResBoundingBox", new Object[]{zero, zero, new Double(pageWidth), new Double(pageHeight)});
            if (this.autoRotateLandscape) {
                this.gen.writeDSCComment("PageOrientation", (Object)"Portrait");
            }
        }
        this.documentBoundingBox.add(pageBoundingBox);
        this.gen.writeDSCComment("PageResources", new Object[]{DSCConstants.ATEND});
        this.gen.commentln("%FOPSimplePageMaster: " + page.getSimplePageMasterName());
        this.gen.writeDSCComment("BeginPageSetup");
        if (page.hasExtensionAttachments()) {
            extensionAttachments = page.getExtensionAttachments();
            for (int i = 0; i < extensionAttachments.size(); ++i) {
                attObj = extensionAttachments.get(i);
                if (!(attObj instanceof PSExtensionAttachment) || !((attachment = (PSExtensionAttachment)attObj) instanceof PSCommentBefore)) continue;
                this.gen.commentln("%" + attachment.getContent());
            }
        }
        if (!this.pageDeviceDictionary.isEmpty()) {
            String content = this.pageDeviceDictionary.getContent();
            content = this.safeSetPageDevice ? content + " SSPD" : content + " setpagedevice";
            this.writeEnclosedExtensionAttachment(new PSSetPageDevice(content));
        }
        if (rotate) {
            this.gen.writeln(Math.round(pageHeight) + " 0 translate");
            this.gen.writeln("90 rotate");
        }
        this.concatMatrix(1.0, 0.0, 0.0, -1.0, 0.0, pageHeight);
        this.gen.writeDSCComment("EndPageSetup");
        super.renderPage(page);
        this.writeln("showpage");
        this.gen.writeDSCComment("PageTrailer");
        if (page.hasExtensionAttachments()) {
            extensionAttachments = page.getExtensionAttachments();
            for (int i = 0; i < extensionAttachments.size(); ++i) {
                attObj = extensionAttachments.get(i);
                if (!(attObj instanceof PSExtensionAttachment) || !((attachment = (PSExtensionAttachment)attObj) instanceof PSCommentAfter)) continue;
                this.gen.commentln("%" + attachment.getContent());
            }
        }
        this.gen.getResourceTracker().writeResources(true, this.gen);
    }

    protected void renderRegionViewport(RegionViewport port) {
        if (port != null) {
            this.comment("%FOPBeginRegionViewport: " + port.getRegionReference().getRegionName());
            super.renderRegionViewport(port);
            this.comment("%FOPEndRegionViewport");
        }
    }

    protected void beginTextObject() {
        if (!this.inTextMode) {
            this.saveGraphicsState();
            this.writeln("BT");
            this.inTextMode = true;
        }
    }

    protected void endTextObject() {
        if (this.inTextMode) {
            this.inTextMode = false;
            this.writeln("ET");
            this.restoreGraphicsState();
        }
    }

    public void renderText(TextArea area) {
        this.renderInlineAreaBackAndBorders(area);
        String fontname = this.getInternalFontNameForArea(area);
        int fontsize = area.getTraitAsInteger(Trait.FONT_SIZE);
        Typeface tf = (Typeface)this.fontInfo.getFonts().get(fontname);
        int rx = this.currentIPPosition + area.getBorderAndPaddingWidthStart();
        int bl = this.currentBPPosition + area.getOffset() + area.getBaselineOffset();
        this.useFont(fontname, fontsize);
        Color ct = (Color)area.getTrait(Trait.COLOR);
        if (ct != null) {
            try {
                this.useColor(ct);
            }
            catch (IOException ioe) {
                this.handleIOTrouble(ioe);
            }
        }
        this.beginTextObject();
        this.writeln("1 0 0 -1 " + this.gen.formatDouble((double)((float)rx / 1000.0f)) + " " + this.gen.formatDouble((double)((float)bl / 1000.0f)) + " Tm");
        super.renderText(area);
        this.renderTextDecoration(tf, fontsize, area, bl, rx);
    }

    protected void renderWord(WordArea word) {
        this.renderText((TextArea)word.getParentArea(), word.getWord(), word.getLetterAdjustArray());
        super.renderWord(word);
    }

    protected void renderSpace(SpaceArea space) {
        AbstractTextArea textArea = (AbstractTextArea)space.getParentArea();
        String s = space.getSpace();
        char sp = s.charAt(0);
        Font font = this.getFontFromArea(textArea);
        int tws = space.isAdjustable() ? ((TextArea)space.getParentArea()).getTextWordSpaceAdjust() + 2 * textArea.getTextLetterSpaceAdjust() : 0;
        this.rmoveTo((float)(font.getCharWidth(sp) + tws) / 1000.0f, 0.0f);
        super.renderSpace(space);
    }

    private void renderText(AbstractTextArea area, String text, int[] letterAdjust) {
        Font font = this.getFontFromArea(area);
        Typeface tf = (Typeface)this.fontInfo.getFonts().get(font.getFontName());
        int initialSize = text.length();
        initialSize += initialSize / 2;
        StringBuffer sb = new StringBuffer(initialSize);
        int textLen = text.length();
        if (letterAdjust == null && area.getTextLetterSpaceAdjust() == 0 && area.getTextWordSpaceAdjust() == 0) {
            sb.append("(");
            for (int i = 0; i < textLen; ++i) {
                char c = text.charAt(i);
                char mapped = tf.mapChar(c);
                PSGenerator.escapeChar((char)mapped, (StringBuffer)sb);
            }
            sb.append(") t");
        } else {
            int i;
            sb.append("(");
            int[] offsets = new int[textLen];
            for (i = 0; i < textLen; ++i) {
                char c = text.charAt(i);
                char mapped = tf.mapChar(c);
                int wordSpace = CharUtilities.isAdjustableSpace(mapped) ? area.getTextWordSpaceAdjust() : 0;
                int cw = tf.getWidth(mapped, font.getFontSize()) / 1000;
                int ladj = letterAdjust != null && i < textLen - 1 ? letterAdjust[i + 1] : 0;
                int tls = i < textLen - 1 ? area.getTextLetterSpaceAdjust() : 0;
                offsets[i] = cw + ladj + tls + wordSpace;
                PSGenerator.escapeChar((char)mapped, (StringBuffer)sb);
            }
            sb.append(")\n[");
            for (i = 0; i < textLen; ++i) {
                if (i > 0) {
                    if (i % 8 == 0) {
                        sb.append('\n');
                    } else {
                        sb.append(" ");
                    }
                }
                sb.append(this.gen.formatDouble((double)((float)offsets[i] / 1000.0f)));
            }
            sb.append("]\nxshow");
        }
        this.writeln(sb.toString());
    }

    protected List breakOutOfStateStack() {
        try {
            ArrayList<PSState> breakOutList = new ArrayList<PSState>();
            while (true) {
                if (breakOutList.size() == 0) {
                    this.endTextObject();
                    this.comment("------ break out!");
                }
                PSState state = this.gen.getCurrentState();
                if (!this.gen.restoreGraphicsState()) break;
                breakOutList.add(0, state);
            }
            return breakOutList;
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
            return null;
        }
    }

    protected void restoreStateStackAfterBreakOut(List breakOutList) {
        try {
            this.comment("------ restoring context after break-out...");
            Iterator i = breakOutList.iterator();
            while (i.hasNext()) {
                PSState state = (PSState)i.next();
                this.saveGraphicsState();
                state.reestablish(this.gen);
            }
            this.comment("------ done.");
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    protected void startVParea(CTM ctm, Rectangle2D clippingRect) {
        this.saveGraphicsState();
        if (clippingRect != null) {
            this.clipRect((float)clippingRect.getX() / 1000.0f, (float)clippingRect.getY() / 1000.0f, (float)clippingRect.getWidth() / 1000.0f, (float)clippingRect.getHeight() / 1000.0f);
        }
        double[] matrix = ctm.toArray();
        matrix[4] = matrix[4] / 1000.0;
        matrix[5] = matrix[5] / 1000.0;
        this.concatMatrix(matrix);
    }

    protected void endVParea() {
        this.restoreGraphicsState();
    }

    protected void renderBlockViewport(BlockViewport bv, List children) {
        this.comment("%FOPBeginBlockViewport: " + bv.toString());
        super.renderBlockViewport(bv, children);
        this.comment("%FOPEndBlockViewport");
    }

    protected void renderInlineParent(InlineParent ip) {
        super.renderInlineParent(ip);
    }

    public void renderLeader(Leader area) {
        this.renderInlineAreaBackAndBorders(area);
        this.endTextObject();
        this.saveGraphicsState();
        int style = area.getRuleStyle();
        float startx = (float)(this.currentIPPosition + area.getBorderAndPaddingWidthStart()) / 1000.0f;
        float starty = (float)(this.currentBPPosition + area.getOffset()) / 1000.0f;
        float endx = (float)(this.currentIPPosition + area.getBorderAndPaddingWidthStart() + area.getIPD()) / 1000.0f;
        float ruleThickness = (float)area.getRuleThickness() / 1000.0f;
        Color col = (Color)area.getTrait(Trait.COLOR);
        try {
            switch (style) {
                case 31: 
                case 37: 
                case 133: {
                    this.drawBorderLine(startx, starty, endx, starty + ruleThickness, true, true, style, col);
                    break;
                }
                case 36: {
                    this.clipRect(startx, starty, endx - startx, ruleThickness);
                    this.gen.concatMatrix(1.0, 0.0, 0.0, 1.0, (double)(ruleThickness / 2.0f), 0.0);
                    this.drawBorderLine(startx, starty, endx, starty + ruleThickness, true, true, style, col);
                    break;
                }
                case 55: 
                case 119: {
                    float half = (float)area.getRuleThickness() / 2000.0f;
                    this.gen.useColor(PSRenderer.lightenColor(col, 0.6f));
                    this.moveTo(startx, starty);
                    this.lineTo(endx, starty);
                    this.lineTo(endx, starty + 2.0f * half);
                    this.lineTo(startx, starty + 2.0f * half);
                    this.closePath();
                    this.gen.writeln(" fill newpath");
                    this.gen.useColor(col);
                    if (style == 55) {
                        this.moveTo(startx, starty);
                        this.lineTo(endx, starty);
                        this.lineTo(endx, starty + half);
                        this.lineTo(startx + half, starty + half);
                        this.lineTo(startx, starty + 2.0f * half);
                    } else {
                        this.moveTo(endx, starty);
                        this.lineTo(endx, starty + 2.0f * half);
                        this.lineTo(startx, starty + 2.0f * half);
                        this.lineTo(startx, starty + half);
                        this.lineTo(endx - half, starty + half);
                    }
                    this.closePath();
                    this.gen.writeln(" fill newpath");
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("rule style not supported");
                }
            }
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
        this.restoreGraphicsState();
        super.renderLeader(area);
    }

    public void renderImage(Image image, Rectangle2D pos) {
        this.drawImage(image.getURL(), pos);
    }

    protected RendererContext createRendererContext(int x, int y, int width, int height, Map foreignAttributes) {
        RendererContext context = super.createRendererContext(x, y, width, height, foreignAttributes);
        context.setProperty("psGenerator", this.gen);
        context.setProperty("psFontInfo", this.fontInfo);
        return context;
    }

    public String getMimeType() {
        return MIME_TYPE;
    }

    private void writeEnclosedExtensionAttachment(PSExtensionAttachment attachment) throws IOException {
        String line;
        PSSetupCode setupCodeAttach;
        String name;
        String info = "";
        if (attachment instanceof PSSetupCode && (name = (setupCodeAttach = (PSSetupCode)attachment).getName()) != null) {
            info = info + ": (" + name + ")";
        }
        String type = attachment.getType();
        this.gen.commentln("%FOPBegin" + type + info);
        LineNumberReader reader = new LineNumberReader(new StringReader(attachment.getContent()));
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).length() <= 0) continue;
            this.gen.writeln(line);
        }
        this.gen.commentln("%FOPEnd" + type);
    }

    private void writeEnclosedExtensionAttachments(Collection attachmentCollection) throws IOException {
        Iterator iter = attachmentCollection.iterator();
        while (iter.hasNext()) {
            PSExtensionAttachment attachment = (PSExtensionAttachment)iter.next();
            if (attachment != null) {
                this.writeEnclosedExtensionAttachment(attachment);
            }
            iter.remove();
        }
    }

    public void setSafeSetPageDevice(boolean safeSetPageDevice) {
        this.safeSetPageDevice = safeSetPageDevice;
    }

    public void setDSCCompliant(boolean dscCompliant) {
        this.dscCompliant = dscCompliant;
    }
}

