/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf.rtflib.rtfdoc;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfBookmark;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfElement;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfExternalGraphic;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfFootnote;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfHyperLink;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfListItem;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfPageNumber;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfSpaceManager;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfSpaceSplitter;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfString;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTableCell;

public class RtfTextrun
extends RtfContainer {
    private boolean bSuppressLastPar = false;
    private RtfListItem rtfListItem;
    private RtfSpaceManager rtfSpaceManager = new RtfSpaceManager();

    RtfTextrun(RtfContainer parent, Writer w, RtfAttributes attrs) throws IOException {
        super(parent, w, attrs);
    }

    private void addOpenGroupMark(RtfAttributes attrs) throws IOException {
        RtfOpenGroupMark r = new RtfOpenGroupMark(this, this.writer, attrs);
    }

    private void addCloseGroupMark() throws IOException {
        RtfCloseGroupMark r = new RtfCloseGroupMark(this, this.writer);
    }

    public void pushBlockAttributes(RtfAttributes attrs) throws IOException {
        this.rtfSpaceManager.stopUpdatingSpaceBefore();
        RtfSpaceSplitter splitter = this.rtfSpaceManager.pushRtfSpaceSplitter(attrs);
        this.addOpenGroupMark(splitter.getCommonAttributes());
    }

    public void popBlockAttributes() throws IOException {
        this.rtfSpaceManager.popRtfSpaceSplitter();
        this.rtfSpaceManager.stopUpdatingSpaceBefore();
        this.addCloseGroupMark();
    }

    public void pushInlineAttributes(RtfAttributes attrs) throws IOException {
        this.rtfSpaceManager.pushInlineAttributes(attrs);
        this.addOpenGroupMark(attrs);
    }

    public void popInlineAttributes() throws IOException {
        this.rtfSpaceManager.popInlineAttributes();
        this.addCloseGroupMark();
    }

    public void addString(String s) throws IOException {
        if (s.equals("")) {
            return;
        }
        RtfAttributes attrs = this.rtfSpaceManager.getLastInlineAttribute();
        this.rtfSpaceManager.pushRtfSpaceSplitter(attrs);
        this.rtfSpaceManager.setCandidate(attrs);
        RtfString r = new RtfString((RtfContainer)this, this.writer, s);
        this.rtfSpaceManager.popRtfSpaceSplitter();
    }

    public RtfFootnote addFootnote() throws IOException {
        return new RtfFootnote(this, this.writer);
    }

    public void addParagraphBreak() throws IOException {
        List children = this.getChildren();
        int deletedCloseGroupCount = 0;
        ListIterator lit = children.listIterator(children.size());
        while (lit.hasPrevious() && lit.previous() instanceof RtfCloseGroupMark) {
            lit.remove();
            ++deletedCloseGroupCount;
        }
        if (children.size() != 0) {
            this.setChildren(children);
            new RtfParagraphBreak(this, this.writer);
            for (int i = 0; i < deletedCloseGroupCount; ++i) {
                this.addCloseGroupMark();
            }
        }
    }

    public void addPageNumber(RtfAttributes attr) throws IOException {
        RtfPageNumber r = new RtfPageNumber(this, this.writer, attr);
    }

    public RtfHyperLink addHyperlink(RtfAttributes attr) throws IOException {
        return new RtfHyperLink(this, this.writer, attr);
    }

    public void addBookmark(String id) throws IOException {
        if (id != "") {
            new RtfBookmark((RtfContainer)this, this.writer, id);
        }
    }

    public RtfExternalGraphic newImage() throws IOException {
        return new RtfExternalGraphic(this, this.writer);
    }

    public static RtfTextrun getTextrun(RtfContainer container, Writer writer, RtfAttributes attrs) throws IOException {
        List list = container.getChildren();
        if (list.size() == 0) {
            RtfTextrun textrun = new RtfTextrun(container, writer, attrs);
            list.add(textrun);
            return textrun;
        }
        Object obj = list.get(list.size() - 1);
        if (obj instanceof RtfTextrun) {
            return (RtfTextrun)obj;
        }
        RtfTextrun textrun = new RtfTextrun(container, writer, attrs);
        list.add(textrun);
        return textrun;
    }

    public void setSuppressLastPar(boolean bSuppress) {
        this.bSuppressLastPar = bSuppress;
    }

    protected void writeRtfContent() throws IOException {
        boolean bHasTableCellParent = this.getParentOfClass(RtfTableCell.class) != null;
        RtfAttributes attrBlockLevel = new RtfAttributes();
        boolean bLast = false;
        Iterator it = this.parent.getChildren().iterator();
        while (it.hasNext()) {
            if (it.next() != this) continue;
            bLast = !it.hasNext();
            break;
        }
        RtfParagraphBreak lastParagraphBreak = null;
        if (bLast) {
            Iterator it2 = this.getChildren().iterator();
            while (it2.hasNext()) {
                RtfElement e = (RtfElement)it2.next();
                if (e instanceof RtfParagraphBreak) {
                    lastParagraphBreak = (RtfParagraphBreak)e;
                    continue;
                }
                if (e instanceof RtfOpenGroupMark || e instanceof RtfCloseGroupMark || !e.isEmpty()) continue;
                lastParagraphBreak = null;
            }
        }
        this.writeAttributes(this.attrib, null);
        if (this.rtfListItem != null) {
            this.rtfListItem.getRtfListStyle().writeParagraphPrefix(this);
        }
        boolean bPrevPar = false;
        boolean bFirst = true;
        Iterator it3 = this.getChildren().iterator();
        while (it3.hasNext()) {
            RtfElement e = (RtfElement)it3.next();
            boolean bRtfParagraphBreak = e instanceof RtfParagraphBreak;
            if (bHasTableCellParent) {
                attrBlockLevel.set(e.getRtfAttributes());
            }
            boolean bHide = false;
            bHide = bRtfParagraphBreak;
            boolean bl = bHide = bHide && (bPrevPar || bFirst || this.bSuppressLastPar && bLast && lastParagraphBreak != null && e == lastParagraphBreak);
            if (!bHide) {
                this.newLine();
                e.writeRtf();
                if (this.rtfListItem != null && e instanceof RtfParagraphBreak) {
                    this.rtfListItem.getRtfListStyle().writeParagraphPrefix(this);
                }
            }
            if (e instanceof RtfParagraphBreak) {
                bPrevPar = true;
                continue;
            }
            if (e instanceof RtfCloseGroupMark || e instanceof RtfOpenGroupMark) continue;
            bPrevPar = bPrevPar && e.isEmpty();
            bFirst = bFirst && e.isEmpty();
        }
        if (bHasTableCellParent) {
            this.writeAttributes(attrBlockLevel, null);
        }
    }

    public void setRtfListItem(RtfListItem listItem) {
        this.rtfListItem = listItem;
    }

    public RtfListItem getRtfListItem() {
        return this.rtfListItem;
    }

    private class RtfParagraphBreak
    extends RtfElement {
        RtfParagraphBreak(RtfContainer parent, Writer w) throws IOException {
            super(parent, w);
        }

        public boolean isEmpty() {
            return false;
        }

        protected void writeRtfContent() throws IOException {
            this.writeControlWord("par");
        }
    }

    private class RtfCloseGroupMark
    extends RtfElement {
        RtfCloseGroupMark(RtfContainer parent, Writer w) throws IOException {
            super(parent, w);
        }

        public boolean isEmpty() {
            return false;
        }

        protected void writeRtfContent() throws IOException {
            this.writeGroupMark(false);
        }
    }

    private class RtfOpenGroupMark
    extends RtfElement {
        RtfOpenGroupMark(RtfContainer parent, Writer w, RtfAttributes attr) throws IOException {
            super(parent, w, attr);
        }

        public boolean isEmpty() {
            return false;
        }

        protected void writeRtfContent() throws IOException {
            this.writeGroupMark(true);
            this.writeAttributes(this.getRtfAttributes(), null);
        }
    }
}

