/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.command;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xbean.command.Command;
import org.apache.xbean.command.CommandRegistry;

public class CommandShell
implements Command {
    private final String prompt;
    private boolean stop = false;
    private int rc = 0;
    public static final char ESC = '\u001b';
    public static final String TTY_Reset = "\u001b[0m";
    public static final String TTY_Bright = "\u001b[1m";
    public static final String TTY_Dim = "\u001b[2m";
    public static final String TTY_Underscore = "\u001b[4m";
    public static final String TTY_Blink = "\u001b[5m";
    public static final String TTY_Reverse = "\u001b[7m";
    public static final String TTY_Hidden = "\u001b[8m";
    public static final String TTY_FG_Black = "\u001b[30m";
    public static final String TTY_FG_Red = "\u001b[31m";
    public static final String TTY_FG_Green = "\u001b[32m";
    public static final String TTY_FG_Yellow = "\u001b[33m";
    public static final String TTY_FG_Blue = "\u001b[34m";
    public static final String TTY_FG_Magenta = "\u001b[35m";
    public static final String TTY_FG_Cyan = "\u001b[36m";
    public static final String TTY_FG_White = "\u001b[37m";
    public static final String TTY_BG_Black = "\u001b[40m";
    public static final String TTY_BG_Red = "\u001b[41m";
    public static final String TTY_BG_Green = "\u001b[42m";
    public static final String TTY_BG_Yellow = "\u001b[43m";
    public static final String TTY_BG_Blue = "\u001b[44m";
    public static final String TTY_BG_Magenta = "\u001b[45m";
    public static final String TTY_BG_Cyan = "\u001b[46m";
    public static final String TTY_BG_White = "\u001b[47m";

    public CommandShell(String serverName) {
        serverName = serverName.toLowerCase();
        this.prompt = "\u001b[0m\u001b[1m[" + serverName + "]$ " + TTY_Reset;
    }

    public int main(String[] args, InputStream input, PrintStream out) {
        DataInputStream in = new DataInputStream(input);
        while (!this.stop) {
            this.prompt(in, out);
        }
        return this.rc;
    }

    protected void prompt(DataInputStream in, PrintStream out) {
        try {
            out.print(this.prompt);
            out.flush();
            String commandline = in.readLine();
            if (commandline == null) {
                this.stop = true;
                return;
            }
            if ((commandline = commandline.trim()).length() < 1) {
                return;
            }
            String command = commandline;
            StringTokenizer cmdstr = new StringTokenizer(command);
            command = cmdstr.nextToken();
            Vector<String> p = new Vector<String>();
            while (cmdstr.hasMoreTokens()) {
                p.add(cmdstr.nextToken());
            }
            Object[] args = new String[p.size()];
            p.copyInto(args);
            Command cmd = CommandRegistry.getCommand(command);
            if (cmd == null) {
                out.print(command);
                out.println(": command not found");
            } else {
                cmd.main((String[])args, in, out);
            }
        }
        catch (UnsupportedOperationException e) {
            this.rc = -1;
            this.stop = true;
        }
        catch (Throwable e) {
            e.printStackTrace(out);
            this.rc = -1;
            this.stop = true;
        }
    }

    protected void badCommand(DataInputStream in, PrintStream out) throws IOException {
    }
}

