/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.command;

import groovy.lang.GroovyShell;
import groovy.lang.GroovySystem;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import org.apache.xbean.command.Command;
import org.apache.xbean.command.CommandRegistry;
import org.codehaus.groovy.runtime.InvokerHelper;

public class GroovySh
implements Command {
    public static void register() {
        CommandRegistry.register("groovysh", GroovySh.class);
    }

    public int main(String[] args, InputStream in, PrintStream out) {
        GroovyShell shell = new GroovyShell();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        String version = GroovySystem.getVersion();
        out.println("Lets get Groovy!");
        out.println("================");
        out.println("Version: " + version + " JVM: " + System.getProperty("java.vm.version"));
        out.println("Hit carriage return twice to execute a command");
        out.println("The command 'quit' will terminate the shell");
        int counter = 1;
        while (true) {
            String line;
            StringBuffer buffer = new StringBuffer();
            do {
                out.print("groovy> ");
                try {
                    line = reader.readLine();
                }
                catch (IOException e) {
                    out.println("Caught: " + e);
                    e.printStackTrace();
                    return -1;
                }
                if (line == null) continue;
                buffer.append(line);
                buffer.append('\n');
            } while (line != null && line.trim().length() != 0);
            String command = buffer.toString().trim();
            if (command == null || command.equals("quit")) break;
            try {
                Object answer = shell.evaluate(command, "CommandLine" + counter++ + ".groovy");
                out.println(InvokerHelper.inspect((Object)answer));
            }
            catch (Exception e) {
                out.println("Caught: " + e);
                e.printStackTrace();
            }
        }
        return 0;
    }
}

