/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.spring.generator;

import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.BeanProperty;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.JavaSource;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xbean.spring.generator.AttributeMapping;
import org.apache.xbean.spring.generator.ElementMapping;
import org.apache.xbean.spring.generator.InvalidModelException;
import org.apache.xbean.spring.generator.MapMapping;
import org.apache.xbean.spring.generator.MappingLoader;
import org.apache.xbean.spring.generator.NamespaceMapping;
import org.apache.xbean.spring.generator.Type;
import org.apache.xbean.spring.generator.Utils;

public class QdoxMappingLoader
implements MappingLoader {
    public static final String XBEAN_ANNOTATION = "org.apache.xbean.XBean";
    public static final String PROPERTY_ANNOTATION = "org.apache.xbean.Property";
    public static final String INIT_METHOD_ANNOTATION = "org.apache.xbean.InitMethod";
    public static final String DESTROY_METHOD_ANNOTATION = "org.apache.xbean.DestroyMethod";
    public static final String FACTORY_METHOD_ANNOTATION = "org.apache.xbean.FactoryMethod";
    public static final String MAP_ANNOTATION = "org.apache.xbean.Map";
    public static final String FLAT_PROPERTY_ANNOTATION = "org.apache.xbean.Flat";
    public static final String FLAT_COLLECTION_ANNOTATION = "org.apache.xbean.FlatCollection";
    public static final String ELEMENT_ANNOTATION = "org.apache.xbean.Element";
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$xbean$spring$generator$QdoxMappingLoader == null ? (class$org$apache$xbean$spring$generator$QdoxMappingLoader = QdoxMappingLoader.class$("org.apache.xbean.spring.generator.QdoxMappingLoader")) : class$org$apache$xbean$spring$generator$QdoxMappingLoader));
    private final String defaultNamespace;
    private final File[] srcDirs;
    private com.thoughtworks.qdox.model.Type listType;
    static /* synthetic */ Class class$org$apache$xbean$spring$generator$QdoxMappingLoader;

    public QdoxMappingLoader(String defaultNamespace, File[] srcDirs) {
        this.defaultNamespace = defaultNamespace;
        this.srcDirs = srcDirs;
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public File[] getSrcDirs() {
        return this.srcDirs;
    }

    public Set loadNamespaces() throws IOException {
        JavaDocBuilder builder = new JavaDocBuilder();
        log.debug((Object)"Source directories: ");
        for (int it = 0; it < this.srcDirs.length; ++it) {
            File sourceDirectory = this.srcDirs[it];
            if (!sourceDirectory.isDirectory()) {
                log.warn((Object)("Specified source directory isn't a directory: '" + sourceDirectory.getAbsolutePath() + "'."));
            }
            log.debug((Object)(" - " + sourceDirectory.getAbsolutePath()));
            builder.addSourceTree(sourceDirectory);
        }
        this.listType = builder.getClassByName("java.util.List").asType();
        Set namespaces = this.loadNamespaces(builder);
        return namespaces;
    }

    private Set loadNamespaces(JavaDocBuilder builder) {
        List elements = this.loadElements(builder);
        HashMap<String, HashSet<ElementMapping>> elementsByNamespace = new HashMap<String, HashSet<ElementMapping>>();
        HashMap<String, ElementMapping> namespaceRoots = new HashMap<String, ElementMapping>();
        Iterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            ElementMapping element = (ElementMapping)iterator.next();
            String namespace = element.getNamespace();
            HashSet<ElementMapping> namespaceElements = (HashSet<ElementMapping>)elementsByNamespace.get(namespace);
            if (namespaceElements == null) {
                namespaceElements = new HashSet<ElementMapping>();
                elementsByNamespace.put(namespace, namespaceElements);
            }
            namespaceElements.add(element);
            if (!element.isRootElement()) continue;
            if (namespaceRoots.containsKey(namespace)) {
                log.warn((Object)("Multiple root elements found for namespace " + namespace));
            }
            namespaceRoots.put(namespace, element);
        }
        TreeSet<NamespaceMapping> namespaces = new TreeSet<NamespaceMapping>();
        Iterator iterator2 = elementsByNamespace.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = iterator2.next();
            String namespace = (String)entry.getKey();
            Set namespaceElements = (Set)entry.getValue();
            ElementMapping rootElement = (ElementMapping)namespaceRoots.get(namespace);
            NamespaceMapping namespaceMapping = new NamespaceMapping(namespace, namespaceElements, rootElement);
            namespaces.add(namespaceMapping);
        }
        return Collections.unmodifiableSet(namespaces);
    }

    private List loadElements(JavaDocBuilder builder) {
        JavaSource[] javaSources = builder.getSources();
        ArrayList<ElementMapping> elements = new ArrayList<ElementMapping>();
        for (int i = 0; i < javaSources.length; ++i) {
            JavaClass javaClass = javaSources[i].getClasses()[0];
            ElementMapping element = this.loadElement(javaClass);
            if (element != null && !javaClass.isAbstract()) {
                elements.add(element);
                continue;
            }
            log.debug((Object)("No XML annotation found for type: " + javaClass.getFullyQualifiedName()));
        }
        return elements;
    }

    private ElementMapping loadElement(JavaClass javaClass) {
        JavaMethod method;
        JavaMethod[] methods;
        DocletTag xbeanTag = javaClass.getTagByName(XBEAN_ANNOTATION);
        if (xbeanTag == null) {
            return null;
        }
        String element = this.getElementName(javaClass, xbeanTag);
        String description = QdoxMappingLoader.getProperty(xbeanTag, "description");
        if (description == null) {
            description = javaClass.getComment();
        }
        String namespace = QdoxMappingLoader.getProperty(xbeanTag, "namespace", this.defaultNamespace);
        boolean root = this.getBooleanProperty(xbeanTag, "rootElement");
        String contentProperty = QdoxMappingLoader.getProperty(xbeanTag, "contentProperty");
        HashMap<String, MapMapping> mapsByPropertyName = new HashMap<String, MapMapping>();
        ArrayList<String> flatProperties = new ArrayList<String>();
        HashMap<String, String> flatCollections = new HashMap<String, String>();
        HashSet<AttributeMapping> attributes = new HashSet<AttributeMapping>();
        HashMap<String, AttributeMapping> attributesByPropertyName = new HashMap<String, AttributeMapping>();
        for (JavaClass jClass = javaClass; jClass != null; jClass = jClass.getSuperJavaClass()) {
            BeanProperty[] beanProperties = jClass.getBeanProperties();
            for (int i = 0; i < beanProperties.length; ++i) {
                DocletTag flatPropTag;
                DocletTag flatColTag;
                JavaMethod acc;
                BeanProperty beanProperty = beanProperties[i];
                if (beanProperty.getMutator() == null) continue;
                AttributeMapping attributeMapping = this.loadAttribute(beanProperty, "");
                if (attributeMapping != null) {
                    attributes.add(attributeMapping);
                    attributesByPropertyName.put(attributeMapping.getPropertyName(), attributeMapping);
                }
                if ((acc = beanProperty.getAccessor()) == null) continue;
                DocletTag mapTag = acc.getTagByName(MAP_ANNOTATION);
                if (mapTag != null) {
                    MapMapping mm = new MapMapping(mapTag.getNamedParameter("entryName"), mapTag.getNamedParameter("keyName"));
                    mapsByPropertyName.put(beanProperty.getName(), mm);
                }
                if ((flatColTag = acc.getTagByName(FLAT_COLLECTION_ANNOTATION)) != null) {
                    String childName = flatColTag.getNamedParameter("childElement");
                    if (childName == null) {
                        throw new InvalidModelException("Flat collections must specify the childElement attribute.");
                    }
                    flatCollections.put(beanProperty.getName(), childName);
                }
                if ((flatPropTag = acc.getTagByName(FLAT_PROPERTY_ANNOTATION)) == null) continue;
                flatProperties.add(beanProperty.getName());
            }
        }
        String initMethod = null;
        String destroyMethod = null;
        String factoryMethod = null;
        for (JavaClass jClass = javaClass; jClass != null; jClass = jClass.getSuperJavaClass()) {
            methods = javaClass.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                method = methods[i];
                if (!method.isPublic() || method.isConstructor()) continue;
                if (initMethod == null && method.getTagByName(INIT_METHOD_ANNOTATION) != null) {
                    initMethod = method.getName();
                }
                if (destroyMethod == null && method.getTagByName(DESTROY_METHOD_ANNOTATION) != null) {
                    destroyMethod = method.getName();
                }
                if (factoryMethod != null || method.getTagByName(FACTORY_METHOD_ANNOTATION) == null) continue;
                factoryMethod = method.getName();
            }
        }
        ArrayList constructorArgs = new ArrayList();
        methods = javaClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            method = methods[i];
            JavaParameter[] parameters = method.getParameters();
            if (!this.isValidConstructor(factoryMethod, method, parameters)) continue;
            ArrayList<AttributeMapping> args = new ArrayList<AttributeMapping>(parameters.length);
            for (int j = 0; j < parameters.length; ++j) {
                JavaParameter parameter = parameters[j];
                String parameterType = parameter.getType().toString();
                AttributeMapping attributeMapping = (AttributeMapping)attributesByPropertyName.get(parameter.getName());
                if (attributeMapping == null) {
                    attributeMapping = this.loadParameter(parameter);
                    attributes.add(attributeMapping);
                    attributesByPropertyName.put(attributeMapping.getPropertyName(), attributeMapping);
                }
                if (!parameterType.equals(attributeMapping.getType().getName())) {
                    throw new InvalidModelException("Type mismatch: The construction method " + QdoxMappingLoader.toMethodLocator(parameter.getParentMethod()) + " declared parameter " + parameter.getName() + " as a " + parameterType + " but the bean property type is " + attributeMapping.getType().getName());
                }
                args.add(attributeMapping);
            }
            constructorArgs.add(Collections.unmodifiableList(args));
        }
        return new ElementMapping(namespace, element, javaClass.getFullyQualifiedName(), description, root, initMethod, destroyMethod, factoryMethod, contentProperty, attributes, constructorArgs, flatProperties, mapsByPropertyName, flatCollections);
    }

    private String getElementName(JavaClass javaClass, DocletTag tag) {
        String elementName = QdoxMappingLoader.getProperty(tag, "element");
        if (elementName == null) {
            String className = javaClass.getFullyQualifiedName();
            int index = className.lastIndexOf(".");
            if (index > 0) {
                className = className.substring(index + 1);
            }
            if (className.endsWith("FactoryBean")) {
                className = className.substring(0, className.length() - 4);
            }
            elementName = Utils.decapitalise(className);
        }
        return elementName;
    }

    private AttributeMapping loadAttribute(BeanProperty beanProperty, String defaultDescription) {
        DocletTag propertyTag = QdoxMappingLoader.getPropertyTag(beanProperty);
        if (this.getBooleanProperty(propertyTag, "hidden")) {
            return null;
        }
        String attribute = QdoxMappingLoader.getProperty(propertyTag, "alias", beanProperty.getName());
        String attributeDescription = this.getAttributeDescription(beanProperty, propertyTag, defaultDescription);
        String defaultValue = QdoxMappingLoader.getProperty(propertyTag, "default");
        boolean fixed = this.getBooleanProperty(propertyTag, "fixed");
        boolean required = this.getBooleanProperty(propertyTag, "required");
        String nestedType = QdoxMappingLoader.getProperty(propertyTag, "nestedType");
        return new AttributeMapping(attribute, beanProperty.getName(), attributeDescription, this.toMappingType(beanProperty.getType(), nestedType), defaultValue, fixed, required);
    }

    private static DocletTag getPropertyTag(BeanProperty beanProperty) {
        DocletTag propertyTag;
        DocletTag propertyTag2;
        JavaMethod accessor = beanProperty.getAccessor();
        if (accessor != null && (propertyTag2 = accessor.getTagByName(PROPERTY_ANNOTATION)) != null) {
            return propertyTag2;
        }
        JavaMethod mutator = beanProperty.getMutator();
        if (mutator != null && (propertyTag = mutator.getTagByName(PROPERTY_ANNOTATION)) != null) {
            return propertyTag;
        }
        return null;
    }

    private String getAttributeDescription(BeanProperty beanProperty, DocletTag propertyTag, String defaultDescription) {
        String description = QdoxMappingLoader.getProperty(propertyTag, "description");
        if (description != null && description.trim().length() > 0) {
            return description.trim();
        }
        JavaMethod accessor = beanProperty.getAccessor();
        if (accessor != null && (description = accessor.getComment()) != null && description.trim().length() > 0) {
            return description.trim();
        }
        JavaMethod mutator = beanProperty.getMutator();
        if (mutator != null && (description = mutator.getComment()) != null && description.trim().length() > 0) {
            return description.trim();
        }
        return defaultDescription;
    }

    private AttributeMapping loadParameter(JavaParameter parameter) {
        String parameterName = parameter.getName();
        String parameterDescription = this.getParameterDescription(parameter);
        JavaClass javaClass = parameter.getParentMethod().getParentClass();
        BeanProperty beanProperty = javaClass.getBeanProperty(parameterName);
        if (beanProperty != null) {
            AttributeMapping attributeMapping = this.loadAttribute(beanProperty, parameterDescription);
            if (attributeMapping == null) {
                throw new InvalidModelException("Hidden property usage: The construction method " + QdoxMappingLoader.toMethodLocator(parameter.getParentMethod()) + " can not use a hidded property " + parameterName);
            }
            return attributeMapping;
        }
        return new AttributeMapping(parameterName, parameterName, parameterDescription, this.toMappingType(parameter.getType(), null), null, false, false);
    }

    private String getParameterDescription(JavaParameter parameter) {
        String parameterName = parameter.getName();
        DocletTag[] tags = parameter.getParentMethod().getTagsByName("param");
        for (int k = 0; k < tags.length; ++k) {
            DocletTag tag = tags[k];
            if (!tag.getParameters()[0].equals(parameterName)) continue;
            String parameterDescription = tag.getValue().trim();
            if (parameterDescription.startsWith(parameterName)) {
                parameterDescription = parameterDescription.substring(parameterName.length()).trim();
            }
            return parameterDescription;
        }
        return null;
    }

    private boolean isValidConstructor(String factoryMethod, JavaMethod method, JavaParameter[] parameters) {
        if (!method.isPublic() || parameters.length == 0) {
            return false;
        }
        if (factoryMethod == null) {
            return method.isConstructor();
        }
        return method.getName().equals(factoryMethod);
    }

    private static String getProperty(DocletTag propertyTag, String propertyName) {
        return QdoxMappingLoader.getProperty(propertyTag, propertyName, null);
    }

    private static String getProperty(DocletTag propertyTag, String propertyName, String defaultValue) {
        String value = null;
        if (propertyTag != null) {
            value = propertyTag.getNamedParameter(propertyName);
        }
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    private boolean getBooleanProperty(DocletTag propertyTag, String propertyName) {
        return QdoxMappingLoader.toBoolean(QdoxMappingLoader.getProperty(propertyTag, propertyName));
    }

    private static boolean toBoolean(String value) {
        if (value != null) {
            return new Boolean(value);
        }
        return false;
    }

    private Type toMappingType(com.thoughtworks.qdox.model.Type type, String nestedType) {
        if (type.isArray()) {
            return Type.newArrayType(type.getValue(), type.getDimensions());
        }
        if (type.isA(this.listType)) {
            if (nestedType == null) {
                nestedType = "java.lang.Object";
            }
            return Type.newCollectionType(type.getValue(), Type.newSimpleType(nestedType));
        }
        return Type.newSimpleType(type.getValue());
    }

    private static String toMethodLocator(JavaMethod method) {
        StringBuffer buf = new StringBuffer();
        buf.append(method.getParentClass().getFullyQualifiedName());
        if (!method.isConstructor()) {
            buf.append(".").append(method.getName());
        }
        buf.append("(");
        JavaParameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            JavaParameter parameter = parameters[i];
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(parameter.getName());
        }
        buf.append(") : ").append(method.getLineNumber());
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

