/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.spring.generator;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.xbean.spring.context.impl.NamespaceHelper;
import org.apache.xbean.spring.generator.AttributeMapping;
import org.apache.xbean.spring.generator.ElementMapping;
import org.apache.xbean.spring.generator.GeneratorPlugin;
import org.apache.xbean.spring.generator.LogFacade;
import org.apache.xbean.spring.generator.MapMapping;
import org.apache.xbean.spring.generator.NamespaceMapping;

public class XmlMetadataGenerator
implements GeneratorPlugin {
    private final String metaInfDir;
    private final LogFacade log;
    public static final String NAMESPACE_HANDLER = "org.apache.xbean.spring.context.v2.XBeanNamespaceHandler";
    static /* synthetic */ Class class$java$util$List;

    public XmlMetadataGenerator(LogFacade log, String metaInfDir) {
        this.metaInfDir = metaInfDir;
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(NamespaceMapping namespaceMapping) throws IOException {
        String namespace = namespaceMapping.getNamespace();
        if (namespace == null) {
            return;
        }
        File file = new File(this.metaInfDir, NamespaceHelper.createDiscoveryPathName(namespace));
        file.getParentFile().mkdirs();
        this.log.log("Generating META-INF properties file: " + file + " for namespace: " + namespace);
        PrintWriter out = new PrintWriter(new FileWriter(file));
        try {
            this.generatePropertiesFile(out, namespaceMapping.getElements());
        }
        finally {
            out.close();
        }
        file = new File(this.metaInfDir, "META-INF/spring.handlers");
        this.log.log("Generating Spring 2.0 handler mapping: " + file + " for namespace: " + namespace);
        out = new PrintWriter(new FileWriter(file));
        try {
            out.println(namespace.replaceAll(":", "\\\\:") + "=" + NAMESPACE_HANDLER);
        }
        finally {
            out.close();
        }
    }

    private void generatePropertiesFile(PrintWriter out, Set elements) {
        out.println("# NOTE: this file is autogenerated by XBeans");
        out.println();
        out.println("# beans");
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            ElementMapping element = (ElementMapping)iter.next();
            out.println(element.getElementName() + " = " + element.getClassName());
            this.generatePropertiesFileContent(out, element);
            this.generatePropertiesFilePropertyAliases(out, element);
            this.generatePropertiesFileConstructors(out, element);
            out.println();
        }
    }

    private void generatePropertiesFileContent(PrintWriter out, ElementMapping element) {
        String factoryMethod;
        String destroyMethod;
        String initMethod;
        String contentProperty = element.getContentProperty();
        if (contentProperty != null) {
            out.println(element.getElementName() + ".contentProperty = " + contentProperty);
        }
        if ((initMethod = element.getInitMethod()) != null) {
            out.println(element.getElementName() + ".initMethod = " + initMethod);
        }
        if ((destroyMethod = element.getDestroyMethod()) != null) {
            out.println(element.getElementName() + ".destroyMethod = " + destroyMethod);
        }
        if ((factoryMethod = element.getFactoryMethod()) != null) {
            out.println(element.getElementName() + ".factoryMethod = " + factoryMethod);
        }
        List flatProperties = element.getFlatProperties();
        Iterator itr = flatProperties.iterator();
        while (itr.hasNext()) {
            out.println(element.getElementName() + "." + itr.next() + ".flat");
        }
        Map maps = element.getMapMappings();
        Iterator itr2 = maps.entrySet().iterator();
        while (itr2.hasNext()) {
            Map.Entry entry = itr2.next();
            MapMapping mm = (MapMapping)entry.getValue();
            out.println(element.getElementName() + "." + entry.getKey() + ".map.entryName = " + mm.getEntryName());
            out.println(element.getElementName() + "." + entry.getKey() + ".map.keyName = " + mm.getKeyName());
        }
        Map flatCollections = element.getFlatCollections();
        Iterator itr3 = flatCollections.entrySet().iterator();
        while (itr3.hasNext()) {
            Map.Entry entry = itr3.next();
            String child = (String)entry.getValue();
            out.println(element.getElementName() + "." + child + ".flatCollection = " + entry.getKey());
        }
    }

    private void generatePropertiesFileConstructors(PrintWriter out, ElementMapping element) {
        List constructors = element.getConstructors();
        Iterator iterator = constructors.iterator();
        while (iterator.hasNext()) {
            List args = (List)iterator.next();
            this.generatePropertiesFileConstructor(out, element, args);
        }
    }

    private void generatePropertiesFileConstructor(PrintWriter out, ElementMapping element, List args) {
        AttributeMapping attributeMapping;
        out.print(element.getClassName());
        if (element.getFactoryMethod() != null) {
            out.print("." + element.getFactoryMethod());
        }
        out.print("(");
        Iterator iterator = args.iterator();
        while (iterator.hasNext()) {
            attributeMapping = (AttributeMapping)iterator.next();
            out.print(attributeMapping.getType().getName());
            if (!iterator.hasNext()) continue;
            out.print(",");
        }
        out.print(").parameterNames =");
        iterator = args.iterator();
        while (iterator.hasNext()) {
            attributeMapping = (AttributeMapping)iterator.next();
            out.print(" ");
            out.print(attributeMapping.getPropertyName());
        }
        out.println();
    }

    private void generatePropertiesFilePropertyAliases(PrintWriter out, ElementMapping element) {
        Iterator iterator = element.getAttributes().iterator();
        while (iterator.hasNext()) {
            String attributeName;
            AttributeMapping attributeMapping = (AttributeMapping)iterator.next();
            String propertyName = attributeMapping.getPropertyName();
            if (propertyName.equals(attributeName = attributeMapping.getAttributeName())) continue;
            if ((class$java$util$List == null ? XmlMetadataGenerator.class$("java.util.List") : class$java$util$List).getName().equals(attributeMapping.getType().getName())) {
                out.println(element.getElementName() + ".list." + attributeName + " = " + propertyName);
                continue;
            }
            out.println(element.getElementName() + ".alias." + attributeName + " = " + propertyName);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

