/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.propertyeditor;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.xbean.propertyeditor.ArrayConverter;
import org.apache.xbean.propertyeditor.ArrayListEditor;
import org.apache.xbean.propertyeditor.BigDecimalEditor;
import org.apache.xbean.propertyeditor.BigIntegerEditor;
import org.apache.xbean.propertyeditor.BooleanEditor;
import org.apache.xbean.propertyeditor.ByteEditor;
import org.apache.xbean.propertyeditor.CharacterEditor;
import org.apache.xbean.propertyeditor.ClassEditor;
import org.apache.xbean.propertyeditor.CommonsLoggingConverter;
import org.apache.xbean.propertyeditor.Converter;
import org.apache.xbean.propertyeditor.DateEditor;
import org.apache.xbean.propertyeditor.DoubleEditor;
import org.apache.xbean.propertyeditor.EnumConverter;
import org.apache.xbean.propertyeditor.FileEditor;
import org.apache.xbean.propertyeditor.FloatEditor;
import org.apache.xbean.propertyeditor.GenericCollectionConverter;
import org.apache.xbean.propertyeditor.GenericMapConverter;
import org.apache.xbean.propertyeditor.HashMapEditor;
import org.apache.xbean.propertyeditor.HashtableEditor;
import org.apache.xbean.propertyeditor.IdentityHashMapEditor;
import org.apache.xbean.propertyeditor.Inet4AddressEditor;
import org.apache.xbean.propertyeditor.Inet6AddressEditor;
import org.apache.xbean.propertyeditor.InetAddressEditor;
import org.apache.xbean.propertyeditor.IntegerEditor;
import org.apache.xbean.propertyeditor.JndiConverter;
import org.apache.xbean.propertyeditor.LinkedHashMapEditor;
import org.apache.xbean.propertyeditor.LinkedHashSetEditor;
import org.apache.xbean.propertyeditor.LinkedListEditor;
import org.apache.xbean.propertyeditor.ListEditor;
import org.apache.xbean.propertyeditor.Log4jConverter;
import org.apache.xbean.propertyeditor.LoggerConverter;
import org.apache.xbean.propertyeditor.LongEditor;
import org.apache.xbean.propertyeditor.MapEditor;
import org.apache.xbean.propertyeditor.ObjectNameEditor;
import org.apache.xbean.propertyeditor.PatternConverter;
import org.apache.xbean.propertyeditor.PropertiesEditor;
import org.apache.xbean.propertyeditor.PropertyEditorException;
import org.apache.xbean.propertyeditor.ReferenceIdentityMap;
import org.apache.xbean.propertyeditor.SetEditor;
import org.apache.xbean.propertyeditor.ShortEditor;
import org.apache.xbean.propertyeditor.SortedMapEditor;
import org.apache.xbean.propertyeditor.SortedSetEditor;
import org.apache.xbean.propertyeditor.StringEditor;
import org.apache.xbean.propertyeditor.TreeMapEditor;
import org.apache.xbean.propertyeditor.TreeSetEditor;
import org.apache.xbean.propertyeditor.URIEditor;
import org.apache.xbean.propertyeditor.URLEditor;
import org.apache.xbean.propertyeditor.VectorEditor;
import org.apache.xbean.propertyeditor.WeakHashMapEditor;
import org.apache.xbean.recipe.RecipeHelper;

public class PropertyEditors {
    private static final Map<Class, Converter> registry = Collections.synchronizedMap(new ReferenceIdentityMap());
    private static final Map<Class, Class> PRIMITIVE_TO_WRAPPER;
    private static final Map<Class, Class> WRAPPER_TO_PRIMITIVE;
    private static boolean registerWithVM;

    public static boolean isRegisterWithVM() {
        return registerWithVM;
    }

    public static void setRegisterWithVM(boolean registerWithVM) {
        if (PropertyEditors.registerWithVM != registerWithVM) {
            PropertyEditors.registerWithVM = registerWithVM;
            if (registerWithVM) {
                for (Map.Entry<Class, Converter> entry : registry.entrySet()) {
                    Class type = entry.getKey();
                    Converter converter = entry.getValue();
                    PropertyEditorManager.registerEditor(type, converter.getClass());
                }
            }
        }
    }

    public static void registerConverter(Converter converter) {
        if (converter == null) {
            throw new NullPointerException("editor is null");
        }
        Class type = converter.getType();
        registry.put(type, converter);
        if (registerWithVM) {
            PropertyEditorManager.registerEditor(type, converter.getClass());
        }
        if (PRIMITIVE_TO_WRAPPER.containsKey(type)) {
            Class wrapperType = PRIMITIVE_TO_WRAPPER.get(type);
            registry.put(wrapperType, converter);
            if (registerWithVM) {
                PropertyEditorManager.registerEditor(wrapperType, converter.getClass());
            }
        } else if (WRAPPER_TO_PRIMITIVE.containsKey(type)) {
            Class primitiveType = WRAPPER_TO_PRIMITIVE.get(type);
            registry.put(primitiveType, converter);
            if (registerWithVM) {
                PropertyEditorManager.registerEditor(primitiveType, converter.getClass());
            }
        }
    }

    public static boolean canConvert(String type, ClassLoader classLoader) {
        Class<?> typeClass;
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        if (classLoader == null) {
            throw new NullPointerException("classLoader is null");
        }
        try {
            typeClass = Class.forName(type, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new PropertyEditorException("Type class could not be found: " + type);
        }
        return PropertyEditors.canConvert(typeClass);
    }

    public static boolean canConvert(Class type) {
        PropertyEditor editor = PropertyEditors.findConverterOrEditor(type);
        return editor != null;
    }

    private static PropertyEditor findConverterOrEditor(Type type) {
        Converter converter = PropertyEditors.findConverter(type);
        if (converter != null) {
            return converter;
        }
        PropertyEditor editor = PropertyEditors.findEditor(type);
        if (editor != null) {
            return editor;
        }
        converter = PropertyEditors.findBuiltinConverter(type);
        if (converter != null) {
            return converter;
        }
        return null;
    }

    public static String toString(Object value) throws PropertyEditorException {
        String textValue;
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        Class<?> type = value.getClass();
        PropertyEditor editor = PropertyEditors.findConverterOrEditor(type);
        if (editor instanceof Converter) {
            Converter converter = (Converter)editor;
            return converter.toString(value);
        }
        if (editor == null) {
            throw new PropertyEditorException("Unable to find PropertyEditor for " + type.getSimpleName());
        }
        editor.setValue(value);
        try {
            textValue = editor.getAsText();
        }
        catch (Exception e) {
            throw new PropertyEditorException("Error while converting a \"" + type.getSimpleName() + "\" to text " + " using the property editor " + editor.getClass().getSimpleName(), e);
        }
        return textValue;
    }

    public static Object getValue(String type, String value, ClassLoader classLoader) throws PropertyEditorException {
        Class<?> typeClass;
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        if (classLoader == null) {
            throw new NullPointerException("classLoader is null");
        }
        try {
            typeClass = Class.forName(type, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new PropertyEditorException("Type class could not be found: " + type);
        }
        return PropertyEditors.getValue(typeClass, value);
    }

    public static Object getValue(Type type, String value) throws PropertyEditorException {
        Object objectValue;
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        PropertyEditor editor = PropertyEditors.findConverterOrEditor(type);
        if (editor instanceof Converter) {
            Converter converter = (Converter)editor;
            return converter.toObject(value);
        }
        Class clazz = RecipeHelper.toClass(type);
        if (editor == null) {
            throw new PropertyEditorException("Unable to find PropertyEditor for " + clazz.getSimpleName());
        }
        editor.setAsText(value);
        try {
            objectValue = editor.getValue();
        }
        catch (Exception e) {
            throw new PropertyEditorException("Error while converting \"" + value + "\" to a " + clazz.getSimpleName() + " using the property editor " + editor.getClass().getSimpleName(), e);
        }
        return objectValue;
    }

    private static Converter findBuiltinConverter(Type type) {
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        Class clazz = RecipeHelper.toClass(type);
        if (Enum.class.isAssignableFrom(clazz)) {
            return new EnumConverter(clazz);
        }
        return null;
    }

    private static Converter findConverter(Type type) {
        Class<?>[] declaredClasses;
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        Class clazz = RecipeHelper.toClass(type);
        if (clazz.isArray() && !clazz.getComponentType().isArray()) {
            PropertyEditor editor = PropertyEditors.findConverterOrEditor(clazz.getComponentType());
            if (editor != null) {
                return new ArrayConverter(clazz, editor);
            }
            return null;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            PropertyEditor editor;
            Type[] types = RecipeHelper.getTypeParameters(Collection.class, type);
            Object componentType = String.class;
            if (types != null && types.length == 1 && types[0] instanceof Class) {
                componentType = types[0];
            }
            if ((editor = PropertyEditors.findConverterOrEditor(componentType)) != null) {
                if (RecipeHelper.hasDefaultConstructor(clazz)) {
                    return new GenericCollectionConverter(clazz, editor);
                }
                if (SortedSet.class.isAssignableFrom(clazz)) {
                    return new GenericCollectionConverter(TreeSet.class, editor);
                }
                if (Set.class.isAssignableFrom(clazz)) {
                    return new GenericCollectionConverter(LinkedHashSet.class, editor);
                }
                return new GenericCollectionConverter(ArrayList.class, editor);
            }
            return null;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            Type[] types = RecipeHelper.getTypeParameters(Map.class, type);
            Object keyType = String.class;
            Object valueType = String.class;
            if (types != null && types.length == 2 && types[0] instanceof Class && types[1] instanceof Class) {
                keyType = types[0];
                valueType = types[1];
            }
            PropertyEditor keyConverter = PropertyEditors.findConverterOrEditor(keyType);
            PropertyEditor valueConverter = PropertyEditors.findConverterOrEditor(valueType);
            if (keyConverter != null && valueConverter != null) {
                if (RecipeHelper.hasDefaultConstructor(clazz)) {
                    return new GenericMapConverter(clazz, keyConverter, valueConverter);
                }
                if (SortedMap.class.isAssignableFrom(clazz)) {
                    return new GenericMapConverter(TreeMap.class, keyConverter, valueConverter);
                }
                if (ConcurrentMap.class.isAssignableFrom(clazz)) {
                    return new GenericMapConverter(ConcurrentHashMap.class, keyConverter, valueConverter);
                }
                return new GenericMapConverter(LinkedHashMap.class, keyConverter, valueConverter);
            }
            return null;
        }
        Converter converter = registry.get(clazz);
        if (converter != null) {
            return converter;
        }
        for (Class<?> declaredClass : declaredClasses = clazz.getDeclaredClasses()) {
            if (!Converter.class.isAssignableFrom(declaredClass)) continue;
            try {
                converter = (Converter)declaredClass.newInstance();
                PropertyEditors.registerConverter(converter);
                converter = registry.get(clazz);
                if (converter == null) continue;
                return converter;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static PropertyEditor findEditor(Type type) {
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        Class clazz = RecipeHelper.toClass(type);
        PropertyEditor editor = PropertyEditorManager.findEditor(clazz);
        if (editor != null) {
            return editor;
        }
        if (clazz.isArray() && !clazz.getComponentType().isArray() && (editor = PropertyEditors.findEditor(clazz.getComponentType())) != null) {
            return new ArrayConverter(clazz, editor);
        }
        return null;
    }

    static {
        HashMap<Class<Comparable<Boolean>>, Class<Comparable<Boolean>>> map = new HashMap<Class<Comparable<Boolean>>, Class<Comparable<Boolean>>>();
        map.put(Boolean.TYPE, Boolean.class);
        map.put(Character.TYPE, Character.class);
        map.put(Byte.TYPE, Byte.class);
        map.put(Short.TYPE, Short.class);
        map.put(Integer.TYPE, Integer.class);
        map.put(Long.TYPE, Long.class);
        map.put(Float.TYPE, Float.class);
        map.put(Double.TYPE, Double.class);
        PRIMITIVE_TO_WRAPPER = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put(Boolean.class, Boolean.TYPE);
        map.put(Character.class, Character.TYPE);
        map.put(Byte.class, Byte.TYPE);
        map.put(Short.class, Short.TYPE);
        map.put(Integer.class, Integer.TYPE);
        map.put(Long.class, Long.TYPE);
        map.put(Float.class, Float.TYPE);
        map.put(Double.class, Double.TYPE);
        WRAPPER_TO_PRIMITIVE = Collections.unmodifiableMap(map);
        PropertyEditors.registerConverter(new ArrayListEditor());
        PropertyEditors.registerConverter(new BigDecimalEditor());
        PropertyEditors.registerConverter(new BigIntegerEditor());
        PropertyEditors.registerConverter(new BooleanEditor());
        PropertyEditors.registerConverter(new ByteEditor());
        PropertyEditors.registerConverter(new CharacterEditor());
        PropertyEditors.registerConverter(new ClassEditor());
        PropertyEditors.registerConverter(new DateEditor());
        PropertyEditors.registerConverter(new DoubleEditor());
        PropertyEditors.registerConverter(new FileEditor());
        PropertyEditors.registerConverter(new FloatEditor());
        PropertyEditors.registerConverter(new HashMapEditor());
        PropertyEditors.registerConverter(new HashtableEditor());
        PropertyEditors.registerConverter(new IdentityHashMapEditor());
        PropertyEditors.registerConverter(new Inet4AddressEditor());
        PropertyEditors.registerConverter(new Inet6AddressEditor());
        PropertyEditors.registerConverter(new InetAddressEditor());
        PropertyEditors.registerConverter(new IntegerEditor());
        PropertyEditors.registerConverter(new LinkedHashMapEditor());
        PropertyEditors.registerConverter(new LinkedHashSetEditor());
        PropertyEditors.registerConverter(new LinkedListEditor());
        PropertyEditors.registerConverter(new ListEditor());
        PropertyEditors.registerConverter(new LongEditor());
        PropertyEditors.registerConverter(new MapEditor());
        PropertyEditors.registerConverter(new ObjectNameEditor());
        PropertyEditors.registerConverter(new PropertiesEditor());
        PropertyEditors.registerConverter(new SetEditor());
        PropertyEditors.registerConverter(new ShortEditor());
        PropertyEditors.registerConverter(new SortedMapEditor());
        PropertyEditors.registerConverter(new SortedSetEditor());
        PropertyEditors.registerConverter(new StringEditor());
        PropertyEditors.registerConverter(new TreeMapEditor());
        PropertyEditors.registerConverter(new TreeSetEditor());
        PropertyEditors.registerConverter(new URIEditor());
        PropertyEditors.registerConverter(new URLEditor());
        PropertyEditors.registerConverter(new LoggerConverter());
        PropertyEditors.registerConverter(new PatternConverter());
        PropertyEditors.registerConverter(new JndiConverter());
        PropertyEditors.registerConverter(new VectorEditor());
        PropertyEditors.registerConverter(new WeakHashMapEditor());
        try {
            PropertyEditors.registerConverter(new Log4jConverter());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            PropertyEditors.registerConverter(new CommonsLoggingConverter());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

