/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.recipe;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.xbean.propertyeditor.PropertyEditors;
import org.apache.xbean.recipe.AbstractRecipe;
import org.apache.xbean.recipe.ConstructionException;
import org.apache.xbean.recipe.MissingAccessorException;
import org.apache.xbean.recipe.MissingFactoryMethodException;
import org.apache.xbean.recipe.Option;
import org.apache.xbean.recipe.Recipe;
import org.apache.xbean.recipe.RecipeHelper;
import org.apache.xbean.recipe.SecretRecipe;
import org.apache.xbean.recipe.UnsetPropertiesRecipe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectRecipe
extends AbstractRecipe {
    private final String type;
    private final String factoryMethod;
    private final String[] constructorArgNames;
    private final Class[] constructorArgTypes;
    private final LinkedHashMap<Property, Object> properties;
    private final List<Option> options = new ArrayList<Option>();
    private final Map<String, Object> unsetProperties = new LinkedHashMap<String, Object>();

    public ObjectRecipe(Class type) {
        this(type.getName());
    }

    public ObjectRecipe(Class type, String factoryMethod) {
        this(type.getName(), factoryMethod);
    }

    public ObjectRecipe(Class type, Map<String, Object> properties) {
        this(type.getName(), properties);
    }

    public ObjectRecipe(Class type, String[] constructorArgNames, Class[] constructorArgTypes) {
        this(type.getName(), constructorArgNames, constructorArgTypes);
    }

    public ObjectRecipe(Class type, String factoryMethod, String[] constructorArgNames, Class[] constructorArgTypes) {
        this(type.getName(), factoryMethod, constructorArgNames, constructorArgTypes);
    }

    public ObjectRecipe(String typeName) {
        this(typeName, null, null, null, null);
    }

    public ObjectRecipe(String typeName, String factoryMethod) {
        this(typeName, factoryMethod, null, null, null);
    }

    public ObjectRecipe(String typeName, Map<String, Object> properties) {
        this(typeName, null, null, null, properties);
    }

    public ObjectRecipe(String typeName, String[] constructorArgNames, Class[] constructorArgTypes) {
        this(typeName, null, constructorArgNames, constructorArgTypes, null);
    }

    public ObjectRecipe(String typeName, String factoryMethod, String[] constructorArgNames, Class[] constructorArgTypes) {
        this(typeName, factoryMethod, constructorArgNames, constructorArgTypes, null);
    }

    public ObjectRecipe(String type, String factoryMethod, String[] constructorArgNames, Class[] constructorArgTypes, Map<String, Object> properties) {
        this.options.add(Option.FIELD_INJECTION);
        this.type = type;
        this.factoryMethod = factoryMethod;
        this.constructorArgNames = constructorArgNames != null ? constructorArgNames : new String[0];
        this.constructorArgTypes = constructorArgTypes != null ? constructorArgTypes : new Class[0];
        if (properties != null) {
            this.properties = new LinkedHashMap();
            this.setAllProperties(properties);
        } else {
            this.properties = new LinkedHashMap();
        }
    }

    public void allow(Option option) {
        this.options.add(option);
    }

    public void disallow(Option option) {
        this.options.remove(option);
    }

    public Object getProperty(String name) {
        Object value = this.properties.get(new Property(name));
        return value;
    }

    public void setProperty(String name, Object value) {
        this.setProperty(new Property(name), value);
    }

    public void setFieldProperty(String name, Object value) {
        this.setProperty(new FieldProperty(name), value);
        this.options.add(Option.FIELD_INJECTION);
    }

    public void setMethodProperty(String name, Object value) {
        this.setProperty(new SetterProperty(name), value);
    }

    private void setProperty(Property key, Object value) {
        if (value instanceof UnsetPropertiesRecipe) {
            this.allow(Option.IGNORE_MISSING_PROPERTIES);
        }
        this.properties.put(key, value);
    }

    public void setAllProperties(Map map) {
        if (map == null) {
            throw new NullPointerException("map is null");
        }
        for (Map.Entry entry : map.entrySet()) {
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            this.setProperty(name, value);
        }
    }

    public Map<String, Object> getUnsetProperties() {
        return this.unsetProperties;
    }

    @Override
    public boolean canCreate(Class type, ClassLoader classLoader) {
        Class myType = this.getType(classLoader);
        return type.isAssignableFrom(myType);
    }

    @Override
    public Object create(ClassLoader classLoader) throws ConstructionException {
        Object result;
        this.unsetProperties.clear();
        Class typeClass = this.getType(classLoader);
        if (!Modifier.isPublic(typeClass.getModifiers())) {
            throw new ConstructionException("Class is not public: " + typeClass.getName());
        }
        if (Modifier.isInterface(typeClass.getModifiers())) {
            throw new ConstructionException("Class is an interface: " + typeClass.getName());
        }
        if (Modifier.isAbstract(typeClass.getModifiers())) {
            throw new ConstructionException("Class is abstract: " + typeClass.getName());
        }
        LinkedHashMap<Property, Object> propertyValues = new LinkedHashMap<Property, Object>(this.properties);
        Method factoryMethod = null;
        if (this.factoryMethod != null) {
            factoryMethod = this.findFactoryMethod(typeClass, this.factoryMethod);
        }
        if (factoryMethod != null && Modifier.isStatic(factoryMethod.getModifiers())) {
            result = this.createInstance(factoryMethod, propertyValues, classLoader);
        } else {
            Constructor constructor = this.selectConstructor(typeClass);
            result = this.createInstance(constructor, propertyValues, classLoader);
        }
        Object instance = result;
        this.setProperties(propertyValues, instance, instance.getClass(), classLoader);
        if (factoryMethod != null && !Modifier.isStatic(factoryMethod.getModifiers())) {
            try {
                instance = factoryMethod.invoke(instance, new Object[0]);
            }
            catch (Exception e) {
                InvocationTargetException invocationTargetException;
                Throwable t = e;
                if (e instanceof InvocationTargetException && (invocationTargetException = (InvocationTargetException)e).getCause() != null) {
                    t = invocationTargetException.getCause();
                }
                throw new ConstructionException("Error calling factory method: " + factoryMethod, t);
            }
        }
        return instance;
    }

    public Class setStaticProperties(ClassLoader classLoader) throws ConstructionException {
        this.unsetProperties.clear();
        Class typeClass = this.getType(classLoader);
        if (!Modifier.isPublic(typeClass.getModifiers())) {
            throw new ConstructionException("Class is not public: " + typeClass.getName());
        }
        if (Modifier.isInterface(typeClass.getModifiers())) {
            throw new ConstructionException("Class is an interface: " + typeClass.getName());
        }
        if (Modifier.isAbstract(typeClass.getModifiers())) {
            throw new ConstructionException("Class is abstract: " + typeClass.getName());
        }
        LinkedHashMap<Property, Object> propertyValues = new LinkedHashMap<Property, Object>(this.properties);
        this.setProperties(propertyValues, null, typeClass, classLoader);
        return typeClass;
    }

    private void setProperties(Map<Property, Object> propertyValues, Object instance, Class clazz, ClassLoader classLoader) {
        boolean allowPrivate = this.options.contains(Option.PRIVATE_PROPERTIES);
        boolean allowStatic = this.options.contains(Option.STATIC_PROPERTIES);
        boolean ignoreMissingProperties = this.options.contains(Option.IGNORE_MISSING_PROPERTIES);
        boolean caseInsesnitive = this.options.contains(Option.CASE_INSENSITIVE_PROPERTIES);
        for (Map.Entry<Property, Object> entry : RecipeHelper.prioritizeProperties(propertyValues)) {
            Property propertyName = entry.getKey();
            Object propertyValue = entry.getValue();
            this.setProperty(instance, clazz, propertyName, propertyValue, allowPrivate, allowStatic, ignoreMissingProperties, caseInsesnitive, classLoader);
        }
    }

    private Class getType(ClassLoader classLoader) {
        Class<?> typeClass = null;
        try {
            typeClass = Class.forName(this.type, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new ConstructionException("Type class could not be found: " + this.type);
        }
        return typeClass;
    }

    private void setProperty(Object instance, Class clazz, Property propertyName, Object propertyValue, boolean allowPrivate, boolean allowStatic, boolean ignoreMissingProperties, boolean caseInsesnitive, ClassLoader classLoader) {
        Member member;
        block13: {
            try {
                if (propertyName instanceof SetterProperty) {
                    member = new MethodMember(ObjectRecipe.findSetter(clazz, propertyName.name, propertyValue, allowPrivate, allowStatic, caseInsesnitive, classLoader));
                    break block13;
                }
                if (propertyName instanceof FieldProperty) {
                    member = new FieldMember(ObjectRecipe.findField(clazz, propertyName.name, propertyValue, allowPrivate, allowStatic, caseInsesnitive, classLoader));
                    break block13;
                }
                try {
                    member = new MethodMember(ObjectRecipe.findSetter(clazz, propertyName.name, propertyValue, allowPrivate, allowStatic, caseInsesnitive, classLoader));
                }
                catch (MissingAccessorException noSetter) {
                    if (!this.options.contains(Option.FIELD_INJECTION)) {
                        throw noSetter;
                    }
                    try {
                        member = new FieldMember(ObjectRecipe.findField(clazz, propertyName.name, propertyValue, allowPrivate, allowStatic, caseInsesnitive, classLoader));
                    }
                    catch (MissingAccessorException noField) {
                        throw noField.getMatchLevel() > noSetter.getMatchLevel() ? noField : noSetter;
                    }
                }
            }
            catch (MissingAccessorException e) {
                if (ignoreMissingProperties) {
                    this.unsetProperties.put(propertyName.name, propertyValue);
                    return;
                }
                throw e;
            }
        }
        try {
            propertyValue = this.convert(member.getType(), propertyValue, classLoader);
            member.setValue(instance, propertyValue);
        }
        catch (Exception e) {
            InvocationTargetException invocationTargetException;
            Throwable t = e;
            if (e instanceof InvocationTargetException && (invocationTargetException = (InvocationTargetException)e).getCause() != null) {
                t = invocationTargetException.getCause();
            }
            throw new ConstructionException("Error setting property: " + member, t);
        }
    }

    private Object[] extractConstructorArgs(Map propertyValues, Class[] constructorArgTypes, ClassLoader classLoader) {
        Object[] parameters = new Object[this.constructorArgNames.length];
        for (int i = 0; i < this.constructorArgNames.length; ++i) {
            Object value;
            Property name = new Property(this.constructorArgNames[i]);
            Class type = constructorArgTypes[i];
            if (propertyValues.containsKey(name)) {
                value = propertyValues.remove(name);
                if (!RecipeHelper.isInstance(type, value) && !RecipeHelper.isConvertable(type, value, classLoader)) {
                    throw new ConstructionException("Invalid and non-convertable constructor parameter type: name=" + name + ", " + "index=" + i + ", " + "expected=" + type.getName() + ", " + "actual=" + ObjectRecipe.getClassName(value));
                }
                value = this.convert(type, value, classLoader);
            } else {
                value = ObjectRecipe.getDefaultValue(type);
            }
            parameters[i] = value;
        }
        return parameters;
    }

    private static String getClassName(Object value) {
        if (value == null) {
            return "null";
        }
        return value.getClass().getName();
    }

    private Object convert(Class type, Object value, ClassLoader classLoader) {
        if (value instanceof Recipe) {
            Recipe recipe;
            if (value instanceof SecretRecipe) {
                recipe = (SecretRecipe)value;
                value = recipe.create(this, classLoader);
            } else {
                recipe = (Recipe)value;
                value = recipe.create(classLoader);
            }
        }
        if (value instanceof String && type != Object.class) {
            String stringValue = (String)value;
            value = PropertyEditors.getValue(type, stringValue);
        }
        return value;
    }

    private static Object getDefaultValue(Class type) {
        if (type.equals(Boolean.TYPE)) {
            return Boolean.FALSE;
        }
        if (type.equals(Character.TYPE)) {
            return new Character('\u0000');
        }
        if (type.equals(Byte.TYPE)) {
            return new Byte(0);
        }
        if (type.equals(Short.TYPE)) {
            return new Short(0);
        }
        if (type.equals(Integer.TYPE)) {
            return new Integer(0);
        }
        if (type.equals(Long.TYPE)) {
            return new Long(0L);
        }
        if (type.equals(Float.TYPE)) {
            return new Float(0.0f);
        }
        if (type.equals(Double.TYPE)) {
            return new Double(0.0);
        }
        return null;
    }

    private Object createInstance(Constructor constructor, Map propertyValues, ClassLoader classLoader) {
        Object[] parameters = this.extractConstructorArgs(propertyValues, constructor.getParameterTypes(), classLoader);
        try {
            Object object = constructor.newInstance(parameters);
            return object;
        }
        catch (Exception e) {
            InvocationTargetException invocationTargetException;
            Throwable t = e;
            if (e instanceof InvocationTargetException && (invocationTargetException = (InvocationTargetException)e).getCause() != null) {
                t = invocationTargetException.getCause();
            }
            throw new ConstructionException("Error invoking constructor: " + constructor, t);
        }
    }

    private Object createInstance(Method method, Map propertyValues, ClassLoader classLoader) {
        Object[] parameters = this.extractConstructorArgs(propertyValues, method.getParameterTypes(), classLoader);
        try {
            Object object = method.invoke(null, parameters);
            return object;
        }
        catch (Exception e) {
            InvocationTargetException invocationTargetException;
            Throwable t = e;
            if (e instanceof InvocationTargetException && (invocationTargetException = (InvocationTargetException)e).getCause() != null) {
                t = invocationTargetException.getCause();
            }
            throw new ConstructionException("Error invoking factory method: " + method, t);
        }
    }

    private Constructor selectConstructor(Class typeClass) {
        if (this.constructorArgNames.length > 0 && this.constructorArgTypes.length == 0) {
            StringBuffer buffer;
            Constructor<?>[] constructors;
            ArrayList matches = new ArrayList();
            for (Constructor<?> constructor : constructors = typeClass.getConstructors()) {
                if (constructor.getParameterTypes().length != this.constructorArgNames.length) continue;
                matches.add(constructor);
            }
            if (matches.size() < 1) {
                buffer = new StringBuffer("No parameter types supplied; unable to find a potentially valid constructor: ");
                buffer.append("constructor= public ").append(typeClass.getName());
                buffer.append(this.toArgumentList(this.constructorArgNames));
                throw new ConstructionException(buffer.toString());
            }
            if (matches.size() > 1) {
                buffer = new StringBuffer("No parameter types supplied; found too many potentially valid constructors: ");
                buffer.append("constructor= public ").append(typeClass.getName());
                buffer.append(this.toArgumentList(this.constructorArgNames));
                throw new ConstructionException(buffer.toString());
            }
            return (Constructor)matches.get(0);
        }
        try {
            Constructor constructor = typeClass.getConstructor(this.constructorArgTypes);
            if (!Modifier.isPublic(constructor.getModifiers())) {
                throw new ConstructionException("Constructor is not public: " + constructor);
            }
            return constructor;
        }
        catch (NoSuchMethodException e) {
            Constructor<?>[] constructors;
            for (Constructor<?> constructor : constructors = typeClass.getDeclaredConstructors()) {
                if (!ObjectRecipe.isAssignableFrom(this.constructorArgTypes, constructor.getParameterTypes()) || Modifier.isPublic(constructor.getModifiers())) continue;
                throw new ConstructionException("Constructor is not public: " + constructor);
            }
            StringBuffer buffer = new StringBuffer("Unable to find a valid constructor: ");
            buffer.append("constructor= public ").append(typeClass.getName());
            buffer.append(this.toParameterList(this.constructorArgTypes));
            throw new ConstructionException(buffer.toString());
        }
    }

    private String toParameterList(Class[] parameterTypes) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("(");
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class type = parameterTypes[i];
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(type.getName());
        }
        buffer.append(")");
        return buffer.toString();
    }

    private String toArgumentList(String[] parameterNames) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("(");
        for (int i = 0; i < parameterNames.length; ++i) {
            String parameterName = parameterNames[i];
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append('<').append(parameterName).append('>');
        }
        buffer.append(")");
        return buffer.toString();
    }

    public Method findFactoryMethod(Class typeClass, String factoryMethod) {
        if (factoryMethod == null) {
            throw new NullPointerException("name is null");
        }
        if (factoryMethod.length() == 0) {
            throw new IllegalArgumentException("name is an empty string");
        }
        int matchLevel = 0;
        MissingFactoryMethodException missException = null;
        ArrayList<Method> methods = new ArrayList<Method>(Arrays.asList(typeClass.getMethods()));
        methods.addAll(Arrays.asList(typeClass.getDeclaredMethods()));
        for (Method method : methods) {
            if (!method.getName().equals(factoryMethod)) continue;
            if (Modifier.isStatic(method.getModifiers())) {
                if (method.getParameterTypes().length != this.constructorArgNames.length) {
                    if (matchLevel >= true) continue;
                    matchLevel = 1;
                    missException = new MissingFactoryMethodException("Static factory method has " + method.getParameterTypes().length + " arugments " + "but expected " + this.constructorArgNames.length + " arguments: " + method);
                    continue;
                }
                if (this.constructorArgTypes.length > 0 && !ObjectRecipe.isAssignableFrom(this.constructorArgTypes, method.getParameterTypes())) {
                    if (matchLevel >= 2) continue;
                    matchLevel = 2;
                    missException = new MissingFactoryMethodException("Static factory method has signature public static " + typeClass.getName() + "." + factoryMethod + this.toParameterList(method.getParameterTypes()) + " but expected signature " + "public static " + typeClass.getName() + "." + factoryMethod + this.toParameterList(this.constructorArgTypes));
                    continue;
                }
            } else if (method.getParameterTypes().length != 0) {
                if (matchLevel >= true) continue;
                matchLevel = 1;
                missException = new MissingFactoryMethodException("Instance factory method has parameters: " + method);
                continue;
            }
            if (method.getReturnType() == Void.TYPE) {
                if (matchLevel >= 3) continue;
                matchLevel = 3;
                missException = new MissingFactoryMethodException("Factory method does not return a value: " + method);
                continue;
            }
            if (Modifier.isAbstract(method.getModifiers())) {
                if (matchLevel >= 4) continue;
                matchLevel = 4;
                missException = new MissingFactoryMethodException("Factory method is abstract: " + method);
                continue;
            }
            if (!Modifier.isPublic(method.getModifiers())) {
                if (matchLevel >= 5) continue;
                matchLevel = 5;
                missException = new MissingFactoryMethodException("Factory method is not public: " + method);
                continue;
            }
            return method;
        }
        if (missException != null) {
            throw missException;
        }
        StringBuffer buffer = new StringBuffer("Unable to find a valid factory method: ");
        buffer.append("public void ").append(typeClass.getName()).append(".");
        buffer.append(factoryMethod).append("()");
        throw new MissingFactoryMethodException(buffer.toString());
    }

    public static Method findSetter(Class typeClass, String propertyName, Object propertyValue, boolean allowPrivate, ClassLoader classLoader) {
        return ObjectRecipe.findSetter(typeClass, propertyName, propertyValue, allowPrivate, false, false, classLoader);
    }

    public static Method findSetter(Class typeClass, String propertyName, Object propertyValue, boolean allowPrivate, boolean allowStatic, boolean caseInsesnitive, ClassLoader classLoader) {
        if (propertyName == null) {
            throw new NullPointerException("name is null");
        }
        if (propertyName.length() == 0) {
            throw new IllegalArgumentException("name is an empty string");
        }
        if (propertyName.contains("/")) {
            String[] strings = propertyName.split("/");
            if (strings == null || strings.length != 2) {
                throw new IllegalArgumentException("badly formed <class>/<attribute> property name: " + propertyName);
            }
            String className = strings[0];
            propertyName = strings[1];
            boolean found = false;
            while (!typeClass.equals(Object.class) && !found) {
                if (typeClass.getName().equals(className)) {
                    found = true;
                    break;
                }
                typeClass = typeClass.getSuperclass();
            }
            if (!found) {
                throw new MissingAccessorException("Type not assignable to class: " + className, -1);
            }
        }
        String setterName = "set" + Character.toUpperCase(propertyName.charAt(0));
        if (propertyName.length() > 0) {
            setterName = setterName + propertyName.substring(1);
        }
        int matchLevel = 0;
        MissingAccessorException missException = null;
        ArrayList<Method> methods = new ArrayList<Method>(Arrays.asList(typeClass.getMethods()));
        methods.addAll(Arrays.asList(typeClass.getDeclaredMethods()));
        for (Method method : methods) {
            if (!method.getName().equals(setterName) && (!caseInsesnitive || !method.getName().equalsIgnoreCase(setterName))) continue;
            if (method.getParameterTypes().length == 0) {
                if (matchLevel >= true) continue;
                matchLevel = 1;
                missException = new MissingAccessorException("Setter takes no parameters: " + method, matchLevel);
                continue;
            }
            if (method.getParameterTypes().length > 1) {
                if (matchLevel >= true) continue;
                matchLevel = 1;
                missException = new MissingAccessorException("Setter takes more then one parameter: " + method, matchLevel);
                continue;
            }
            if (method.getReturnType() != Void.TYPE) {
                if (matchLevel >= 2) continue;
                matchLevel = 2;
                missException = new MissingAccessorException("Setter returns a value: " + method, matchLevel);
                continue;
            }
            if (Modifier.isAbstract(method.getModifiers())) {
                if (matchLevel >= 3) continue;
                matchLevel = 3;
                missException = new MissingAccessorException("Setter is abstract: " + method, matchLevel);
                continue;
            }
            if (!allowPrivate && !Modifier.isPublic(method.getModifiers())) {
                if (matchLevel >= 4) continue;
                matchLevel = 4;
                missException = new MissingAccessorException("Setter is not public: " + method, matchLevel);
                continue;
            }
            if (!allowStatic && Modifier.isStatic(method.getModifiers())) {
                if (matchLevel >= 4) continue;
                matchLevel = 4;
                missException = new MissingAccessorException("Setter is static: " + method, matchLevel);
                continue;
            }
            Class<?> methodParameterType = method.getParameterTypes()[0];
            if (methodParameterType.isPrimitive() && propertyValue == null) {
                if (matchLevel >= 6) continue;
                matchLevel = 6;
                missException = new MissingAccessorException("Null can not be assigned to " + methodParameterType.getName() + ": " + method, matchLevel);
                continue;
            }
            if (!RecipeHelper.isInstance(methodParameterType, propertyValue) && !RecipeHelper.isConvertable(methodParameterType, propertyValue, classLoader)) {
                if (matchLevel >= 5) continue;
                matchLevel = 5;
                missException = new MissingAccessorException(ObjectRecipe.getClassName(propertyValue) + " can not be assigned or converted to " + methodParameterType.getName() + ": " + method, matchLevel);
                continue;
            }
            if (allowPrivate && !Modifier.isPublic(method.getModifiers())) {
                ObjectRecipe.setAccessible(method);
            }
            return method;
        }
        if (missException != null) {
            throw missException;
        }
        StringBuffer buffer = new StringBuffer("Unable to find a valid setter method: ");
        buffer.append("public void ").append(typeClass.getName()).append(".");
        buffer.append(setterName).append("(").append(ObjectRecipe.getClassName(propertyValue)).append(")");
        throw new MissingAccessorException(buffer.toString(), -1);
    }

    public static Field findField(Class typeClass, String propertyName, Object propertyValue, boolean allowPrivate, ClassLoader classLoader) {
        return ObjectRecipe.findField(typeClass, propertyName, propertyValue, allowPrivate, false, false, classLoader);
    }

    public static Field findField(Class typeClass, String propertyName, Object propertyValue, boolean allowPrivate, boolean allowStatic, boolean caseInsesnitive, ClassLoader classLoader) {
        if (propertyName == null) {
            throw new NullPointerException("name is null");
        }
        if (propertyName.length() == 0) {
            throw new IllegalArgumentException("name is an empty string");
        }
        int matchLevel = 0;
        MissingAccessorException missException = null;
        if (propertyName.contains("/")) {
            String[] strings = propertyName.split("/");
            if (strings == null || strings.length != 2) {
                throw new IllegalArgumentException("badly formed <class>/<attribute> property name: " + propertyName);
            }
            String className = strings[0];
            propertyName = strings[1];
            boolean found = false;
            while (!typeClass.equals(Object.class) && !found) {
                if (typeClass.getName().equals(className)) {
                    found = true;
                    break;
                }
                typeClass = typeClass.getSuperclass();
            }
            if (!found) {
                throw new MissingAccessorException("Type not assignable to class: " + className, -1);
            }
        }
        ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(typeClass.getDeclaredFields()));
        for (Class parent = typeClass.getSuperclass(); parent != null; parent = parent.getSuperclass()) {
            fields.addAll(Arrays.asList(parent.getDeclaredFields()));
        }
        for (Field field : fields) {
            if (!field.getName().equals(propertyName) && (!caseInsesnitive || !field.getName().equalsIgnoreCase(propertyName))) continue;
            if (!allowPrivate && !Modifier.isPublic(field.getModifiers())) {
                if (matchLevel >= 4) continue;
                matchLevel = 4;
                missException = new MissingAccessorException("Field is not public: " + field, matchLevel);
                continue;
            }
            if (!allowStatic && Modifier.isStatic(field.getModifiers())) {
                if (matchLevel >= 4) continue;
                matchLevel = 4;
                missException = new MissingAccessorException("Field is static: " + field, matchLevel);
                continue;
            }
            Class<?> fieldType = field.getType();
            if (fieldType.isPrimitive() && propertyValue == null) {
                if (matchLevel >= 6) continue;
                matchLevel = 6;
                missException = new MissingAccessorException("Null can not be assigned to " + fieldType.getName() + ": " + field, matchLevel);
                continue;
            }
            if (!RecipeHelper.isInstance(fieldType, propertyValue) && !RecipeHelper.isConvertable(fieldType, propertyValue, classLoader)) {
                if (matchLevel >= 5) continue;
                matchLevel = 5;
                missException = new MissingAccessorException(ObjectRecipe.getClassName(propertyValue) + " can not be assigned or converted to " + fieldType.getName() + ": " + field, matchLevel);
                continue;
            }
            if (allowPrivate && !Modifier.isPublic(field.getModifiers())) {
                ObjectRecipe.setAccessible(field);
            }
            return field;
        }
        if (missException != null) {
            throw missException;
        }
        StringBuffer buffer = new StringBuffer("Unable to find a valid field: ");
        buffer.append("public ").append(" ").append(ObjectRecipe.getClassName(propertyValue));
        buffer.append(" ").append(propertyName).append(";");
        throw new MissingAccessorException(buffer.toString(), -1);
    }

    public static boolean isAssignableFrom(Class[] expectedTypes, Class[] actualTypes) {
        if (expectedTypes.length != actualTypes.length) {
            return false;
        }
        for (int i = 0; i < expectedTypes.length; ++i) {
            Class expectedType = expectedTypes[i];
            Class actualType = actualTypes[i];
            if (expectedType == actualType || RecipeHelper.isAssignableFrom(expectedType, actualType)) continue;
            return false;
        }
        return true;
    }

    private static void setAccessible(final Method method) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                method.setAccessible(true);
                return null;
            }
        });
    }

    private static void setAccessible(final Field field) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                field.setAccessible(true);
                return null;
            }
        });
    }

    private static class FieldProperty
    extends Property {
        public FieldProperty(String name) {
            super(name);
        }

        public int hashCode() {
            return super.hashCode() + 1;
        }

        public String toString() {
            return "[field] " + this.toString();
        }
    }

    private static class SetterProperty
    extends Property {
        public SetterProperty(String name) {
            super(name);
        }

        public int hashCode() {
            return super.hashCode() + 2;
        }

        public String toString() {
            return "[setter] " + this.toString();
        }
    }

    private static class Property {
        private final String name;

        public Property(String name) {
            if (name == null) {
                throw new NullPointerException("name is null");
            }
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (o instanceof String) {
                return this.name.equals(o);
            }
            if (o instanceof Property) {
                Property property = (Property)o;
                return this.name.equals(property.name);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.name;
        }
    }

    public static class FieldMember
    implements Member {
        private final Field field;

        public FieldMember(Field field) {
            this.field = field;
        }

        public Class getType() {
            return this.field.getType();
        }

        public void setValue(Object instance, Object value) throws Exception {
            this.field.set(instance, value);
        }

        public String toString() {
            return this.field.toString();
        }
    }

    public static class MethodMember
    implements Member {
        private final Method setter;

        public MethodMember(Method method) {
            this.setter = method;
        }

        public Class getType() {
            return this.setter.getParameterTypes()[0];
        }

        public void setValue(Object instance, Object value) throws Exception {
            this.setter.invoke(instance, value);
        }

        public String toString() {
            return this.setter.toString();
        }
    }

    public static interface Member {
        public Class getType();

        public void setValue(Object var1, Object var2) throws Exception;
    }
}

