/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.propertyeditor;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import org.apache.xbean.propertyeditor.AbstractConverter;
import org.apache.xbean.propertyeditor.PropertyEditorException;

public class DateEditor
extends AbstractConverter {
    private DateFormat formatter;

    public DateEditor() {
        super(Date.class);
    }

    protected Object toObjectImpl(String text) {
        try {
            String token;
            Locale locale = Locale.getDefault();
            int style = 2;
            int firstSpaceIndex = text.indexOf(32);
            if (firstSpaceIndex != -1 && (token = text.substring(0, firstSpaceIndex).intern()).startsWith("locale")) {
                String localeStr = token.substring(token.indexOf(61) + 1);
                int underscoreIndex = localeStr.indexOf(95);
                if (underscoreIndex != -1) {
                    String language = localeStr.substring(0, underscoreIndex);
                    String country = localeStr.substring(underscoreIndex + 1);
                    locale = new Locale(language, country);
                } else {
                    locale = new Locale(localeStr);
                }
                int nextSpaceIndex = text.indexOf(32, firstSpaceIndex + 1);
                token = text.substring(firstSpaceIndex + 1, nextSpaceIndex);
                String styleStr = token.substring(token.indexOf(61) + 1);
                style = styleStr.equalsIgnoreCase("SHORT") ? 3 : (styleStr.equalsIgnoreCase("MEDIUM") ? 2 : (styleStr.equalsIgnoreCase("LONG") ? 1 : (styleStr.equalsIgnoreCase("FULL") ? 0 : 2)));
                text = text.substring(nextSpaceIndex + 1);
            }
            this.formatter = DateFormat.getDateInstance(style, locale);
            return this.formatter.parse(text);
        }
        catch (ParseException e) {
            throw new PropertyEditorException(e);
        }
    }

    protected String toStringImpl(Object value) {
        Date date = (Date)value;
        String text = this.formatter.format(date);
        return text;
    }
}

