/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.recipe;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.xbean.Classes;
import org.apache.xbean.propertyeditor.PropertyEditors;
import org.apache.xbean.recipe.ConstructionException;
import org.apache.xbean.recipe.MissingAccessorException;
import org.apache.xbean.recipe.Option;
import org.apache.xbean.recipe.Recipe;
import org.apache.xbean.recipe.RecipeHelper;
import org.apache.xbean.recipe.ValueRecipe;

public class ObjectRecipe
implements Recipe {
    private final String type;
    private final String factoryMethod;
    private final String[] constructorArgNames;
    private final Class[] constructorArgTypes;
    private final LinkedHashMap properties;
    private final List options = new ArrayList();
    private final Map unsetProperties = new LinkedHashMap();

    public ObjectRecipe(Class type) {
        this(type.getName());
    }

    public ObjectRecipe(Class type, String factoryMethod) {
        this(type.getName(), factoryMethod);
    }

    public ObjectRecipe(Class type, Map properties) {
        this(type.getName(), properties);
    }

    public ObjectRecipe(Class type, String[] constructorArgNames, Class[] constructorArgTypes) {
        this(type.getName(), constructorArgNames, constructorArgTypes);
    }

    public ObjectRecipe(Class type, String factoryMethod, String[] constructorArgNames, Class[] constructorArgTypes) {
        this(type.getName(), factoryMethod, constructorArgNames, constructorArgTypes);
    }

    public ObjectRecipe(String typeName) {
        this(typeName, null, null, null, null);
    }

    public ObjectRecipe(String typeName, String factoryMethod) {
        this(typeName, factoryMethod, null, null, null);
    }

    public ObjectRecipe(String typeName, Map properties) {
        this(typeName, null, null, null, properties);
    }

    public ObjectRecipe(String typeName, String[] constructorArgNames, Class[] constructorArgTypes) {
        this(typeName, null, constructorArgNames, constructorArgTypes, null);
    }

    public ObjectRecipe(String typeName, String factoryMethod, String[] constructorArgNames, Class[] constructorArgTypes) {
        this(typeName, factoryMethod, constructorArgNames, constructorArgTypes, null);
    }

    public ObjectRecipe(String type, String factoryMethod, String[] constructorArgNames, Class[] constructorArgTypes, Map properties) {
        this.type = type;
        this.factoryMethod = factoryMethod;
        this.constructorArgNames = constructorArgNames != null ? constructorArgNames : new String[0];
        this.constructorArgTypes = constructorArgTypes != null ? constructorArgTypes : new Class[0];
        if (properties != null) {
            this.properties = new LinkedHashMap(properties);
            this.setAllProperties(properties);
        } else {
            this.properties = new LinkedHashMap();
        }
    }

    public void allow(Option option) {
        this.options.add(option);
    }

    public void disallow(Option option) {
        this.options.remove(option);
    }

    public Object getProperty(String name) {
        Object value = this.properties.get(new Property(name));
        return value;
    }

    public void setProperty(String name, Object value) {
        this.setProperty(new Property(name), value);
    }

    public void setFieldProperty(String name, Object value) {
        this.setProperty(new FieldProperty(name), value);
        this.options.add(Option.FIELD_INJECTION);
    }

    public void setMethodProperty(String name, Object value) {
        this.setProperty(new SetterProperty(name), value);
    }

    private void setProperty(Property key, Object value) {
        if (!RecipeHelper.isSimpleType(value)) {
            value = new ValueRecipe(value);
        }
        this.properties.put(key, value);
    }

    public void setAllProperties(Map map) {
        if (map == null) {
            throw new NullPointerException("map is null");
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            this.setProperty(name, value);
        }
    }

    public Object create() throws ConstructionException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        return this.create(contextClassLoader);
    }

    public Object create(ClassLoader classLoader) throws ConstructionException {
        this.unsetProperties.clear();
        Class<?> typeClass = null;
        try {
            typeClass = Class.forName(this.type, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new ConstructionException("Type class could not be found: " + this.type);
        }
        if (!Modifier.isPublic(typeClass.getModifiers())) {
            throw new ConstructionException("Class is not public: " + Classes.getClassName(typeClass, true));
        }
        if (Modifier.isInterface(typeClass.getModifiers())) {
            throw new ConstructionException("Class is an interface: " + Classes.getClassName(typeClass, true));
        }
        if (Modifier.isAbstract(typeClass.getModifiers())) {
            throw new ConstructionException("Class is abstract: " + Classes.getClassName(typeClass, true));
        }
        LinkedHashMap propertyValues = new LinkedHashMap(this.properties);
        Iterator iterator = propertyValues.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object value = entry.getValue();
            if (!(value instanceof Recipe)) continue;
            Recipe recipe = (Recipe)value;
            value = recipe.create(classLoader);
            entry.setValue(value);
        }
        Object instance = this.createInstance(typeClass, propertyValues);
        boolean allowPrivate = this.options.contains(Option.PRIVATE_PROPERTIES);
        boolean ignoreMissingProperties = this.options.contains(Option.IGNORE_MISSING_PROPERTIES);
        Iterator iterator2 = propertyValues.entrySet().iterator();
        while (iterator2.hasNext()) {
            Member member;
            Object propertyValue;
            block19: {
                Map.Entry entry = iterator2.next();
                Property propertyName = (Property)entry.getKey();
                propertyValue = entry.getValue();
                try {
                    if (propertyName instanceof SetterProperty) {
                        member = new MethodMember(ObjectRecipe.findSetter(typeClass, propertyName.name, propertyValue, allowPrivate));
                        break block19;
                    }
                    if (propertyName instanceof FieldProperty) {
                        member = new FieldMember(ObjectRecipe.findField(typeClass, propertyName.name, propertyValue, allowPrivate));
                        break block19;
                    }
                    try {
                        member = new MethodMember(ObjectRecipe.findSetter(typeClass, propertyName.name, propertyValue, allowPrivate));
                    }
                    catch (MissingAccessorException noSetter) {
                        if (!this.options.contains(Option.FIELD_INJECTION)) {
                            throw noSetter;
                        }
                        try {
                            member = new FieldMember(ObjectRecipe.findField(typeClass, propertyName.name, propertyValue, allowPrivate));
                        }
                        catch (MissingAccessorException noField) {
                            throw noField.getMatchLevel() > noSetter.getMatchLevel() ? noField : noSetter;
                        }
                    }
                }
                catch (MissingAccessorException e) {
                    if (ignoreMissingProperties) {
                        this.unsetProperties.put(propertyName.name, propertyValue);
                        continue;
                    }
                    throw e;
                }
            }
            try {
                propertyValue = ObjectRecipe.convert(member.getType(), propertyValue);
                member.setValue(instance, propertyValue);
            }
            catch (Exception e) {
                throw new ConstructionException("Error setting property: " + member);
            }
        }
        return instance;
    }

    public Map getUnsetProperties() {
        return new LinkedHashMap(this.unsetProperties);
    }

    private Object[] extractConstructorArgs(Map propertyValues, Class[] constructorArgTypes) {
        Object[] parameters = new Object[this.constructorArgNames.length];
        for (int i = 0; i < this.constructorArgNames.length; ++i) {
            Object value;
            Property name = new Property(this.constructorArgNames[i]);
            Class type = constructorArgTypes[i];
            if (propertyValues.containsKey(name)) {
                value = propertyValues.remove(name);
                if (!ObjectRecipe.isInstance(type, value) && !ObjectRecipe.isConvertable(type, value)) {
                    throw new ConstructionException("Invalid and non-convertable constructor parameter type: name=" + name + ", " + "index=" + i + ", " + "expected=" + Classes.getClassName(type, true) + ", " + "actual=" + Classes.getClassName(value, true));
                }
                value = ObjectRecipe.convert(type, value);
            } else {
                value = ObjectRecipe.getDefaultValue(type);
            }
            parameters[i] = value;
        }
        return parameters;
    }

    private static Object convert(Class type, Object value) {
        if (value instanceof String && type != Object.class) {
            String stringValue = (String)value;
            value = PropertyEditors.getValue(type, stringValue);
        }
        return value;
    }

    private static Object getDefaultValue(Class type) {
        if (type.equals(Boolean.TYPE)) {
            return Boolean.FALSE;
        }
        if (type.equals(Character.TYPE)) {
            return new Character('\u0000');
        }
        if (type.equals(Byte.TYPE)) {
            return new Byte(0);
        }
        if (type.equals(Short.TYPE)) {
            return new Short(0);
        }
        if (type.equals(Integer.TYPE)) {
            return new Integer(0);
        }
        if (type.equals(Long.TYPE)) {
            return new Long(0L);
        }
        if (type.equals(Float.TYPE)) {
            return new Float(0.0f);
        }
        if (type.equals(Double.TYPE)) {
            return new Double(0.0);
        }
        return null;
    }

    private Object createInstance(Class typeClass, Map propertyValues) {
        if (this.factoryMethod != null) {
            Method method = this.selectFactory(typeClass);
            Object[] parameters = this.extractConstructorArgs(propertyValues, method.getParameterTypes());
            try {
                Object object = method.invoke(null, parameters);
                return object;
            }
            catch (Exception e) {
                InvocationTargetException invocationTargetException;
                Throwable t = e;
                if (e instanceof InvocationTargetException && (invocationTargetException = (InvocationTargetException)e).getCause() != null) {
                    t = invocationTargetException.getCause();
                }
                throw new ConstructionException("Error invoking factory method: " + method, t);
            }
        }
        Constructor constructor = this.selectConstructor(typeClass);
        Object[] parameters = this.extractConstructorArgs(propertyValues, constructor.getParameterTypes());
        try {
            Object object = constructor.newInstance(parameters);
            return object;
        }
        catch (Exception e) {
            InvocationTargetException invocationTargetException;
            Throwable t = e;
            if (e instanceof InvocationTargetException && (invocationTargetException = (InvocationTargetException)e).getCause() != null) {
                t = invocationTargetException.getCause();
            }
            throw new ConstructionException("Error invoking constructor: " + constructor, t);
        }
    }

    private Method selectFactory(Class typeClass) {
        if (this.constructorArgNames.length > 0 && this.constructorArgTypes.length == 0) {
            ArrayList<Method> matches = new ArrayList<Method>();
            Method[] methods = typeClass.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (!method.getName().equals(this.factoryMethod) || method.getParameterTypes().length != this.constructorArgNames.length) continue;
                try {
                    this.checkFactory(method);
                    matches.add(method);
                    continue;
                }
                catch (Exception dontCare) {
                    // empty catch block
                }
            }
            if (matches.size() < 1) {
                StringBuffer buffer = new StringBuffer("No parameter types supplied; unable to find a potentially valid factory method: ");
                buffer.append("public static Object ").append(this.factoryMethod);
                buffer.append(this.toArgumentList(this.constructorArgNames));
                throw new ConstructionException(buffer.toString());
            }
            if (matches.size() > 1) {
                StringBuffer buffer = new StringBuffer("No parameter types supplied; found too many potentially valid factory methods: ");
                buffer.append("public static Object ").append(this.factoryMethod);
                buffer.append(this.toArgumentList(this.constructorArgNames));
                throw new ConstructionException(buffer.toString());
            }
            return (Method)matches.get(0);
        }
        try {
            Method method = typeClass.getMethod(this.factoryMethod, this.constructorArgTypes);
            this.checkFactory(method);
            return method;
        }
        catch (NoSuchMethodException e) {
            Method[] methods = typeClass.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (!method.getName().equals(this.factoryMethod) || !ObjectRecipe.isAssignableFrom(this.constructorArgTypes, method.getParameterTypes()) || Modifier.isPublic(method.getModifiers())) continue;
                throw new ConstructionException("Factory method is not public: " + method);
            }
            StringBuffer buffer = new StringBuffer("Unable to find a valid factory method: ");
            buffer.append("public static Object ").append(Classes.getClassName(typeClass, true)).append(".");
            buffer.append(this.factoryMethod).append(this.toParameterList(this.constructorArgTypes));
            throw new ConstructionException(buffer.toString());
        }
    }

    private void checkFactory(Method method) {
        if (!Modifier.isPublic(method.getModifiers())) {
            throw new ConstructionException("Factory method is not public: " + method);
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new ConstructionException("Factory method is not static: " + method);
        }
        if (method.getReturnType().equals(Void.TYPE)) {
            throw new ConstructionException("Factory method does not return anything: " + method);
        }
        if (method.getReturnType().isPrimitive()) {
            throw new ConstructionException("Factory method returns a primitive type: " + method);
        }
    }

    private Constructor selectConstructor(Class typeClass) {
        if (this.constructorArgNames.length > 0 && this.constructorArgTypes.length == 0) {
            ArrayList matches = new ArrayList();
            Constructor<?>[] constructors = typeClass.getConstructors();
            for (int i = 0; i < constructors.length; ++i) {
                Constructor<?> constructor = constructors[i];
                if (constructor.getParameterTypes().length != this.constructorArgNames.length) continue;
                matches.add(constructor);
            }
            if (matches.size() < 1) {
                StringBuffer buffer = new StringBuffer("No parameter types supplied; unable to find a potentially valid constructor: ");
                buffer.append("constructor= public ").append(Classes.getClassName(typeClass, true));
                buffer.append(this.toArgumentList(this.constructorArgNames));
                throw new ConstructionException(buffer.toString());
            }
            if (matches.size() > 1) {
                StringBuffer buffer = new StringBuffer("No parameter types supplied; found too many potentially valid constructors: ");
                buffer.append("constructor= public ").append(Classes.getClassName(typeClass, true));
                buffer.append(this.toArgumentList(this.constructorArgNames));
                throw new ConstructionException(buffer.toString());
            }
            return (Constructor)matches.get(0);
        }
        try {
            Constructor constructor = typeClass.getConstructor(this.constructorArgTypes);
            if (!Modifier.isPublic(constructor.getModifiers())) {
                throw new ConstructionException("Constructor is not public: " + constructor);
            }
            return constructor;
        }
        catch (NoSuchMethodException e) {
            Constructor<?>[] constructors = typeClass.getDeclaredConstructors();
            for (int i = 0; i < constructors.length; ++i) {
                Constructor<?> constructor = constructors[i];
                if (!ObjectRecipe.isAssignableFrom(this.constructorArgTypes, constructor.getParameterTypes()) || Modifier.isPublic(constructor.getModifiers())) continue;
                throw new ConstructionException("Constructor is not public: " + constructor);
            }
            StringBuffer buffer = new StringBuffer("Unable to find a valid constructor: ");
            buffer.append("constructor= public ").append(Classes.getClassName(typeClass, true));
            buffer.append(this.toParameterList(this.constructorArgTypes));
            throw new ConstructionException(buffer.toString());
        }
    }

    private String toParameterList(Class[] parameterTypes) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("(");
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class type = parameterTypes[i];
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(Classes.getClassName(type, true));
        }
        buffer.append(")");
        return buffer.toString();
    }

    private String toArgumentList(String[] parameterNames) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("(");
        for (int i = 0; i < parameterNames.length; ++i) {
            String parameterName = parameterNames[i];
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append('<').append(parameterName).append('>');
        }
        buffer.append(")");
        return buffer.toString();
    }

    public static Method findSetter(Class typeClass, String propertyName, Object propertyValue, boolean allowPrivate) {
        if (propertyName == null) {
            throw new NullPointerException("name is null");
        }
        if (propertyName.length() == 0) {
            throw new IllegalArgumentException("name is an empty string");
        }
        String setterName = "set" + Character.toUpperCase(propertyName.charAt(0));
        if (propertyName.length() > 0) {
            setterName = setterName + propertyName.substring(1);
        }
        int matchLevel = 0;
        MissingAccessorException missException = null;
        ArrayList<Method> methods = new ArrayList<Method>(Arrays.asList(typeClass.getMethods()));
        methods.addAll(Arrays.asList(typeClass.getDeclaredMethods()));
        Iterator iterator = methods.iterator();
        while (iterator.hasNext()) {
            Method method = (Method)iterator.next();
            if (!method.getName().equals(setterName)) continue;
            if (method.getParameterTypes().length == 0) {
                if (matchLevel >= true) continue;
                matchLevel = 1;
                missException = new MissingAccessorException("Setter takes no parameters: " + method, matchLevel);
                continue;
            }
            if (method.getParameterTypes().length > 1) {
                if (matchLevel >= true) continue;
                matchLevel = 1;
                missException = new MissingAccessorException("Setter takes more then one parameter: " + method, matchLevel);
                continue;
            }
            if (method.getReturnType() != Void.TYPE) {
                if (matchLevel >= 2) continue;
                matchLevel = 2;
                missException = new MissingAccessorException("Setter returns a value: " + method, matchLevel);
                continue;
            }
            if (Modifier.isAbstract(method.getModifiers())) {
                if (matchLevel >= 3) continue;
                matchLevel = 3;
                missException = new MissingAccessorException("Setter is abstract: " + method, matchLevel);
                continue;
            }
            if (!allowPrivate && !Modifier.isPublic(method.getModifiers())) {
                if (matchLevel >= 4) continue;
                matchLevel = 4;
                missException = new MissingAccessorException("Setter is not public: " + method, matchLevel);
                continue;
            }
            if (Modifier.isStatic(method.getModifiers())) {
                if (matchLevel >= 4) continue;
                matchLevel = 4;
                missException = new MissingAccessorException("Setter is static: " + method, matchLevel);
                continue;
            }
            Class<?> methodParameterType = method.getParameterTypes()[0];
            if (methodParameterType.isPrimitive() && propertyValue == null) {
                if (matchLevel >= 6) continue;
                matchLevel = 6;
                missException = new MissingAccessorException("Null can not be assigned to " + Classes.getClassName(methodParameterType, true) + ": " + method, matchLevel);
                continue;
            }
            if (!ObjectRecipe.isInstance(methodParameterType, propertyValue) && !ObjectRecipe.isConvertable(methodParameterType, propertyValue)) {
                if (matchLevel >= 5) continue;
                matchLevel = 5;
                missException = new MissingAccessorException(Classes.getClassName(propertyValue, true) + " can not be assigned or converted to " + Classes.getClassName(methodParameterType, true) + ": " + method, matchLevel);
                continue;
            }
            if (allowPrivate && !Modifier.isPublic(method.getModifiers())) {
                ObjectRecipe.setAccessible(method);
            }
            return method;
        }
        if (missException != null) {
            throw missException;
        }
        StringBuffer buffer = new StringBuffer("Unable to find a valid setter method: ");
        buffer.append("public void ").append(Classes.getClassName(typeClass, true)).append(".");
        buffer.append(setterName).append("(").append(Classes.getClassName(propertyValue, true)).append(")");
        throw new MissingAccessorException(buffer.toString(), -1);
    }

    public static Field findField(Class typeClass, String propertyName, Object propertyValue, boolean allowPrivate) {
        if (propertyName == null) {
            throw new NullPointerException("name is null");
        }
        if (propertyName.length() == 0) {
            throw new IllegalArgumentException("name is an empty string");
        }
        int matchLevel = 0;
        MissingAccessorException missException = null;
        ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(typeClass.getDeclaredFields()));
        for (Class parent = typeClass.getSuperclass(); parent != null; parent = parent.getSuperclass()) {
            fields.addAll(Arrays.asList(parent.getDeclaredFields()));
        }
        Iterator iterator = fields.iterator();
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            if (!field.getName().equals(propertyName)) continue;
            if (!allowPrivate && !Modifier.isPublic(field.getModifiers())) {
                if (matchLevel >= 4) continue;
                matchLevel = 4;
                missException = new MissingAccessorException("Field is not public: " + field, matchLevel);
                continue;
            }
            if (Modifier.isStatic(field.getModifiers())) {
                if (matchLevel >= 4) continue;
                matchLevel = 4;
                missException = new MissingAccessorException("Field is static: " + field, matchLevel);
                continue;
            }
            Class<?> fieldType = field.getType();
            if (fieldType.isPrimitive() && propertyValue == null) {
                if (matchLevel >= 6) continue;
                matchLevel = 6;
                missException = new MissingAccessorException("Null can not be assigned to " + Classes.getClassName(fieldType, true) + ": " + field, matchLevel);
                continue;
            }
            if (!ObjectRecipe.isInstance(fieldType, propertyValue) && !ObjectRecipe.isConvertable(fieldType, propertyValue)) {
                if (matchLevel >= 5) continue;
                matchLevel = 5;
                missException = new MissingAccessorException(Classes.getClassName(propertyValue, true) + " can not be assigned or converted to " + Classes.getClassName(fieldType, true) + ": " + field, matchLevel);
                continue;
            }
            if (allowPrivate && !Modifier.isPublic(field.getModifiers())) {
                ObjectRecipe.setAccessible(field);
            }
            return field;
        }
        if (missException != null) {
            throw missException;
        }
        StringBuffer buffer = new StringBuffer("Unable to find a valid field: ");
        buffer.append("public ").append(" ").append(Classes.getClassName(propertyValue, true));
        buffer.append(" ").append(propertyName).append(";");
        throw new MissingAccessorException(buffer.toString(), -1);
    }

    public static boolean isConvertable(Class methodParameterType, Object propertyValue) {
        return propertyValue instanceof String && PropertyEditors.canConvert(methodParameterType);
    }

    public static boolean isInstance(Class type, Object instance) {
        if (type.isPrimitive()) {
            if (instance == null) {
                return false;
            }
            if (type.equals(Boolean.TYPE)) {
                return instance instanceof Boolean;
            }
            if (type.equals(Character.TYPE)) {
                return instance instanceof Character;
            }
            if (type.equals(Byte.TYPE)) {
                return instance instanceof Byte;
            }
            if (type.equals(Short.TYPE)) {
                return instance instanceof Short;
            }
            if (type.equals(Integer.TYPE)) {
                return instance instanceof Integer;
            }
            if (type.equals(Long.TYPE)) {
                return instance instanceof Long;
            }
            if (type.equals(Float.TYPE)) {
                return instance instanceof Float;
            }
            if (type.equals(Double.TYPE)) {
                return instance instanceof Double;
            }
            throw new AssertionError((Object)("Invalid primitve type: " + type));
        }
        return instance == null || type.isInstance(instance);
    }

    public static boolean isAssignableFrom(Class expected, Class actual) {
        if (expected.isPrimitive()) {
            if (expected.equals(Boolean.TYPE)) {
                return actual.equals(Boolean.class);
            }
            if (expected.equals(Character.TYPE)) {
                return actual.equals(Character.class);
            }
            if (expected.equals(Byte.TYPE)) {
                return actual.equals(Byte.class);
            }
            if (expected.equals(Short.TYPE)) {
                return actual.equals(Short.class);
            }
            if (expected.equals(Integer.TYPE)) {
                return actual.equals(Integer.class);
            }
            if (expected.equals(Long.TYPE)) {
                return actual.equals(Long.class);
            }
            if (expected.equals(Float.TYPE)) {
                return actual.equals(Float.class);
            }
            if (expected.equals(Double.TYPE)) {
                return actual.equals(Double.class);
            }
            throw new AssertionError((Object)("Invalid primitve type: " + expected));
        }
        return expected.isAssignableFrom(actual);
    }

    public static boolean isAssignableFrom(Class[] expectedTypes, Class[] actualTypes) {
        if (expectedTypes.length != actualTypes.length) {
            return false;
        }
        for (int i = 0; i < expectedTypes.length; ++i) {
            Class expectedType = expectedTypes[i];
            Class actualType = actualTypes[i];
            if (ObjectRecipe.isAssignableFrom(expectedType, actualType)) continue;
            return false;
        }
        return true;
    }

    private static void setAccessible(final Method method) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                method.setAccessible(true);
                return null;
            }
        });
    }

    private static void setAccessible(final Field field) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                field.setAccessible(true);
                return null;
            }
        });
    }

    private static class FieldProperty
    extends Property {
        public FieldProperty(String name) {
            super(name);
        }

        public int hashCode() {
            return super.hashCode() + 1;
        }

        public String toString() {
            return "[field] " + this.toString();
        }
    }

    private static class SetterProperty
    extends Property {
        public SetterProperty(String name) {
            super(name);
        }

        public int hashCode() {
            return super.hashCode() + 2;
        }

        public String toString() {
            return "[setter] " + this.toString();
        }
    }

    private static class Property {
        private final String name;

        public Property(String name) {
            if (name == null) {
                throw new NullPointerException("name is null");
            }
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (o instanceof String) {
                return this.name.equals(o);
            }
            if (o instanceof Property) {
                Property property = (Property)o;
                return this.name.equals(property.name);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.name;
        }
    }

    public static class FieldMember
    implements Member {
        private final Field field;

        public FieldMember(Field field) {
            this.field = field;
        }

        public Class getType() {
            return this.field.getType();
        }

        public void setValue(Object instance, Object value) throws Exception {
            this.field.set(instance, value);
        }

        public String toString() {
            return this.field.toString();
        }
    }

    public static class MethodMember
    implements Member {
        private final Method setter;

        public MethodMember(Method method) {
            this.setter = method;
        }

        public Class getType() {
            return this.setter.getParameterTypes()[0];
        }

        public void setValue(Object instance, Object value) throws Exception {
            this.setter.invoke(instance, value);
        }

        public String toString() {
            return this.setter.toString();
        }
    }

    public static interface Member {
        public Class getType();

        public void setValue(Object var1, Object var2) throws Exception;
    }
}

