/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.propertyeditor;

import java.beans.PropertyEditorSupport;
import org.apache.xbean.ClassLoading;
import org.apache.xbean.propertyeditor.Converter;
import org.apache.xbean.propertyeditor.PropertyEditorException;

public abstract class AbstractConverter
extends PropertyEditorSupport
implements Converter {
    private final Class type;

    protected AbstractConverter(Class type) {
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        this.type = type;
    }

    public final Class getType() {
        return this.type;
    }

    public final String getAsText() {
        Object value = super.getValue();
        String text = this.toString(value);
        return text;
    }

    public final void setAsText(String text) {
        Object value = this.toObject(text.trim());
        super.setValue(value);
    }

    public final Object getValue() {
        Object value = super.getValue();
        return value;
    }

    public final void setValue(Object value) {
        if (value == null) {
            super.setValue(null);
        }
        if (!this.type.isInstance(value)) {
            throw new PropertyEditorException("Value is not an instance of " + ClassLoading.getClassName(this.type));
        }
        super.setValue(value);
    }

    public final String toString(Object value) {
        if (value == null) {
            return null;
        }
        if (!this.type.isInstance(value)) {
            throw new PropertyEditorException("Value is not an instance of " + ClassLoading.getClassName(this.type) + ": " + value.getClass().getName());
        }
        return this.toStringImpl(value);
    }

    public final Object toObject(String text) {
        if (text == null) {
            return null;
        }
        Object value = this.toObjectImpl(text.trim());
        return value;
    }

    protected String toStringImpl(Object value) {
        String text = value.toString();
        return text;
    }

    protected abstract Object toObjectImpl(String var1);
}

