/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.propertyeditor;

import java.beans.PropertyEditor;
import java.lang.reflect.Array;
import java.util.List;
import java.util.ListIterator;
import org.apache.xbean.ClassLoading;
import org.apache.xbean.propertyeditor.AbstractCollectionConverter;

public final class ArrayConverter
extends AbstractCollectionConverter {
    public ArrayConverter(Class type, PropertyEditor editor) {
        super(type, editor);
        if (!type.isArray()) {
            throw new IllegalArgumentException("type is not an array " + ClassLoading.getClassName(type));
        }
        if (type.getComponentType().isArray()) {
            throw new IllegalArgumentException("type is a multi-dimensional array " + ClassLoading.getClassName(type, true));
        }
        if (editor == null) {
            throw new NullPointerException("editor is null");
        }
    }

    protected Object createCollection(List list) {
        Object array = Array.newInstance(this.getType().getComponentType(), list.size());
        ListIterator iterator = list.listIterator();
        while (iterator.hasNext()) {
            Object item = iterator.next();
            int index = iterator.previousIndex();
            Array.set(array, index, item);
        }
        return array;
    }
}

