/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.naming.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.naming.Name;
import javax.naming.NamingException;
import org.apache.xbean.naming.context.ContextAccess;
import org.apache.xbean.naming.context.ContextUtil;

public class ContextAccessControlList
implements ContextAccess {
    private final boolean defaultAllow;
    private final List allow;
    private final List deny;

    public ContextAccessControlList(boolean defaultAllow, List allow, List deny) {
        this.defaultAllow = defaultAllow;
        this.allow = this.toACL(allow);
        this.deny = this.toACL(deny);
    }

    private List toACL(List input) {
        if (input == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList list = new ArrayList(input.size());
        Iterator iterator = input.iterator();
        while (iterator.hasNext()) {
            Object value = iterator.next();
            if (value instanceof Name) {
                list.add(value);
                continue;
            }
            if (value instanceof String) {
                String string = (String)value;
                Name name = null;
                try {
                    name = ContextUtil.NAME_PARSER.parse(string);
                }
                catch (NamingException e) {
                    throw new IllegalArgumentException("error while parsing name: " + value);
                }
                list.add(name);
                continue;
            }
            throw new IllegalArgumentException("name is not an instance of Name or String: " + value);
        }
        return Collections.unmodifiableList(list);
    }

    public boolean isModifiable(Name name) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (this.defaultAllow) {
            return !this.isDenied(name) || this.isAllowed(name);
        }
        return this.isAllowed(name) && !this.isDenied(name);
    }

    protected boolean isAllowed(Name name) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        Iterator iterator = this.allow.iterator();
        while (iterator.hasNext()) {
            Name prefix = (Name)iterator.next();
            if (!name.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    protected boolean isDenied(Name name) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        Iterator iterator = this.deny.iterator();
        while (iterator.hasNext()) {
            Name prefix = (Name)iterator.next();
            if (!name.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }
}

