/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.finder;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlSet {
    private final Map<String, URL> urls;

    public UrlSet(ClassLoader classLoader) throws IOException {
        this(UrlSet.getUrls(classLoader));
    }

    public UrlSet(URL ... urls) {
        this(Arrays.asList(urls));
    }

    public UrlSet(Collection<URL> urls) {
        this.urls = new HashMap<String, URL>();
        for (URL location : urls) {
            try {
                this.urls.put(location.toExternalForm(), location);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private UrlSet(Map<String, URL> urls) {
        this.urls = urls;
    }

    public UrlSet include(UrlSet urlSet) {
        HashMap<String, URL> urls = new HashMap<String, URL>(this.urls);
        urls.putAll(urlSet.urls);
        return new UrlSet(urls);
    }

    public UrlSet exclude(UrlSet urlSet) {
        HashMap<String, URL> urls = new HashMap<String, URL>(this.urls);
        Map<String, URL> parentUrls = urlSet.urls;
        for (String url : parentUrls.keySet()) {
            urls.remove(url);
        }
        return new UrlSet(urls);
    }

    public UrlSet exclude(ClassLoader parent) throws IOException {
        return this.exclude(new UrlSet(parent));
    }

    public UrlSet exclude(File file) throws MalformedURLException {
        return this.exclude(this.relative(file));
    }

    public UrlSet exclude(String pattern) throws MalformedURLException {
        return this.exclude(this.matching(pattern));
    }

    public UrlSet excludeJavaExtDirs() throws MalformedURLException {
        return this.excludePaths(System.getProperty("java.ext.dirs"));
    }

    public UrlSet excludeJavaEndorsedDirs() throws MalformedURLException {
        return this.excludePaths(System.getProperty("java.endorsed.dirs"));
    }

    public UrlSet excludeJavaHome() throws MalformedURLException {
        String path = System.getProperty("java.home");
        return this.exclude(new File(path));
    }

    public UrlSet excludePaths(String pathString) throws MalformedURLException {
        String[] paths = pathString.split(File.pathSeparator);
        UrlSet urlSet = this;
        for (String path : paths) {
            File file = new File(path);
            urlSet = urlSet.exclude(file);
        }
        return urlSet;
    }

    public UrlSet matching(String pattern) {
        HashMap<String, URL> urls = new HashMap<String, URL>();
        for (Map.Entry<String, URL> entry : this.urls.entrySet()) {
            String url = entry.getKey();
            if (!url.matches(pattern)) continue;
            urls.put(url, entry.getValue());
        }
        return new UrlSet(urls);
    }

    public UrlSet relative(File file) throws MalformedURLException {
        String urlPath = file.toURL().toExternalForm();
        HashMap<String, URL> urls = new HashMap<String, URL>();
        for (Map.Entry<String, URL> entry : this.urls.entrySet()) {
            String url = entry.getKey();
            if (!url.startsWith(urlPath) && !url.startsWith("jar:" + urlPath)) continue;
            urls.put(url, entry.getValue());
        }
        return new UrlSet(urls);
    }

    public List<URL> getUrls() {
        return new ArrayList<URL>(this.urls.values());
    }

    private static List<URL> getUrls(ClassLoader classLoader) throws IOException {
        ArrayList<URL> list = new ArrayList<URL>();
        ArrayList<URL> urls = Collections.list(classLoader.getResources("META-INF"));
        for (URL url : urls) {
            String externalForm = url.toExternalForm();
            int i = externalForm.lastIndexOf("META-INF");
            externalForm = externalForm.substring(0, i);
            url = new URL(externalForm);
            list.add(url);
        }
        list.addAll(Collections.list(classLoader.getResources("")));
        return list;
    }
}

