/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.classloader;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.xbean.classloader.MultiParentClassLoader;
import org.apache.xbean.classloader.ResourceHandle;
import org.apache.xbean.classloader.UnionEnumeration;
import org.apache.xbean.classloader.UrlResourceFinder;

public class JarFileClassLoader
extends MultiParentClassLoader {
    private static final URL[] EMPTY_URLS = new URL[0];
    private final UrlResourceFinder resourceFinder = new UrlResourceFinder();

    public JarFileClassLoader(String name, URL[] urls) {
        super(name, EMPTY_URLS);
        this.addURLs(urls);
    }

    public JarFileClassLoader(String name, URL[] urls, ClassLoader parent) {
        super(name, EMPTY_URLS, parent);
        this.addURLs(urls);
    }

    public JarFileClassLoader(String name, URL[] urls, ClassLoader parent, boolean inverseClassLoading, String[] hiddenClasses, String[] nonOverridableClasses) {
        super(name, EMPTY_URLS, parent, inverseClassLoading, hiddenClasses, nonOverridableClasses);
        this.addURLs(urls);
    }

    public JarFileClassLoader(String name, URL[] urls, ClassLoader[] parents) {
        super(name, EMPTY_URLS, parents);
        this.addURLs(urls);
    }

    public JarFileClassLoader(String name, URL[] urls, ClassLoader[] parents, boolean inverseClassLoading, Collection hiddenClasses, Collection nonOverridableClasses) {
        super(name, EMPTY_URLS, parents, inverseClassLoading, hiddenClasses, nonOverridableClasses);
        this.addURLs(urls);
    }

    public JarFileClassLoader(String name, URL[] urls, ClassLoader[] parents, boolean inverseClassLoading, String[] hiddenClasses, String[] nonOverridableClasses) {
        super(name, EMPTY_URLS, parents, inverseClassLoading, hiddenClasses, nonOverridableClasses);
        this.addURLs(urls);
    }

    public URL[] getURLs() {
        return this.resourceFinder.getUrls();
    }

    public void addURL(URL url) {
        this.resourceFinder.addUrl(url);
    }

    protected void addURLs(URL[] urls) {
        this.resourceFinder.addUrls(urls);
    }

    public void destroy() {
        this.resourceFinder.destroy();
        super.destroy();
    }

    public URL findResource(String resourceName) {
        return this.resourceFinder.findResource(resourceName);
    }

    public Enumeration findResources(String resourceName) throws IOException {
        Enumeration parentResources = super.findResources(resourceName);
        Enumeration myResources = this.resourceFinder.findResources(resourceName);
        UnionEnumeration resources = new UnionEnumeration(parentResources, myResources);
        return resources;
    }

    protected String findLibrary(String libraryName) {
        String resourceName;
        int pathEnd = libraryName.lastIndexOf(47);
        if (pathEnd == libraryName.length() - 1) {
            throw new IllegalArgumentException("libraryName ends with a '/' character: " + libraryName);
        }
        if (pathEnd < 0) {
            resourceName = System.mapLibraryName(libraryName);
        } else {
            String path = libraryName.substring(0, pathEnd + 1);
            String file = libraryName.substring(pathEnd + 1);
            resourceName = path + System.mapLibraryName(file);
        }
        ResourceHandle resourceHandle = this.resourceFinder.getResource(resourceName);
        if (resourceHandle == null) {
            return null;
        }
        URL url = resourceHandle.getUrl();
        if (!"file".equals(url.getProtocol())) {
            return null;
        }
        String path = new File(URI.create(url.toString())).getPath();
        return path;
    }

    protected Class findClass(String className) throws ClassNotFoundException {
        Manifest manifest;
        byte[] bytes;
        String resourceName;
        ResourceHandle resourceHandle;
        int packageEnd;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (packageEnd = className.lastIndexOf(46)) >= 0) {
            String packageName = className.substring(0, packageEnd);
            securityManager.checkPackageDefinition(packageName);
        }
        if ((resourceHandle = this.resourceFinder.getResource(resourceName = className.replace('.', '/') + ".class")) == null) {
            throw new ClassNotFoundException(className);
        }
        try {
            bytes = resourceHandle.getBytes();
            manifest = resourceHandle.getManifest();
        }
        catch (IOException e) {
            throw new ClassNotFoundException(className, e);
        }
        Certificate[] certificates = resourceHandle.getCertificates();
        URL codeSourceUrl = resourceHandle.getCodeSourceUrl();
        this.definePackage(className, codeSourceUrl, manifest);
        CodeSource codeSource = new CodeSource(codeSourceUrl, certificates);
        Class<?> clazz = this.defineClass(className, bytes, 0, bytes.length, codeSource);
        return clazz;
    }

    private void definePackage(String className, URL jarUrl, Manifest manifest) {
        Package pkg;
        int packageEnd = className.lastIndexOf(46);
        if (packageEnd < 0) {
            return;
        }
        String packageName = className.substring(0, packageEnd);
        String packagePath = packageName.replace('.', '/') + "/";
        Attributes packageAttributes = null;
        Attributes mainAttributes = null;
        if (manifest != null) {
            packageAttributes = manifest.getAttributes(packagePath);
            mainAttributes = manifest.getMainAttributes();
        }
        if ((pkg = this.getPackage(packageName)) != null) {
            if (pkg.isSealed()) {
                if (!pkg.isSealed(jarUrl)) {
                    throw new SecurityException("Package was already sealed with another URL: package=" + packageName + ", url=" + jarUrl);
                }
            } else if (this.isSealed(packageAttributes, mainAttributes)) {
                throw new SecurityException("Package was already been loaded and not sealed: package=" + packageName + ", url=" + jarUrl);
            }
        } else {
            String specTitle = this.getAttribute(Attributes.Name.SPECIFICATION_TITLE, packageAttributes, mainAttributes);
            String specVendor = this.getAttribute(Attributes.Name.SPECIFICATION_VENDOR, packageAttributes, mainAttributes);
            String specVersion = this.getAttribute(Attributes.Name.SPECIFICATION_VERSION, packageAttributes, mainAttributes);
            String implTitle = this.getAttribute(Attributes.Name.IMPLEMENTATION_TITLE, packageAttributes, mainAttributes);
            String implVendor = this.getAttribute(Attributes.Name.IMPLEMENTATION_VENDOR, packageAttributes, mainAttributes);
            String implVersion = this.getAttribute(Attributes.Name.IMPLEMENTATION_VERSION, packageAttributes, mainAttributes);
            URL sealBase = null;
            if (this.isSealed(packageAttributes, mainAttributes)) {
                sealBase = jarUrl;
            }
            this.definePackage(packageName, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
        }
    }

    private String getAttribute(Attributes.Name name, Attributes packageAttributes, Attributes mainAttributes) {
        String value;
        if (packageAttributes != null && (value = packageAttributes.getValue(name)) != null) {
            return value;
        }
        if (mainAttributes != null) {
            return mainAttributes.getValue(name);
        }
        return null;
    }

    private boolean isSealed(Attributes packageAttributes, Attributes mainAttributes) {
        String sealed = this.getAttribute(Attributes.Name.SEALED, packageAttributes, mainAttributes);
        if (sealed == null) {
            return false;
        }
        return "true".equalsIgnoreCase(sealed);
    }
}

