/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.blueprint.context.impl;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.aries.blueprint.NamespaceHandler;
import org.apache.aries.blueprint.ParserContext;
import org.apache.aries.blueprint.mutable.MutableBeanMetadata;
import org.apache.aries.blueprint.mutable.MutableCollectionMetadata;
import org.apache.aries.blueprint.mutable.MutableMapMetadata;
import org.apache.aries.blueprint.mutable.MutableRefMetadata;
import org.apache.aries.blueprint.mutable.MutableValueMetadata;
import org.apache.xbean.blueprint.context.impl.MappingMetaData;
import org.apache.xbean.blueprint.context.impl.NamedConstructorArgs;
import org.apache.xbean.blueprint.context.impl.QNameHelper;
import org.osgi.framework.Bundle;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.osgi.service.blueprint.reflect.BeanMetadata;
import org.osgi.service.blueprint.reflect.BeanProperty;
import org.osgi.service.blueprint.reflect.CollectionMetadata;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.MapEntry;
import org.osgi.service.blueprint.reflect.Metadata;
import org.osgi.service.blueprint.reflect.NonNullMetadata;
import org.osgi.service.blueprint.reflect.NullMetadata;
import org.osgi.service.blueprint.reflect.RefMetadata;
import org.osgi.service.blueprint.reflect.ReferenceMetadata;
import org.osgi.service.blueprint.reflect.ServiceReferenceMetadata;
import org.osgi.service.blueprint.reflect.Target;
import org.osgi.service.blueprint.reflect.ValueMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XBeanNamespaceHandler
implements NamespaceHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(XBeanNamespaceHandler.class);
    public static final String BLUEPRINT_NAMESPACE = "http://www.osgi.org/xmlns/blueprint/v1.0.0";
    private static final String BEAN_REFERENCE_PREFIX = "#";
    private static final String NULL_REFERENCE = "#null";
    private final String namespace;
    private final URL schemaLocation;
    private final Set<Class> managedClasses;
    private final MappingMetaData mappingMetaData;
    private final Map<String, Class> managedClassesByName;
    private final Map<String, Class<? extends PropertyEditor>> propertyEditors;
    private final NamedConstructorArgs namedConstructorArgs = new NamedConstructorArgs();

    public XBeanNamespaceHandler(String namespace, URL schemaLocation, Set<Class> managedClasses, Map<String, Class<? extends PropertyEditor>> propertyEditors, Properties properties) {
        this.namespace = namespace;
        this.schemaLocation = schemaLocation;
        this.managedClasses = managedClasses;
        this.managedClassesByName = this.mapClasses(managedClasses);
        this.propertyEditors = propertyEditors;
        this.mappingMetaData = new MappingMetaData(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XBeanNamespaceHandler(String namespace, String schemaLocation, Bundle bundle, String propertiesLocation) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        URL propertiesUrl = bundle.getResource(propertiesLocation);
        InputStream in = propertiesUrl.openStream();
        Properties properties = new Properties();
        try {
            properties.load(in);
        }
        finally {
            in.close();
        }
        this.namespace = namespace;
        this.schemaLocation = bundle.getEntry(schemaLocation);
        this.managedClasses = XBeanNamespaceHandler.managedClassesFromProperties(bundle, properties);
        this.managedClassesByName = this.mapClasses(this.managedClasses);
        this.propertyEditors = this.propertyEditorsFromProperties(bundle, properties);
        this.mappingMetaData = new MappingMetaData(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XBeanNamespaceHandler(String namespace, String schemaLocation, String propertiesLocation) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        ClassLoader cl = this.getClass().getClassLoader();
        URL propertiesUrl = cl.getResource(propertiesLocation);
        if (propertiesUrl == null) {
            throw new IOException("Could not locate properties at " + propertiesLocation);
        }
        InputStream in = propertiesUrl.openStream();
        Properties properties = new Properties();
        try {
            properties.load(in);
        }
        finally {
            in.close();
        }
        this.namespace = namespace;
        this.schemaLocation = cl.getResource(schemaLocation);
        this.managedClasses = XBeanNamespaceHandler.managedClassesFromProperties(cl, properties);
        this.managedClassesByName = this.mapClasses(this.managedClasses);
        this.propertyEditors = this.propertyEditorsFromProperties(cl, properties);
        this.mappingMetaData = new MappingMetaData(properties);
    }

    private static Set<Class> managedClassesFromProperties(ClassLoader cl, Properties properties) {
        HashSet<Class> managedClasses = new HashSet<Class>();
        Properties methods = new Properties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            if (key.indexOf(".") >= 0) continue;
            String className = (String)entry.getValue();
            try {
                Class<?> beanClass = cl.loadClass(className);
                managedClasses.add(beanClass);
                XBeanNamespaceHandler.findAnnotations(key, beanClass, methods);
            }
            catch (NoClassDefFoundError e) {
                LOGGER.warn("Could not load class: {} due to {}", (Object)className, (Object)e.getMessage());
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn("Could not load class: {}", (Object)className);
            }
        }
        properties.putAll((Map<?, ?>)methods);
        return managedClasses;
    }

    private static Set<Class> managedClassesFromProperties(Bundle bundle, Properties properties) {
        HashSet<Class> managedClasses = new HashSet<Class>();
        Properties methods = new Properties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            if (key.indexOf(".") >= 0) continue;
            String className = (String)entry.getValue();
            try {
                Class beanClass = bundle.loadClass(className);
                managedClasses.add(beanClass);
                XBeanNamespaceHandler.findAnnotations(key, beanClass, methods);
            }
            catch (NoClassDefFoundError e) {
                LOGGER.warn("Could not load class: {} due to {}", (Object)className, (Object)e.getMessage());
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn("Could not load class: {}", (Object)className);
            }
        }
        properties.putAll((Map<?, ?>)methods);
        return managedClasses;
    }

    private static void findAnnotations(String key, Class<?> beanClass, Properties methods) {
        for (Method m : beanClass.getMethods()) {
            if (m.isAnnotationPresent(PostConstruct.class)) {
                methods.put(key + ".initMethod", m.getName());
            }
            if (!m.isAnnotationPresent(PreDestroy.class)) continue;
            methods.put(key + ".destroyMethod", m.getName());
        }
    }

    private Map<String, Class<? extends PropertyEditor>> propertyEditorsFromProperties(Bundle bundle, Properties properties) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        HashMap<String, Class<? extends PropertyEditor>> propertyEditors = new HashMap<String, Class<? extends PropertyEditor>>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.endsWith(".propertyEditor")) continue;
            String className = (String)entry.getValue();
            Class<PropertyEditor> clazz = bundle.loadClass(className).asSubclass(PropertyEditor.class);
            propertyEditors.put(className, clazz);
        }
        return propertyEditors;
    }

    private Map<String, Class<? extends PropertyEditor>> propertyEditorsFromProperties(ClassLoader classLoader, Properties properties) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        HashMap<String, Class<? extends PropertyEditor>> propertyEditors = new HashMap<String, Class<? extends PropertyEditor>>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.endsWith(".propertyEditor")) continue;
            String className = (String)entry.getValue();
            Class<PropertyEditor> clazz = classLoader.loadClass(className).asSubclass(PropertyEditor.class);
            propertyEditors.put(className, clazz);
        }
        return propertyEditors;
    }

    private Map<String, Class> mapClasses(Set<Class> managedClasses) {
        HashMap<String, Class> map = new HashMap<String, Class>();
        for (Class clazz : managedClasses) {
            map.put(clazz.getName(), clazz);
        }
        return map;
    }

    public URL getSchemaLocation(String s) {
        if (this.namespace.equals(s)) {
            return this.schemaLocation;
        }
        return null;
    }

    public Set<Class> getManagedClasses() {
        return this.managedClasses;
    }

    public Metadata parse(Element element, ParserContext parserContext) {
        String beanTypeName = element.getLocalName();
        String className = this.mappingMetaData.getClassName(beanTypeName);
        if (className == null) {
            throw new ComponentDefinitionException(beanTypeName + " not known to xbean namespace handler for " + this.namespace);
        }
        return this.parseInternal(element, parserContext, beanTypeName, className);
    }

    private Metadata parseInternal(Element element, ParserContext parserContext, String beanTypeName, String className) {
        MutableBeanMetadata beanMetaData = (MutableBeanMetadata)parserContext.createMetadata(MutableBeanMetadata.class);
        beanMetaData.setClassName(className);
        beanMetaData.setScope("singleton");
        beanMetaData.setActivation(1);
        beanMetaData.setRuntimeClass(this.managedClassesByName.get(className));
        if (beanMetaData.getRuntimeClass() == null) {
            throw new ComponentDefinitionException("Unknown bean class: " + className);
        }
        if (element.hasAttributeNS(BLUEPRINT_NAMESPACE, "id")) {
            String id = element.getAttributeNS(BLUEPRINT_NAMESPACE, "id");
            beanMetaData.setId(id);
        } else {
            beanMetaData.setId(parserContext.generateId());
        }
        this.lifecycleMethods(beanTypeName, beanMetaData);
        this.attributeProperties(element, parserContext, beanTypeName, beanMetaData);
        this.contentProperty(beanMetaData, element, parserContext);
        this.nestedProperties(beanMetaData, element, beanTypeName, className, parserContext);
        this.coerceNamespaceAwarePropertyValues(beanMetaData, element, parserContext);
        this.namedConstructorArgs.processParameters(beanMetaData, this.mappingMetaData, parserContext);
        return beanMetaData;
    }

    private void lifecycleMethods(String beanTypeName, MutableBeanMetadata beanMetaData) {
        String factoryMethod;
        String destroyMethod;
        String initMethod = this.mappingMetaData.getInitMethodName(beanTypeName);
        if (initMethod != null) {
            beanMetaData.setInitMethod(initMethod);
        }
        if ((destroyMethod = this.mappingMetaData.getDestroyMethodName(beanTypeName)) != null) {
            beanMetaData.setDestroyMethod(destroyMethod);
        }
        if ((factoryMethod = this.mappingMetaData.getFactoryMethodName(beanTypeName)) != null) {
            beanMetaData.setFactoryMethod(factoryMethod);
        }
    }

    private void attributeProperties(Element element, ParserContext parserContext, String beanTypeName, MutableBeanMetadata beanMetaData) {
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (!this.namespace.equals(attr.getNamespaceURI()) && attr.getNamespaceURI() != null) continue;
            String attrName = attr.getLocalName();
            String value = attr.getValue().trim();
            String propertyName = this.mappingMetaData.getPropertyName(beanTypeName, attrName);
            String propertyEditor = this.mappingMetaData.getPropertyEditor(beanTypeName, attrName);
            this.addProperty(propertyName, value, propertyEditor, beanMetaData, parserContext);
        }
    }

    private void contentProperty(MutableBeanMetadata definition, Element element, ParserContext parserContext) {
        String name = this.mappingMetaData.getContentProperty(element.getLocalName());
        String propertyEditor = this.mappingMetaData.getPropertyEditor(element.getLocalName(), name);
        if (name != null) {
            String value = this.getElementText(element).trim();
            this.addProperty(name, value, propertyEditor, definition, parserContext);
        } else {
            ByteArrayInputStream in = new ByteArrayInputStream(this.getElementText(element).getBytes());
            Properties properties = new Properties();
            try {
                properties.load(in);
            }
            catch (IOException e) {
                return;
            }
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                this.addProperty(key, value, propertyEditor, definition, parserContext);
            }
        }
    }

    private void addProperty(String name, String value, String propertyEditor, MutableBeanMetadata definition, ParserContext parserContext) {
        Metadata m = this.getValue(value, propertyEditor, parserContext);
        definition.addProperty(name, m);
    }

    private void nestedProperties(MutableBeanMetadata beanMetadata, Element element, String beanTypeName, String className, ParserContext parserContext) {
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            String text;
            Node node = nodes.item(i);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            String childName = child.getLocalName();
            String namespace = child.getNamespaceURI();
            if (!this.namespace.equals(namespace)) {
                BeanProperty prop = (BeanProperty)parserContext.parseElement(BeanProperty.class, (ComponentMetadata)beanMetadata, child);
                beanMetadata.addProperty(prop);
                continue;
            }
            Metadata childMetadata = null;
            PropertyDescriptor pd = this.getPropertyDescriptor(this.mappingMetaData.getClassName(beanTypeName), childName);
            Class<?> propertyType = pd == null ? null : pd.getPropertyType();
            String propertyName = this.mappingMetaData.getNestedListProperty(beanTypeName, childName);
            boolean isList = false;
            if (propertyName != null || this.isCollectionType(propertyType)) {
                propertyName = propertyName == null ? childName : propertyName;
                childMetadata = (Metadata)parserContext.parseElement(CollectionMetadata.class, (ComponentMetadata)beanMetadata, child);
            } else {
                propertyName = this.mappingMetaData.getFlatCollectionProperty(beanTypeName, childName);
                if (propertyName != null) {
                    MutableCollectionMetadata listMeta;
                    Metadata elementMetadata = this.parse(child, parserContext);
                    BeanProperty list = XBeanNamespaceHandler.propertyByName(propertyName, (BeanMetadata)beanMetadata);
                    if (list == null) {
                        listMeta = (MutableCollectionMetadata)parserContext.createMetadata(MutableCollectionMetadata.class);
                        childMetadata = listMeta;
                    } else {
                        listMeta = (MutableCollectionMetadata)list.getValue();
                    }
                    isList = true;
                    listMeta.addValue(elementMetadata);
                } else {
                    propertyName = this.mappingMetaData.getNestedProperty(beanTypeName, childName);
                    if (propertyName != null) {
                        childMetadata = this.parseChildExtensionBean(child, beanMetadata, parserContext);
                    } else if (this.mappingMetaData.isFlatProperty(beanTypeName, childName)) {
                        propertyName = childName;
                        String flatClassName = this.getPropertyDescriptor(this.mappingMetaData.getClassName(beanTypeName), childName).getPropertyType().getName();
                        childMetadata = this.parseInternal(child, parserContext, childName, flatClassName);
                    } else {
                        childMetadata = this.tryParseNestedPropertyViaIntrospection(beanMetadata, className, child, parserContext);
                        propertyName = childName;
                    }
                }
            }
            if (childMetadata == null && !isList && (text = this.getElementText(child)) != null) {
                MutableValueMetadata m = (MutableValueMetadata)parserContext.createMetadata(MutableValueMetadata.class);
                m.setStringValue(text.trim());
                childMetadata = m;
            }
            if (childMetadata == null) continue;
            beanMetadata.addProperty(propertyName, childMetadata);
        }
    }

    private Metadata parseChildExtensionBean(Element child, MutableBeanMetadata beanMetadata, ParserContext parserContext) {
        NodeList nl = child.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element childElement = (Element)node;
            String uri = childElement.getNamespaceURI();
            String localName = childElement.getLocalName();
            Metadata value = (Metadata)parserContext.parseElement(Metadata.class, (ComponentMetadata)beanMetadata, childElement);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    private Metadata tryParseNestedPropertyViaIntrospection(MutableBeanMetadata beanMetadata, String className, Element element, ParserContext parserContext) {
        String localName = element.getLocalName();
        PropertyDescriptor descriptor = this.getPropertyDescriptor(className, localName);
        if (descriptor != null) {
            return this.parseNestedPropertyViaIntrospection(beanMetadata, element, descriptor.getName(), descriptor.getPropertyType(), parserContext);
        }
        return this.parseNestedPropertyViaIntrospection(beanMetadata, element, localName, Object.class, parserContext);
    }

    private Metadata parseNestedPropertyViaIntrospection(MutableBeanMetadata beanMetadata, Element element, String propertyName, Class propertyType, ParserContext parserContext) {
        if (this.isMap(propertyType)) {
            return this.parseCustomMapElement(beanMetadata, element, propertyName, parserContext);
        }
        if (this.isCollection(propertyType)) {
            return (Metadata)parserContext.parseElement(CollectionMetadata.class, (ComponentMetadata)beanMetadata, element);
        }
        return this.parseChildExtensionBean(element, beanMetadata, parserContext);
    }

    private boolean isMap(Class type) {
        return Map.class.isAssignableFrom(type);
    }

    private boolean isCollection(Class type) {
        return type.isArray() || Collection.class.isAssignableFrom(type);
    }

    protected String getLocalName(Element element) {
        String localName = element.getLocalName();
        if (localName == null) {
            localName = element.getNodeName();
        }
        return localName;
    }

    protected Metadata parseCustomMapElement(MutableBeanMetadata beanMetadata, Element element, String name, ParserContext parserContext) {
        MutableMapMetadata map = (MutableMapMetadata)parserContext.createMetadata(MutableMapMetadata.class);
        Element parent = (Element)element.getParentNode();
        String entryName = this.mappingMetaData.getMapEntryName(this.getLocalName(parent), name);
        String keyName = this.mappingMetaData.getMapKeyName(this.getLocalName(parent), name);
        String dups = this.mappingMetaData.getMapDupsMode(this.getLocalName(parent), name);
        boolean flat = this.mappingMetaData.isFlatMap(this.getLocalName(parent), name);
        String defaultKey = this.mappingMetaData.getMapDefaultKey(this.getLocalName(parent), name);
        if (entryName == null) {
            entryName = "property";
        }
        if (keyName == null) {
            keyName = "key";
        }
        if (dups == null) {
            dups = "replace";
        }
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            NonNullMetadata keyValue;
            String key;
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element childElement = (Element)node;
            String localName = childElement.getLocalName();
            String uri = childElement.getNamespaceURI();
            if (localName == null || localName.equals("xmlns") || localName.startsWith("xmlns:")) continue;
            if (!flat && !this.isEmpty(uri) && localName.equals(entryName)) {
                key = childElement.getAttributeNS(uri, keyName);
                if (key == null || key.length() == 0) {
                    key = defaultKey;
                }
                if (key == null) {
                    throw new RuntimeException("No key defined for map " + entryName);
                }
                keyValue = (NonNullMetadata)this.getValue(key, this.mappingMetaData.getPropertyEditor(localName, key), parserContext);
                Element valueElement = this.getFirstChildElement(childElement);
                Metadata value = valueElement != null ? (Metadata)parserContext.parseElement(Metadata.class, (ComponentMetadata)beanMetadata, valueElement) : this.getValue(this.getElementText(childElement), this.mappingMetaData.getPropertyEditor(localName, key), parserContext);
                this.addValueToMap(map, keyValue, value, dups, parserContext);
                continue;
            }
            if (!flat || this.isEmpty(uri)) continue;
            key = childElement.getAttributeNS(uri, keyName);
            if (key == null || key.length() == 0) {
                key = defaultKey;
            }
            if (key == null) {
                throw new RuntimeException("No key defined for map entry " + entryName);
            }
            keyValue = (NonNullMetadata)this.getValue(key, this.mappingMetaData.getPropertyEditor(localName, key), parserContext);
            childElement = this.cloneElement(childElement);
            childElement.removeAttributeNS(uri, keyName);
            Metadata bdh = this.parse(childElement, parserContext);
            this.addValueToMap(map, keyValue, bdh, dups, parserContext);
        }
        return map;
    }

    protected Element cloneElement(Element element) {
        Element answer = element.getOwnerDocument().createElementNS(element.getNamespaceURI(), element.getNodeName());
        NamedNodeMap attributes = element.getAttributes();
        int size = attributes.getLength();
        for (int i = 0; i < size; ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String uri = attribute.getNamespaceURI();
            answer.setAttributeNS(uri, attribute.getName(), attribute.getNodeValue());
        }
        return answer;
    }

    protected void addValueToMap(MutableMapMetadata map, NonNullMetadata keyValue, Metadata value, String dups, ParserContext parserContext) {
        if (this.hasKey(map, keyValue)) {
            if (!"discard".equalsIgnoreCase(dups)) {
                if ("replace".equalsIgnoreCase(dups)) {
                    map.addEntry(keyValue, value);
                } else if ("allow".equalsIgnoreCase(dups)) {
                    MutableCollectionMetadata l = (MutableCollectionMetadata)parserContext.createMetadata(MutableCollectionMetadata.class);
                    l.addValue(this.get(map, keyValue));
                    l.addValue(value);
                    map.addEntry(keyValue, (Metadata)l);
                } else if ("always".equalsIgnoreCase(dups)) {
                    MutableCollectionMetadata l = (MutableCollectionMetadata)this.get(map, keyValue);
                    l.addValue(value);
                }
            }
        } else if ("always".equalsIgnoreCase(dups)) {
            MutableCollectionMetadata l = (MutableCollectionMetadata)this.get(map, keyValue);
            if (l == null) {
                l = (MutableCollectionMetadata)parserContext.createMetadata(MutableCollectionMetadata.class);
                map.addEntry(keyValue, (Metadata)l);
            }
            l.addValue(value);
        } else {
            map.addEntry(keyValue, value);
        }
    }

    private Metadata get(MutableMapMetadata map, NonNullMetadata keyValue) {
        for (MapEntry entry : map.getEntries()) {
            if (!this.equals(entry.getKey(), keyValue)) continue;
            return entry.getValue();
        }
        return null;
    }

    private boolean equals(NonNullMetadata key1, NonNullMetadata key2) {
        if (key1 == key2) {
            return true;
        }
        if (key1.getClass() != key2.getClass()) {
            return false;
        }
        if (key1 instanceof RefMetadata) {
            return ((RefMetadata)key1).getComponentId().equals(((RefMetadata)key2).getComponentId());
        }
        if (key1 instanceof ReferenceMetadata && ((ReferenceMetadata)key1).getTimeout() != ((ReferenceMetadata)key2).getTimeout()) {
            return false;
        }
        if (key1 instanceof ServiceReferenceMetadata) {
            ServiceReferenceMetadata sr1 = (ServiceReferenceMetadata)key1;
            ServiceReferenceMetadata sr2 = (ServiceReferenceMetadata)key2;
            return sr1.getAvailability() == sr2.getAvailability() && sr1.getInterface().equals(sr2.getInterface()) && sr1.getComponentName().equals(sr2.getComponentName()) && sr1.getFilter().equals(sr2.getFilter()) && ((Object)sr1.getReferenceListeners()).equals(sr2.getReferenceListeners()) && sr1.getId().equals(sr2.getId()) && sr1.getActivation() == sr2.getActivation() && ((Object)sr1.getDependsOn()).equals(sr2.getDependsOn());
        }
        if (key1 instanceof ValueMetadata) {
            ValueMetadata v1 = (ValueMetadata)key1;
            ValueMetadata v2 = (ValueMetadata)key2;
            if (v1.getStringValue() != null ? v1.getStringValue().equals(v2.getStringValue()) : (v2.getStringValue() == null && v1.getType() != null ? v1.getType().equals(v2.getType()) : v2.getType() == null)) {
                return true;
            }
        }
        return false;
    }

    private boolean hasKey(MutableMapMetadata map, NonNullMetadata keyValue) {
        return this.get(map, keyValue) != null;
    }

    protected boolean isEmpty(String uri) {
        return uri == null || uri.length() == 0;
    }

    protected Metadata getValue(String value, String propertyEditorName, ParserContext parserContext) {
        if (value == null) {
            return null;
        }
        if (NULL_REFERENCE.equals(value)) {
            return parserContext.createMetadata(NullMetadata.class);
        }
        if (value.startsWith(BEAN_REFERENCE_PREFIX) && !(value = value.substring(BEAN_REFERENCE_PREFIX.length())).startsWith(BEAN_REFERENCE_PREFIX)) {
            MutableRefMetadata ref = (MutableRefMetadata)parserContext.createMetadata(MutableRefMetadata.class);
            ref.setComponentId(value);
            return ref;
        }
        if (propertyEditorName != null) {
            MutableBeanMetadata factory = (MutableBeanMetadata)parserContext.createMetadata(MutableBeanMetadata.class);
            factory.setRuntimeClass(this.propertyEditors.get(propertyEditorName));
            MutableValueMetadata metadata = (MutableValueMetadata)parserContext.createMetadata(MutableValueMetadata.class);
            metadata.setStringValue(value);
            factory.addProperty("asText", (Metadata)metadata);
            MutableBeanMetadata bean = (MutableBeanMetadata)parserContext.createMetadata(MutableBeanMetadata.class);
            bean.setFactoryComponent((Target)factory);
            bean.setFactoryMethod("getValue");
            return bean;
        }
        MutableValueMetadata metadata = (MutableValueMetadata)parserContext.createMetadata(MutableValueMetadata.class);
        metadata.setStringValue(value);
        return metadata;
    }

    protected Element getFirstChildElement(Element element) {
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            return (Element)node;
        }
        return null;
    }

    private boolean isCollectionType(Class propertyType) {
        if (propertyType == null) {
            return false;
        }
        if (Collection.class.isAssignableFrom(propertyType)) {
            return true;
        }
        return propertyType.isArray();
    }

    public static BeanProperty propertyByName(String name, BeanMetadata meta) {
        for (BeanProperty prop : meta.getProperties()) {
            if (!name.equals(prop.getName())) continue;
            return prop;
        }
        return null;
    }

    public ComponentMetadata decorate(Node node, ComponentMetadata componentMetadata, ParserContext parserContext) {
        return componentMetadata;
    }

    private void coerceNamespaceAwarePropertyValues(MutableBeanMetadata bd, Element element, ParserContext parserContext) {
        BeanInfo beanInfo = this.getBeanInfo(this.getClass(bd.getClassName()));
        if (beanInfo != null) {
            PropertyDescriptor[] descriptors;
            for (PropertyDescriptor descriptor : descriptors = beanInfo.getPropertyDescriptors()) {
                QNameHelper.coerceNamespaceAwarePropertyValues(bd, element, descriptor, parserContext);
            }
        }
    }

    private PropertyDescriptor getPropertyDescriptor(String className, String localName) {
        Class clazz = this.getClass(className);
        return this.getPropertyDescriptor(clazz, localName);
    }

    private PropertyDescriptor getPropertyDescriptor(Class clazz, String localName) {
        BeanInfo beanInfo = this.getBeanInfo(clazz);
        if (beanInfo != null) {
            PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < descriptors.length; ++i) {
                PropertyDescriptor descriptor = descriptors[i];
                String name = descriptor.getName();
                if (!name.equals(localName)) continue;
                return descriptor;
            }
        }
        return null;
    }

    private Class getClass(String className) throws ComponentDefinitionException {
        if (className == null) {
            return null;
        }
        Class type = this.managedClassesByName.get(className);
        if (type == null) {
            throw new ComponentDefinitionException("Unknown type: " + className);
        }
        return type;
    }

    private BeanInfo getBeanInfo(Class type) {
        if (type == null) {
            return null;
        }
        try {
            return Introspector.getBeanInfo(type);
        }
        catch (IntrospectionException e) {
            throw new ComponentDefinitionException("Failed to introspect type: " + type.getName() + ". Reason: " + e, (Throwable)e);
        }
    }

    private String getElementText(Element element) {
        StringBuilder buffer = new StringBuilder();
        NodeList nodeList = element.getChildNodes();
        int size = nodeList.getLength();
        for (int i = 0; i < size; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 3 && node.getNodeType() != 4) continue;
            buffer.append(node.getNodeValue());
        }
        return buffer.toString();
    }
}

