/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.truth.xml;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.truth.xml.spi.Event;
import org.apache.axiom.truth.xml.spi.Traverser;
import org.w3c.dom.Attr;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

final class DOMTraverser
implements Traverser {
    private final Node root;
    private final boolean expandEntityReferences;
    private Node node;
    private boolean descend;

    DOMTraverser(Node root, boolean expandEntityReferences) {
        this.root = root;
        this.expandEntityReferences = expandEntityReferences;
        if (root.getNodeType() == 9) {
            this.node = root;
            this.descend = true;
        }
    }

    @Override
    public Event next() {
        block10: while (true) {
            boolean visited;
            if (this.node == null) {
                this.node = this.root;
                visited = false;
            } else if (this.descend) {
                Node firstChild = this.node.getFirstChild();
                if (firstChild != null) {
                    this.node = firstChild;
                    visited = false;
                } else {
                    visited = true;
                }
            } else {
                Node nextSibling = this.node.getNextSibling();
                if (this.node == this.root) {
                    return null;
                }
                if (nextSibling != null) {
                    this.node = nextSibling;
                    visited = false;
                } else {
                    this.node = this.node.getParentNode();
                    visited = true;
                }
            }
            switch (this.node.getNodeType()) {
                case 9: {
                    return null;
                }
                case 10: {
                    this.descend = false;
                    return Event.DOCUMENT_TYPE;
                }
                case 1: {
                    if (!visited) {
                        this.descend = true;
                        return Event.START_ELEMENT;
                    }
                    this.descend = false;
                    return Event.END_ELEMENT;
                }
                case 3: {
                    this.descend = false;
                    return ((Text)this.node).isElementContentWhitespace() ? Event.WHITESPACE : Event.TEXT;
                }
                case 5: {
                    if (this.expandEntityReferences) {
                        this.descend = !visited;
                        continue block10;
                    }
                    this.descend = false;
                    return Event.ENTITY_REFERENCE;
                }
                case 8: {
                    this.descend = false;
                    return Event.COMMENT;
                }
                case 4: {
                    this.descend = false;
                    return Event.CDATA_SECTION;
                }
                case 7: {
                    this.descend = false;
                    return Event.PROCESSING_INSTRUCTION;
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    @Override
    public String getRootName() {
        return ((DocumentType)this.node).getName();
    }

    @Override
    public String getPublicId() {
        return ((DocumentType)this.node).getPublicId();
    }

    @Override
    public String getSystemId() {
        return ((DocumentType)this.node).getSystemId();
    }

    private static QName getQName(Node node) {
        String localName = node.getLocalName();
        if (localName == null) {
            return new QName(node.getNodeName());
        }
        return new QName(node.getNamespaceURI(), node.getLocalName(), Strings.nullToEmpty((String)node.getPrefix()));
    }

    @Override
    public QName getQName() {
        return DOMTraverser.getQName(this.node);
    }

    @Override
    public Map<QName, String> getAttributes() {
        HashMap<QName, String> result = null;
        NamedNodeMap attributes = this.node.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attr = (Attr)attributes.item(i);
            if ("http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI())) continue;
            if (result == null) {
                result = new HashMap<QName, String>();
            }
            result.put(DOMTraverser.getQName(attr), attr.getValue());
        }
        return result;
    }

    @Override
    public Map<String, String> getNamespaces() {
        HashMap<String, String> result = null;
        NamedNodeMap attributes = this.node.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String prefix;
            Attr attr = (Attr)attributes.item(i);
            if (!"http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI())) continue;
            if (result == null) {
                result = new HashMap<String, String>();
            }
            result.put("xmlns".equals(prefix = attr.getPrefix()) ? attr.getLocalName() : "", attr.getValue());
        }
        return result;
    }

    @Override
    public String getText() {
        return this.node.getNodeValue();
    }

    @Override
    public String getEntityName() {
        return this.node.getNodeName();
    }

    @Override
    public String getPITarget() {
        return ((ProcessingInstruction)this.node).getTarget();
    }

    @Override
    public String getPIData() {
        return ((ProcessingInstruction)this.node).getData();
    }
}

