/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.truth.xml;

import com.google.common.truth.FailureStrategy;
import com.google.common.truth.SubjectFactory;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ServiceLoader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import org.apache.axiom.truth.xml.DOMXML;
import org.apache.axiom.truth.xml.StAXXML;
import org.apache.axiom.truth.xml.XML;
import org.apache.axiom.truth.xml.XMLFactory;
import org.apache.axiom.truth.xml.XMLSubject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public final class XMLTruth {
    private static final SubjectFactory<XMLSubject, XML> SUBJECT_FACTORY = new SubjectFactory<XMLSubject, XML>(){

        public XMLSubject getSubject(FailureStrategy fs, XML that) {
            return new XMLSubject(fs, that);
        }
    };
    private static final ServiceLoader<XMLFactory> factoryLoader = ServiceLoader.load(XMLFactory.class, XMLTruth.class.getClassLoader());

    private XMLTruth() {
    }

    public static SubjectFactory<XMLSubject, XML> xml() {
        return SUBJECT_FACTORY;
    }

    public static XML xml(Document document) {
        return new DOMXML(document);
    }

    public static XML xml(Element element) {
        return new DOMXML(element);
    }

    public static XML xml(InputSource is) {
        final StreamSource source = new StreamSource();
        source.setInputStream(is.getByteStream());
        source.setReader(is.getCharacterStream());
        source.setPublicId(is.getPublicId());
        source.setSystemId(is.getSystemId());
        return new StAXXML(){

            @Override
            XMLStreamReader createXMLStreamReader(XMLInputFactory factory) throws XMLStreamException {
                return factory.createXMLStreamReader(source);
            }
        };
    }

    public static XML xml(final InputStream in) {
        return new StAXXML(){

            @Override
            XMLStreamReader createXMLStreamReader(XMLInputFactory factory) throws XMLStreamException {
                return factory.createXMLStreamReader(in);
            }
        };
    }

    public static XML xml(final Reader reader) {
        return new StAXXML(){

            @Override
            XMLStreamReader createXMLStreamReader(XMLInputFactory factory) throws XMLStreamException {
                return factory.createXMLStreamReader(reader);
            }
        };
    }

    public static XML xml(final URL url) {
        return new StAXXML(){

            @Override
            XMLStreamReader createXMLStreamReader(XMLInputFactory factory) throws XMLStreamException {
                return factory.createXMLStreamReader(new StreamSource(url.toString()));
            }
        };
    }

    public static XML xml(String xml) {
        return XMLTruth.xml(new StringReader(xml));
    }

    public static XML xml(byte[] bytes) {
        return XMLTruth.xml(new ByteArrayInputStream(bytes));
    }

    public static XML xml(Object object) {
        for (XMLFactory factory : factoryLoader) {
            if (!factory.getExpectedType().isInstance(object)) continue;
            return XMLTruth.xml(factory, object);
        }
        throw new IllegalArgumentException();
    }

    private static <T> XML xml(XMLFactory<T> factory, Object object) {
        return factory.createXML(factory.getExpectedType().cast(object));
    }
}

