/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.truth.xml;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.truth.xml.Event;
import org.apache.axiom.truth.xml.Traverser;
import org.apache.axiom.truth.xml.TraverserException;
import org.codehaus.stax2.DTDInfo;

final class StAXTraverser
implements Traverser {
    private final XMLStreamReader reader;

    StAXTraverser(XMLStreamReader reader) {
        this.reader = reader;
    }

    @Override
    public Event next() throws TraverserException {
        try {
            if (this.reader.hasNext()) {
                switch (this.reader.next()) {
                    case 11: {
                        return Event.DOCUMENT_TYPE;
                    }
                    case 1: {
                        return Event.START_ELEMENT;
                    }
                    case 2: {
                        return Event.END_ELEMENT;
                    }
                    case 4: {
                        return Event.TEXT;
                    }
                    case 6: {
                        return Event.WHITESPACE;
                    }
                    case 9: {
                        return Event.ENTITY_REFERENCE;
                    }
                    case 5: {
                        return Event.COMMENT;
                    }
                    case 12: {
                        return Event.CDATA_SECTION;
                    }
                    case 3: {
                        return Event.PROCESSING_INSTRUCTION;
                    }
                    case 8: {
                        return null;
                    }
                }
                throw new IllegalStateException();
            }
            return null;
        }
        catch (XMLStreamException ex) {
            throw new TraverserException(ex);
        }
    }

    @Override
    public String getRootName() {
        return ((DTDInfo)this.reader).getDTDRootName();
    }

    @Override
    public String getPublicId() {
        return ((DTDInfo)this.reader).getDTDPublicId();
    }

    @Override
    public String getSystemId() {
        return ((DTDInfo)this.reader).getDTDSystemId();
    }

    @Override
    public QName getQName() {
        return this.reader.getName();
    }

    @Override
    public Map<QName, String> getAttributes() {
        int attributeCount = this.reader.getAttributeCount();
        if (attributeCount == 0) {
            return null;
        }
        HashMap<QName, String> attributes = new HashMap<QName, String>();
        for (int i = 0; i < attributeCount; ++i) {
            attributes.put(this.reader.getAttributeName(i), this.reader.getAttributeValue(i));
        }
        return attributes;
    }

    @Override
    public Map<String, String> getNamespaces() {
        int namespaceCount = this.reader.getNamespaceCount();
        if (namespaceCount == 0) {
            return null;
        }
        HashMap<String, String> namespaces = new HashMap<String, String>();
        for (int i = 0; i < namespaceCount; ++i) {
            namespaces.put(Strings.nullToEmpty((String)this.reader.getNamespacePrefix(i)), this.reader.getNamespaceURI(i));
        }
        return namespaces;
    }

    @Override
    public String getText() {
        return this.reader.getText();
    }

    @Override
    public String getEntityName() {
        return this.reader.getLocalName();
    }

    @Override
    public String getPITarget() {
        return this.reader.getPITarget();
    }

    @Override
    public String getPIData() {
        return this.reader.getPIData();
    }
}

