/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.testutils.activation;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import javax.activation.DataSource;
import org.apache.commons.io.input.ProxyInputStream;

public final class InstrumentedDataSource
implements DataSource {
    private final DataSource parent;
    private final AtomicInteger openStreamCount = new AtomicInteger();

    public InstrumentedDataSource(DataSource parent) {
        this.parent = parent;
    }

    public String getContentType() {
        return this.parent.getContentType();
    }

    public InputStream getInputStream() throws IOException {
        ProxyInputStream in = new ProxyInputStream(this.parent.getInputStream()){

            public void close() throws IOException {
                super.close();
                InstrumentedDataSource.this.openStreamCount.decrementAndGet();
            }
        };
        this.openStreamCount.incrementAndGet();
        return in;
    }

    public String getName() {
        return this.parent.getName();
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    public int getOpenStreamCount() {
        return this.openStreamCount.get();
    }
}

