/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.testutils.stax;

import java.util.Iterator;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;

final class AttributeSortingXMLStreamReaderFilter
extends StreamReaderDelegate {
    private int[] indexMap;

    public AttributeSortingXMLStreamReaderFilter(XMLStreamReader reader) {
        super(reader);
    }

    @Override
    public int next() throws XMLStreamException {
        this.indexMap = null;
        return super.next();
    }

    @Override
    public int nextTag() throws XMLStreamException {
        this.indexMap = null;
        return super.nextTag();
    }

    private int getIndex(int index) {
        if (this.indexMap == null) {
            int n = super.getAttributeCount();
            this.indexMap = new int[n];
            TreeMap<String, Integer> map = new TreeMap<String, Integer>();
            for (int i = 0; i < n; ++i) {
                map.put(super.getAttributeName(i).toString(), i);
            }
            int newIndex = 0;
            Iterator i$ = map.values().iterator();
            while (i$.hasNext()) {
                int orgIndex = (Integer)i$.next();
                this.indexMap[newIndex++] = orgIndex;
            }
        }
        return this.indexMap[index];
    }

    @Override
    public String getAttributeLocalName(int index) {
        return super.getAttributeLocalName(this.getIndex(index));
    }

    @Override
    public QName getAttributeName(int index) {
        return super.getAttributeName(this.getIndex(index));
    }

    @Override
    public String getAttributeNamespace(int index) {
        return super.getAttributeNamespace(this.getIndex(index));
    }

    @Override
    public String getAttributePrefix(int index) {
        return super.getAttributePrefix(this.getIndex(index));
    }

    @Override
    public String getAttributeType(int index) {
        return super.getAttributeType(this.getIndex(index));
    }

    @Override
    public String getAttributeValue(int index) {
        return super.getAttributeValue(this.getIndex(index));
    }
}

