/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.springws.scenario.broker;

import java.util.Locale;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.springws.scenario.ScenarioConfig;
import org.apache.axiom.ts.springws.scenario.ScenarioTestCase;
import org.apache.axiom.ts.springws.scenario.broker.BrokerClient;
import org.apache.axiom.ts.springws.scenario.broker.Order;
import org.apache.axiom.ts.springws.scenario.broker.OrderStatus;
import org.springframework.ws.soap.client.SoapFaultClientException;

public class BrokerScenarioTest
extends ScenarioTestCase {
    public BrokerScenarioTest(ScenarioConfig config, SOAPSpec spec) {
        super(config, spec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runTest() throws Throwable {
        BrokerClient client = (BrokerClient)this.context.getBean(BrokerClient.class);
        Order order = new Order();
        order.setCustomer(47892);
        Order.Item item1 = new Order.Item();
        item1.setStock("GOOG");
        item1.setCount(100);
        Order.Item item2 = new Order.Item();
        item2.setStock("MSFT");
        item2.setCount(10);
        order.setItems(new Order.Item[]{item1, item2});
        OrderStatus status = client.order(order);
        BrokerScenarioTest.assertNotNull((Object)status.getReceived());
        Order receivedOrder = client.receiveNextOrder();
        BrokerScenarioTest.assertNotNull((Object)receivedOrder);
        BrokerScenarioTest.assertEquals((int)order.getCustomer(), (int)receivedOrder.getCustomer());
        BrokerScenarioTest.assertEquals((int)order.getItems().length, (int)receivedOrder.getItems().length);
        BrokerScenarioTest.assertEquals((String)order.getItems()[0].getStock(), (String)receivedOrder.getItems()[0].getStock());
        BrokerScenarioTest.assertEquals((int)order.getItems()[0].getCount(), (int)receivedOrder.getItems()[0].getCount());
        order.setCustomer(23629);
        Locale oldLocale = Locale.getDefault();
        Locale.setDefault(Locale.ENGLISH);
        try {
            client.order(order);
            BrokerScenarioTest.fail((String)"Expected SoapFaultClientException");
        }
        catch (SoapFaultClientException ex) {
            BrokerScenarioTest.assertEquals((Object)this.spec.getSenderFaultCode(), (Object)ex.getFaultCode());
            BrokerScenarioTest.assertEquals((String)"Customer 23629 unknown", (String)ex.getMessage());
        }
        finally {
            Locale.setDefault(oldLocale);
        }
    }
}

