/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.testing.multiton;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.axiom.testing.multiton.AdapterFactory;
import org.apache.axiom.testing.multiton.Adapters;
import org.apache.axiom.testing.multiton.Instances;
import org.apache.axiom.testing.multiton.MultitonInstantiationException;

public abstract class Multiton {
    private static final Map<Class<?>, List<?>> instancesMap = new HashMap();
    private static final Map<Class, List<AdapterFactory>> adapterFactoryMap = new HashMap<Class, List<AdapterFactory>>();
    private final Adapters adapters = new Adapters();

    public static synchronized <T extends Multiton> List<T> getInstances(Class<T> multitonClass) {
        List<?> instances = instancesMap.get(multitonClass);
        if (instances == null) {
            int mod;
            instances = new ArrayList();
            for (Field field : multitonClass.getDeclaredFields()) {
                mod = field.getModifiers();
                if (!Modifier.isPublic(mod) || !Modifier.isStatic(mod) || !Modifier.isFinal(mod) || !multitonClass.isAssignableFrom(field.getType())) continue;
                try {
                    instances.add((Multiton)multitonClass.cast(field.get(null)));
                }
                catch (IllegalAccessException ex) {
                    throw new MultitonInstantiationException(ex);
                }
            }
            for (AccessibleObject accessibleObject : multitonClass.getDeclaredMethods()) {
                if (((Method)accessibleObject).getAnnotation(Instances.class) == null) continue;
                mod = ((Method)accessibleObject).getModifiers();
                if (!Modifier.isPrivate(mod) || !Modifier.isStatic(mod)) {
                    throw new MultitonInstantiationException("Methods annotated with @Instances must be private static");
                }
                if (((Method)accessibleObject).getParameterTypes().length > 0) {
                    throw new MultitonInstantiationException("Methods annotated with @Instances must not take any parameters");
                }
                Class<?> returnType = ((Method)accessibleObject).getReturnType();
                if (!returnType.isArray() || !multitonClass.isAssignableFrom(returnType.getComponentType())) {
                    throw new MultitonInstantiationException("Invalid return type for method annotated with @Instances");
                }
                ((Method)accessibleObject).setAccessible(true);
                try {
                    for (Object instance : (Object[])((Method)accessibleObject).invoke(null, new Object[0])) {
                        instances.add((Multiton)multitonClass.cast(instance));
                    }
                }
                catch (IllegalAccessException ex) {
                    throw new MultitonInstantiationException(ex);
                }
                catch (InvocationTargetException ex) {
                    throw new MultitonInstantiationException(ex.getCause());
                }
            }
            instances = Collections.unmodifiableList(instances);
            instancesMap.put(multitonClass, instances);
        }
        return instances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T getAdapter(Class<T> type) {
        Adapters adapters = this.adapters;
        synchronized (adapters) {
            if (!this.adapters.initialized()) {
                for (Class<?> clazz = this.getClass(); clazz != Multiton.class; clazz = clazz.getSuperclass()) {
                    List<AdapterFactory> adapterFactories = adapterFactoryMap.get(clazz);
                    if (adapterFactories == null) continue;
                    for (AdapterFactory adapterFactory : adapterFactories) {
                        adapterFactory.createAdapters(this, this.adapters);
                    }
                }
            }
            return this.adapters.get(type);
        }
    }

    static {
        for (AdapterFactory adapterFactory : ServiceLoader.load(AdapterFactory.class, Multiton.class.getClassLoader())) {
            Class<Multiton> clazz = ((Class)((ParameterizedType)adapterFactory.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[0]).asSubclass(Multiton.class);
            List<AdapterFactory> adapterFactories = adapterFactoryMap.get(clazz);
            if (adapterFactories == null) {
                adapterFactories = new ArrayList<AdapterFactory>();
                adapterFactoryMap.put(clazz, adapterFactories);
            }
            adapterFactories.add(adapterFactory);
        }
    }
}

