/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.domts.level3.core;

import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;
import org.w3c.domts.DOMTestIncompatibleException;

public final class nodereplacechild38
extends DOMTestCase {
    public nodereplacechild38(DOMTestDocumentBuilderFactory factory) throws DOMTestIncompatibleException {
        super(factory);
        String contentType = this.getContentType();
        this.preload(contentType, "hc_staff", true);
    }

    @Override
    public void runTest() throws Throwable {
        Document doc = this.load("hc_staff", true);
        DocumentType docType = doc.getDoctype();
        NamedNodeMap entitiesMap = docType.getEntities();
        Entity ent = (Entity)entitiesMap.getNamedItem("alpha");
        this.assertNotNull("alphaEntity", ent);
        Text oldChild = (Text)ent.getFirstChild();
        this.assertNotNull("alphaText", oldChild);
        CDATASection cdata = doc.createCDATASection("CDATASection");
        boolean success = false;
        try {
            ent.replaceChild(cdata, oldChild);
        }
        catch (DOMException ex) {
            success = ex.code == 7;
        }
        this.assertTrue("throw_NO_MODIFICATION_ALLOWED_ERR1", success);
        ProcessingInstruction pi = doc.createProcessingInstruction("target", "data");
        success = false;
        try {
            ent.replaceChild(pi, oldChild);
        }
        catch (DOMException ex) {
            success = ex.code == 7;
        }
        this.assertTrue("throw_NO_MODIFICATION_ALLOWED_ERR2", success);
        Comment comment = doc.createComment("Comment");
        success = false;
        try {
            ent.replaceChild(comment, oldChild);
        }
        catch (DOMException ex) {
            success = ex.code == 7;
        }
        this.assertTrue("throw_NO_MODIFICATION_ALLOWED_ERR3", success);
        Text txt = doc.createTextNode("Text");
        success = false;
        try {
            ent.replaceChild(txt, oldChild);
        }
        catch (DOMException ex) {
            success = ex.code == 7;
        }
        this.assertTrue("throw_NO_MODIFICATION_ALLOWED_ERR4", success);
        Element elem = doc.createElementNS("http://www.w3.org/1999/xhtml", "xhtml:p");
        success = false;
        try {
            ent.replaceChild(elem, oldChild);
        }
        catch (DOMException ex) {
            success = ex.code == 7;
        }
        this.assertTrue("throw_NO_MODIFICATION_ALLOWED_ERR5", success);
        EntityReference entRef = doc.createEntityReference("delta");
        success = false;
        try {
            ent.replaceChild(entRef, oldChild);
        }
        catch (DOMException ex) {
            success = ex.code == 7;
        }
        this.assertTrue("throw_NO_MODIFICATION_ALLOWED_ERR6", success);
    }

    @Override
    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level3/core/nodereplacechild38";
    }

    public static void main(String[] args) {
        DOMTestCase.doMain(nodereplacechild38.class, args);
    }
}

